// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Cost information for the product system. </summary>
    public partial class EdgeOrderProductCostInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductCostInformation"/>. </summary>
        internal EdgeOrderProductCostInformation()
        {
            BillingMeterDetails = new ChangeTrackingList<EdgeOrderProductBillingMeterDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductCostInformation"/>. </summary>
        /// <param name="billingMeterDetails"> Details on the various billing aspects for the product system. </param>
        /// <param name="billingInfoUri"> Default url to display billing information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderProductCostInformation(IReadOnlyList<EdgeOrderProductBillingMeterDetails> billingMeterDetails, Uri billingInfoUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingMeterDetails = billingMeterDetails;
            BillingInfoUri = billingInfoUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Details on the various billing aspects for the product system. </summary>
        public IReadOnlyList<EdgeOrderProductBillingMeterDetails> BillingMeterDetails { get; }
        /// <summary> Default url to display billing information. </summary>
        public Uri BillingInfoUri { get; }
    }
}
