// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Charging type. </summary>
    public readonly partial struct EdgeOrderProductChargingType : IEquatable<EdgeOrderProductChargingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductChargingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeOrderProductChargingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PerOrderValue = "PerOrder";
        private const string PerDeviceValue = "PerDevice";

        /// <summary> Per order charging type. </summary>
        public static EdgeOrderProductChargingType PerOrder { get; } = new EdgeOrderProductChargingType(PerOrderValue);
        /// <summary> Per device charging type. </summary>
        public static EdgeOrderProductChargingType PerDevice { get; } = new EdgeOrderProductChargingType(PerDeviceValue);
        /// <summary> Determines if two <see cref="EdgeOrderProductChargingType"/> values are the same. </summary>
        public static bool operator ==(EdgeOrderProductChargingType left, EdgeOrderProductChargingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeOrderProductChargingType"/> values are not the same. </summary>
        public static bool operator !=(EdgeOrderProductChargingType left, EdgeOrderProductChargingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeOrderProductChargingType"/>. </summary>
        public static implicit operator EdgeOrderProductChargingType(string value) => new EdgeOrderProductChargingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeOrderProductChargingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeOrderProductChargingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
