// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Holds billing meter details for each type of billing. </summary>
    public partial class EdgeOrderProductBillingMeterDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductBillingMeterDetails"/>. </summary>
        internal EdgeOrderProductBillingMeterDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductBillingMeterDetails"/>. </summary>
        /// <param name="name"> Represents Billing type name. </param>
        /// <param name="meterDetails">
        /// Represents MeterDetails
        /// Please note <see cref="EdgeOrderProductMeterDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Pav2MeterDetails"/> and <see cref="PurchaseMeterDetails"/>.
        /// </param>
        /// <param name="meteringType"> Represents Metering type (eg one-time or recurrent). </param>
        /// <param name="frequency"> Frequency of recurrence. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderProductBillingMeterDetails(string name, EdgeOrderProductMeterDetails meterDetails, EdgeOrderProductMeteringType? meteringType, string frequency, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            MeterDetails = meterDetails;
            MeteringType = meteringType;
            Frequency = frequency;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents Billing type name. </summary>
        public string Name { get; }
        /// <summary>
        /// Represents MeterDetails
        /// Please note <see cref="EdgeOrderProductMeterDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Pav2MeterDetails"/> and <see cref="PurchaseMeterDetails"/>.
        /// </summary>
        public EdgeOrderProductMeterDetails MeterDetails { get; }
        /// <summary> Represents Metering type (eg one-time or recurrent). </summary>
        public EdgeOrderProductMeteringType? MeteringType { get; }
        /// <summary> Frequency of recurrence. </summary>
        public string Frequency { get; }
    }
}
