// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Order item details. </summary>
    public partial class EdgeOrderItemDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemDetails"/>. </summary>
        /// <param name="productDetails"> Unique identifier for configuration. </param>
        /// <param name="orderItemType"> Order item type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="productDetails"/> is null. </exception>
        public EdgeOrderItemDetails(ProductDetails productDetails, OrderItemType orderItemType)
        {
            Argument.AssertNotNull(productDetails, nameof(productDetails));

            ProductDetails = productDetails;
            OrderItemType = orderItemType;
            OrderItemStageHistory = new ChangeTrackingList<EdgeOrderStageDetails>();
            NotificationEmailList = new ChangeTrackingList<string>();
            ManagementRPDetailsList = new ChangeTrackingList<ResourceProviderDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemDetails"/>. </summary>
        /// <param name="productDetails"> Unique identifier for configuration. </param>
        /// <param name="orderItemType"> Order item type. </param>
        /// <param name="currentStage"> Current Order item Status. </param>
        /// <param name="orderItemStageHistory"> Order item status history. </param>
        /// <param name="preferences"> Customer notification Preferences. </param>
        /// <param name="forwardShippingDetails"> Forward Package Shipping details. </param>
        /// <param name="reverseShippingDetails"> Reverse Package Shipping details. </param>
        /// <param name="notificationEmailList"> Additional notification email list. </param>
        /// <param name="cancellationReason"> Cancellation reason. </param>
        /// <param name="cancellationStatus"> Describes whether the order item is cancellable or not. </param>
        /// <param name="deletionStatus"> Describes whether the order item is deletable or not. </param>
        /// <param name="returnReason"> Return reason. </param>
        /// <param name="returnStatus"> Describes whether the order item is returnable or not. </param>
        /// <param name="firstOrDefaultManagement"> Parent RP details - this returns only the first or default parent RP from the entire list. </param>
        /// <param name="managementRPDetailsList"> List of parent RP details supported for configuration. </param>
        /// <param name="error"> Top level error for the job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderItemDetails(ProductDetails productDetails, OrderItemType orderItemType, EdgeOrderStageDetails currentStage, IReadOnlyList<EdgeOrderStageDetails> orderItemStageHistory, OrderItemPreferences preferences, ForwardShippingDetails forwardShippingDetails, ReverseShippingDetails reverseShippingDetails, IList<string> notificationEmailList, string cancellationReason, OrderItemCancellationStatus? cancellationStatus, EdgeOrderActionStatus? deletionStatus, string returnReason, OrderItemReturnStatus? returnStatus, ResourceProviderDetails firstOrDefaultManagement, IReadOnlyList<ResourceProviderDetails> managementRPDetailsList, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProductDetails = productDetails;
            OrderItemType = orderItemType;
            CurrentStage = currentStage;
            OrderItemStageHistory = orderItemStageHistory;
            Preferences = preferences;
            ForwardShippingDetails = forwardShippingDetails;
            ReverseShippingDetails = reverseShippingDetails;
            NotificationEmailList = notificationEmailList;
            CancellationReason = cancellationReason;
            CancellationStatus = cancellationStatus;
            DeletionStatus = deletionStatus;
            ReturnReason = returnReason;
            ReturnStatus = returnStatus;
            FirstOrDefaultManagement = firstOrDefaultManagement;
            ManagementRPDetailsList = managementRPDetailsList;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemDetails"/> for deserialization. </summary>
        internal EdgeOrderItemDetails()
        {
        }

        /// <summary> Unique identifier for configuration. </summary>
        public ProductDetails ProductDetails { get; set; }
        /// <summary> Order item type. </summary>
        public OrderItemType OrderItemType { get; set; }
        /// <summary> Current Order item Status. </summary>
        public EdgeOrderStageDetails CurrentStage { get; }
        /// <summary> Order item status history. </summary>
        public IReadOnlyList<EdgeOrderStageDetails> OrderItemStageHistory { get; }
        /// <summary> Customer notification Preferences. </summary>
        public OrderItemPreferences Preferences { get; set; }
        /// <summary> Forward Package Shipping details. </summary>
        public ForwardShippingDetails ForwardShippingDetails { get; }
        /// <summary> Reverse Package Shipping details. </summary>
        public ReverseShippingDetails ReverseShippingDetails { get; }
        /// <summary> Additional notification email list. </summary>
        public IList<string> NotificationEmailList { get; }
        /// <summary> Cancellation reason. </summary>
        public string CancellationReason { get; }
        /// <summary> Describes whether the order item is cancellable or not. </summary>
        public OrderItemCancellationStatus? CancellationStatus { get; }
        /// <summary> Describes whether the order item is deletable or not. </summary>
        public EdgeOrderActionStatus? DeletionStatus { get; }
        /// <summary> Return reason. </summary>
        public string ReturnReason { get; }
        /// <summary> Describes whether the order item is returnable or not. </summary>
        public OrderItemReturnStatus? ReturnStatus { get; }
        /// <summary> Parent RP details - this returns only the first or default parent RP from the entire list. </summary>
        internal ResourceProviderDetails FirstOrDefaultManagement { get; }
        /// <summary> Resource provider namespace. </summary>
        public string FirstOrDefaultManagementResourceProviderNamespace
        {
            get => FirstOrDefaultManagement?.ResourceProviderNamespace;
        }

        /// <summary> List of parent RP details supported for configuration. </summary>
        public IReadOnlyList<ResourceProviderDetails> ManagementRPDetailsList { get; }
        /// <summary> Top level error for the job. </summary>
        public ResponseError Error { get; }
    }
}
