// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    public partial class EdgeOrderItemDetails : IUtf8JsonSerializable, IJsonModel<EdgeOrderItemDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EdgeOrderItemDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EdgeOrderItemDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeOrderItemDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeOrderItemDetails)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("productDetails"u8);
            writer.WriteObjectValue(ProductDetails, options);
            writer.WritePropertyName("orderItemType"u8);
            writer.WriteStringValue(OrderItemType.ToString());
            if (options.Format != "W" && Optional.IsDefined(CurrentStage))
            {
                writer.WritePropertyName("currentStage"u8);
                writer.WriteObjectValue(CurrentStage, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(OrderItemStageHistory))
            {
                writer.WritePropertyName("orderItemStageHistory"u8);
                writer.WriteStartArray();
                foreach (var item in OrderItemStageHistory)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Preferences))
            {
                writer.WritePropertyName("preferences"u8);
                writer.WriteObjectValue(Preferences, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ForwardShippingDetails))
            {
                writer.WritePropertyName("forwardShippingDetails"u8);
                writer.WriteObjectValue(ForwardShippingDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ReverseShippingDetails))
            {
                writer.WritePropertyName("reverseShippingDetails"u8);
                writer.WriteObjectValue(ReverseShippingDetails, options);
            }
            if (Optional.IsCollectionDefined(NotificationEmailList))
            {
                writer.WritePropertyName("notificationEmailList"u8);
                writer.WriteStartArray();
                foreach (var item in NotificationEmailList)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(CancellationReason))
            {
                writer.WritePropertyName("cancellationReason"u8);
                writer.WriteStringValue(CancellationReason);
            }
            if (options.Format != "W" && Optional.IsDefined(CancellationStatus))
            {
                writer.WritePropertyName("cancellationStatus"u8);
                writer.WriteStringValue(CancellationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DeletionStatus))
            {
                writer.WritePropertyName("deletionStatus"u8);
                writer.WriteStringValue(DeletionStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ReturnReason))
            {
                writer.WritePropertyName("returnReason"u8);
                writer.WriteStringValue(ReturnReason);
            }
            if (options.Format != "W" && Optional.IsDefined(ReturnStatus))
            {
                writer.WritePropertyName("returnStatus"u8);
                writer.WriteStringValue(ReturnStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(FirstOrDefaultManagement))
            {
                writer.WritePropertyName("managementRpDetails"u8);
                writer.WriteObjectValue(FirstOrDefaultManagement, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ManagementRPDetailsList))
            {
                writer.WritePropertyName("managementRpDetailsList"u8);
                writer.WriteStartArray();
                foreach (var item in ManagementRPDetailsList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Error))
            {
                writer.WritePropertyName("error"u8);
                JsonSerializer.Serialize(writer, Error);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EdgeOrderItemDetails IJsonModel<EdgeOrderItemDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeOrderItemDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeOrderItemDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEdgeOrderItemDetails(document.RootElement, options);
        }

        internal static EdgeOrderItemDetails DeserializeEdgeOrderItemDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ProductDetails productDetails = default;
            OrderItemType orderItemType = default;
            EdgeOrderStageDetails currentStage = default;
            IReadOnlyList<EdgeOrderStageDetails> orderItemStageHistory = default;
            OrderItemPreferences preferences = default;
            ForwardShippingDetails forwardShippingDetails = default;
            ReverseShippingDetails reverseShippingDetails = default;
            IList<string> notificationEmailList = default;
            string cancellationReason = default;
            OrderItemCancellationStatus? cancellationStatus = default;
            EdgeOrderActionStatus? deletionStatus = default;
            string returnReason = default;
            OrderItemReturnStatus? returnStatus = default;
            ResourceProviderDetails managementRPDetails = default;
            IReadOnlyList<ResourceProviderDetails> managementRPDetailsList = default;
            ResponseError error = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("productDetails"u8))
                {
                    productDetails = ProductDetails.DeserializeProductDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("orderItemType"u8))
                {
                    orderItemType = new OrderItemType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("currentStage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentStage = EdgeOrderStageDetails.DeserializeEdgeOrderStageDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("orderItemStageHistory"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EdgeOrderStageDetails> array = new List<EdgeOrderStageDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EdgeOrderStageDetails.DeserializeEdgeOrderStageDetails(item, options));
                    }
                    orderItemStageHistory = array;
                    continue;
                }
                if (property.NameEquals("preferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preferences = OrderItemPreferences.DeserializeOrderItemPreferences(property.Value, options);
                    continue;
                }
                if (property.NameEquals("forwardShippingDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    forwardShippingDetails = ForwardShippingDetails.DeserializeForwardShippingDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("reverseShippingDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reverseShippingDetails = ReverseShippingDetails.DeserializeReverseShippingDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("notificationEmailList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    notificationEmailList = array;
                    continue;
                }
                if (property.NameEquals("cancellationReason"u8))
                {
                    cancellationReason = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cancellationStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cancellationStatus = new OrderItemCancellationStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("deletionStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deletionStatus = new EdgeOrderActionStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("returnReason"u8))
                {
                    returnReason = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("returnStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    returnStatus = new OrderItemReturnStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("managementRpDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    managementRPDetails = ResourceProviderDetails.DeserializeResourceProviderDetails(property.Value, options);
                    continue;
                }
                if (property.NameEquals("managementRpDetailsList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceProviderDetails> array = new List<ResourceProviderDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceProviderDetails.DeserializeResourceProviderDetails(item, options));
                    }
                    managementRPDetailsList = array;
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = JsonSerializer.Deserialize<ResponseError>(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EdgeOrderItemDetails(
                productDetails,
                orderItemType,
                currentStage,
                orderItemStageHistory ?? new ChangeTrackingList<EdgeOrderStageDetails>(),
                preferences,
                forwardShippingDetails,
                reverseShippingDetails,
                notificationEmailList ?? new ChangeTrackingList<string>(),
                cancellationReason,
                cancellationStatus,
                deletionStatus,
                returnReason,
                returnStatus,
                managementRPDetails,
                managementRPDetailsList ?? new ChangeTrackingList<ResourceProviderDetails>(),
                error,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EdgeOrderItemDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeOrderItemDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EdgeOrderItemDetails)} does not support writing '{options.Format}' format.");
            }
        }

        EdgeOrderItemDetails IPersistableModel<EdgeOrderItemDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeOrderItemDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEdgeOrderItemDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EdgeOrderItemDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EdgeOrderItemDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
