// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Address details for an order item. </summary>
    public partial class EdgeOrderItemAddressDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemAddressDetails"/>. </summary>
        /// <param name="forwardAddress"> Customer address and contact details. It should be address resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="forwardAddress"/> is null. </exception>
        public EdgeOrderItemAddressDetails(EdgeOrderItemAddressProperties forwardAddress)
        {
            Argument.AssertNotNull(forwardAddress, nameof(forwardAddress));

            ForwardAddress = forwardAddress;
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemAddressDetails"/>. </summary>
        /// <param name="forwardAddress"> Customer address and contact details. It should be address resource. </param>
        /// <param name="returnAddress"> Return shipping address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderItemAddressDetails(EdgeOrderItemAddressProperties forwardAddress, EdgeOrderItemAddressProperties returnAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ForwardAddress = forwardAddress;
            ReturnAddress = returnAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderItemAddressDetails"/> for deserialization. </summary>
        internal EdgeOrderItemAddressDetails()
        {
        }

        /// <summary> Customer address and contact details. It should be address resource. </summary>
        public EdgeOrderItemAddressProperties ForwardAddress { get; set; }
        /// <summary> Return shipping address. </summary>
        public EdgeOrderItemAddressProperties ReturnAddress { get; }
    }
}
