// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Represents billing type. </summary>
    internal readonly partial struct BillingType : IEquatable<BillingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Pav2Value = "Pav2";
        private const string PurchaseValue = "Purchase";

        /// <summary> PaV2 billing. </summary>
        public static BillingType Pav2 { get; } = new BillingType(Pav2Value);
        /// <summary> Purchase billing. </summary>
        public static BillingType Purchase { get; } = new BillingType(PurchaseValue);
        /// <summary> Determines if two <see cref="BillingType"/> values are the same. </summary>
        public static bool operator ==(BillingType left, BillingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingType"/> values are not the same. </summary>
        public static bool operator !=(BillingType left, BillingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingType"/>. </summary>
        public static implicit operator BillingType(string value) => new BillingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
