// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EdgeOrder
{
    internal class EdgeOrderItemOperationSource : IOperationSource<EdgeOrderItemResource>
    {
        private readonly ArmClient _client;

        internal EdgeOrderItemOperationSource(ArmClient client)
        {
            _client = client;
        }

        EdgeOrderItemResource IOperationSource<EdgeOrderItemResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EdgeOrderItemData.DeserializeEdgeOrderItemData(document.RootElement);
            return new EdgeOrderItemResource(_client, data);
        }

        async ValueTask<EdgeOrderItemResource> IOperationSource<EdgeOrderItemResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EdgeOrderItemData.DeserializeEdgeOrderItemData(document.RootElement);
            return new EdgeOrderItemResource(_client, data);
        }
    }
}
