// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EdgeOrder
{
    internal class EdgeOrderAddressOperationSource : IOperationSource<EdgeOrderAddressResource>
    {
        private readonly ArmClient _client;

        internal EdgeOrderAddressOperationSource(ArmClient client)
        {
            _client = client;
        }

        EdgeOrderAddressResource IOperationSource<EdgeOrderAddressResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EdgeOrderAddressData.DeserializeEdgeOrderAddressData(document.RootElement);
            return new EdgeOrderAddressResource(_client, data);
        }

        async ValueTask<EdgeOrderAddressResource> IOperationSource<EdgeOrderAddressResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EdgeOrderAddressData.DeserializeEdgeOrderAddressData(document.RootElement);
            return new EdgeOrderAddressResource(_client, data);
        }
    }
}
