// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.EdgeOrder.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EdgeOrder
{
    /// <summary>
    /// A class representing the EdgeOrder data model.
    /// Specifies the properties or parameters for an order. Order is a grouping of one or more order items.
    /// </summary>
    public partial class EdgeOrderData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderData"/>. </summary>
        public EdgeOrderData()
        {
            OrderItemIds = new ChangeTrackingList<ResourceIdentifier>();
            OrderStageHistory = new ChangeTrackingList<EdgeOrderStageDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="orderItemIds"> List of order item ARM Ids which are part of an order. </param>
        /// <param name="currentStage"> Order current status. </param>
        /// <param name="orderStageHistory"> Order status history. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IReadOnlyList<ResourceIdentifier> orderItemIds, EdgeOrderStageDetails currentStage, IReadOnlyList<EdgeOrderStageDetails> orderStageHistory, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            OrderItemIds = orderItemIds;
            CurrentStage = currentStage;
            OrderStageHistory = orderStageHistory;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of order item ARM Ids which are part of an order. </summary>
        public IReadOnlyList<ResourceIdentifier> OrderItemIds { get; }
        /// <summary> Order current status. </summary>
        public EdgeOrderStageDetails CurrentStage { get; }
        /// <summary> Order status history. </summary>
        public IReadOnlyList<EdgeOrderStageDetails> OrderStageHistory { get; }
    }
}
