// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EdgeOrder.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.EdgeOrder.Samples
{
    public partial class Sample_EdgeOrderItemResource
    {
        // ListOrderItemsAtSubscriptionLevel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEdgeOrderItems_ListOrderItemsAtSubscriptionLevel()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderItemsAtSubscriptionLevel.json
            // this example is just showing the usage of "ListOrderItemsAtSubscriptionLevel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (EdgeOrderItemResource item in subscriptionResource.GetEdgeOrderItemsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EdgeOrderItemData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetOrderItemByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetOrderItemByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderItemByName.json
            // this example is just showing the usage of "GetOrderItemByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderItemResource created on azure
            // for more information of creating EdgeOrderItemResource, please refer to the document of EdgeOrderItemResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string orderItemName = "TestOrderItemName01";
            ResourceIdentifier edgeOrderItemResourceId = EdgeOrderItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, orderItemName);
            EdgeOrderItemResource edgeOrderItem = client.GetEdgeOrderItemResource(edgeOrderItemResourceId);

            // invoke the operation
            EdgeOrderItemResource result = await edgeOrderItem.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteOrderItemByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteOrderItemByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/DeleteOrderItemByName.json
            // this example is just showing the usage of "DeleteOrderItemByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderItemResource created on azure
            // for more information of creating EdgeOrderItemResource, please refer to the document of EdgeOrderItemResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string orderItemName = "TestOrderItemName01";
            ResourceIdentifier edgeOrderItemResourceId = EdgeOrderItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, orderItemName);
            EdgeOrderItemResource edgeOrderItem = client.GetEdgeOrderItemResource(edgeOrderItemResourceId);

            // invoke the operation
            await edgeOrderItem.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // UpdateOrderItem
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateOrderItem()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/UpdateOrderItem.json
            // this example is just showing the usage of "UpdateOrderItem" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderItemResource created on azure
            // for more information of creating EdgeOrderItemResource, please refer to the document of EdgeOrderItemResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string orderItemName = "TestOrderItemName01";
            ResourceIdentifier edgeOrderItemResourceId = EdgeOrderItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, orderItemName);
            EdgeOrderItemResource edgeOrderItem = client.GetEdgeOrderItemResource(edgeOrderItemResourceId);

            // invoke the operation
            EdgeOrderItemPatch patch = new EdgeOrderItemPatch()
            {
                Tags =
{
["ant"] = "insect",
["pigeon"] = "bird",
["tiger"] = "animal",
},
                ForwardAddress = new EdgeOrderItemAddressProperties(new EdgeOrderAddressContactDetails("Updated contact name", "2222200000", new string[]
            {
"testemail@microsoft.com"
            })),
                Preferences = new OrderItemPreferences()
                {
                    TransportPreferencesPreferredShipmentType = TransportShipmentType.CustomerManaged,
                },
            };
            ArmOperation<EdgeOrderItemResource> lro = await edgeOrderItem.UpdateAsync(WaitUntil.Completed, patch);
            EdgeOrderItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CancelOrderItem
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_CancelOrderItem()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/CancelOrderItem.json
            // this example is just showing the usage of "CancelOrderItem" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderItemResource created on azure
            // for more information of creating EdgeOrderItemResource, please refer to the document of EdgeOrderItemResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string orderItemName = "TestOrderItemName1";
            ResourceIdentifier edgeOrderItemResourceId = EdgeOrderItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, orderItemName);
            EdgeOrderItemResource edgeOrderItem = client.GetEdgeOrderItemResource(edgeOrderItemResourceId);

            // invoke the operation
            EdgeOrderItemCancellationReason cancellationReason = new EdgeOrderItemCancellationReason("Order cancelled");
            await edgeOrderItem.CancelAsync(cancellationReason);

            Console.WriteLine($"Succeeded");
        }

        // ReturnOrderItem
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Return_ReturnOrderItem()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ReturnOrderItem.json
            // this example is just showing the usage of "ReturnOrderItem" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderItemResource created on azure
            // for more information of creating EdgeOrderItemResource, please refer to the document of EdgeOrderItemResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string orderItemName = "TestOrderName1";
            ResourceIdentifier edgeOrderItemResourceId = EdgeOrderItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, orderItemName);
            EdgeOrderItemResource edgeOrderItem = client.GetEdgeOrderItemResource(edgeOrderItemResourceId);

            // invoke the operation
            EdgeOrderItemReturnContent content = new EdgeOrderItemReturnContent("Order returned");
            await edgeOrderItem.ReturnAsync(WaitUntil.Completed, content);

            Console.WriteLine($"Succeeded");
        }
    }
}
