// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EdgeOrder.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.EdgeOrder.Samples
{
    public partial class Sample_EdgeOrderItemCollection
    {
        // ListOrderItemsAtResourceGroupLevel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListOrderItemsAtResourceGroupLevel()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListOrderItemsAtResourceGroupLevel.json
            // this example is just showing the usage of "ListOrderItemsAtResourceGroupLevel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this EdgeOrderItemResource
            EdgeOrderItemCollection collection = resourceGroupResource.GetEdgeOrderItems();

            // invoke the operation and iterate over the result
            await foreach (EdgeOrderItemResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EdgeOrderItemData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetOrderItemByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetOrderItemByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderItemByName.json
            // this example is just showing the usage of "GetOrderItemByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this EdgeOrderItemResource
            EdgeOrderItemCollection collection = resourceGroupResource.GetEdgeOrderItems();

            // invoke the operation
            string orderItemName = "TestOrderItemName01";
            EdgeOrderItemResource result = await collection.GetAsync(orderItemName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetOrderItemByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetOrderItemByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderItemByName.json
            // this example is just showing the usage of "GetOrderItemByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this EdgeOrderItemResource
            EdgeOrderItemCollection collection = resourceGroupResource.GetEdgeOrderItems();

            // invoke the operation
            string orderItemName = "TestOrderItemName01";
            bool result = await collection.ExistsAsync(orderItemName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetOrderItemByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetOrderItemByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetOrderItemByName.json
            // this example is just showing the usage of "GetOrderItemByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this EdgeOrderItemResource
            EdgeOrderItemCollection collection = resourceGroupResource.GetEdgeOrderItems();

            // invoke the operation
            string orderItemName = "TestOrderItemName01";
            NullableResponse<EdgeOrderItemResource> response = await collection.GetIfExistsAsync(orderItemName);
            EdgeOrderItemResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EdgeOrderItemData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // CreateOrderItem
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrderItem()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/CreateOrderItem.json
            // this example is just showing the usage of "CreateOrderItem" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this EdgeOrderItemResource
            EdgeOrderItemCollection collection = resourceGroupResource.GetEdgeOrderItems();

            // invoke the operation
            string orderItemName = "TestOrderItemName01";
            EdgeOrderItemData data = new EdgeOrderItemData(new AzureLocation("westus"), new EdgeOrderItemDetails(new ProductDetails(new HierarchyInformation()
            {
                ProductFamilyName = "AzureStackEdge",
                ProductLineName = "AzureStackEdge",
                ProductName = "AzureStackEdgeGPU",
                ConfigurationName = "AzureStackEdgeGPU",
            }), OrderItemType.Purchase)
            {
                Preferences = new OrderItemPreferences()
                {
                    TransportPreferencesPreferredShipmentType = TransportShipmentType.MicrosoftManaged,
                },
            }, new EdgeOrderItemAddressDetails(new EdgeOrderItemAddressProperties(new EdgeOrderAddressContactDetails("164 TOWNSEND ST", "3213131190", new string[]
            {
"ssemmail@microsoft.com","vishwamdir@microsoft.com"
            }))
            {
                ShippingAddress = new EdgeOrderShippingAddress("16 TOWNSEND ST", "US")
                {
                    StreetAddress2 = "UNIT 1",
                    City = "San Francisco",
                    StateOrProvince = "CA",
                    PostalCode = "94107",
                    ZipExtendedCode = "1",
                    CompanyName = "Microsoft",
                    AddressType = EdgeOrderAddressType.Residential,
                },
            }), new ResourceIdentifier("/subscriptions/fa68082f-8ff7-4a25-95c7-ce9da541242f/resourceGroups/TestRG/providers/Microsoft.EdgeOrder/locations/westus/orders/TestOrderItemName01"))
            {
                Tags =
{
["carrot"] = "vegetable",
["mango"] = "fruit",
},
            };
            ArmOperation<EdgeOrderItemResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, orderItemName, data);
            EdgeOrderItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
