// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.EdgeOrder.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.EdgeOrder.Samples
{
    public partial class Sample_EdgeOrderAddressResource
    {
        // ListAddressesAtSubscriptionLevel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEdgeOrderAddresses_ListAddressesAtSubscriptionLevel()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/ListAddressesAtSubscriptionLevel.json
            // this example is just showing the usage of "ListAddressesAtSubscriptionLevel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (EdgeOrderAddressResource item in subscriptionResource.GetEdgeOrderAddressesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                EdgeOrderAddressData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetAddressByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAddressByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/GetAddressByName.json
            // this example is just showing the usage of "GetAddressByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderAddressResource created on azure
            // for more information of creating EdgeOrderAddressResource, please refer to the document of EdgeOrderAddressResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string addressName = "TestMSAddressName";
            ResourceIdentifier edgeOrderAddressResourceId = EdgeOrderAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, addressName);
            EdgeOrderAddressResource edgeOrderAddress = client.GetEdgeOrderAddressResource(edgeOrderAddressResourceId);

            // invoke the operation
            EdgeOrderAddressResource result = await edgeOrderAddress.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderAddressData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteAddressByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAddressByName()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/DeleteAddressByName.json
            // this example is just showing the usage of "DeleteAddressByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderAddressResource created on azure
            // for more information of creating EdgeOrderAddressResource, please refer to the document of EdgeOrderAddressResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string addressName = "TestAddressName1";
            ResourceIdentifier edgeOrderAddressResourceId = EdgeOrderAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, addressName);
            EdgeOrderAddressResource edgeOrderAddress = client.GetEdgeOrderAddressResource(edgeOrderAddressResourceId);

            // invoke the operation
            await edgeOrderAddress.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // UpdateAddress
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAddress()
        {
            // Generated from example definition: specification/edgeorder/resource-manager/Microsoft.EdgeOrder/stable/2021-12-01/examples/UpdateAddress.json
            // this example is just showing the usage of "UpdateAddress" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EdgeOrderAddressResource created on azure
            // for more information of creating EdgeOrderAddressResource, please refer to the document of EdgeOrderAddressResource
            string subscriptionId = "fa68082f-8ff7-4a25-95c7-ce9da541242f";
            string resourceGroupName = "TestRG";
            string addressName = "TestAddressName2";
            ResourceIdentifier edgeOrderAddressResourceId = EdgeOrderAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, addressName);
            EdgeOrderAddressResource edgeOrderAddress = client.GetEdgeOrderAddressResource(edgeOrderAddressResourceId);

            // invoke the operation
            EdgeOrderAddressPatch patch = new EdgeOrderAddressPatch()
            {
                Tags =
{
["Hobby"] = "Web Series Added",
["Name"] = "Smile-Updated",
["WhatElse"] = "Web Series Added",
["Work"] = "Engineering",
},
                ShippingAddress = new EdgeOrderShippingAddress("16 TOWNSEND STT", "US")
                {
                    StreetAddress2 = "UNIT 1",
                    City = "San Francisco",
                    StateOrProvince = "CA",
                    PostalCode = "94107",
                    CompanyName = "Microsoft",
                    AddressType = EdgeOrderAddressType.None,
                },
                ContactDetails = new EdgeOrderAddressContactDetails("Petr Cech", "1234567890", new string[]
            {
"ssemcr@microsoft.com"
            })
                {
                    PhoneExtension = "",
                },
            };
            ArmOperation<EdgeOrderAddressResource> lro = await edgeOrderAddress.UpdateAsync(WaitUntil.Completed, patch);
            EdgeOrderAddressResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EdgeOrderAddressData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
