// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Defender.Easm.Samples
{
    public partial class Samples_EasmClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_UpdateAssets_AssetsUpdateAssets()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                state = "confirmed",
                externalId = "contosoInternalId",
                labels = new
                {
                    contosoLabel = true,
                },
            });
            Response response = client.UpdateAssets("state%20%3D%20%22confirmed%22%20AND%20name%20%5E%3D%20%22contoso.com%22", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_UpdateAssets_AssetsUpdateAssets_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                state = "confirmed",
                externalId = "contosoInternalId",
                labels = new
                {
                    contosoLabel = true,
                },
            });
            Response response = await client.UpdateAssetsAsync("state%20%3D%20%22confirmed%22%20AND%20name%20%5E%3D%20%22contoso.com%22", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_UpdateAssets_AssetsUpdateAssets_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            AssetUpdatePayload body = new AssetUpdatePayload
            {
                State = AssetUpdateState.Confirmed,
                ExternalId = "contosoInternalId",
                Labels =
{
["contosoLabel"] = true
},
            };
            Response<TaskResource> response = client.UpdateAssets("state%20%3D%20%22confirmed%22%20AND%20name%20%5E%3D%20%22contoso.com%22", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_UpdateAssets_AssetsUpdateAssets_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            AssetUpdatePayload body = new AssetUpdatePayload
            {
                State = AssetUpdateState.Confirmed,
                ExternalId = "contosoInternalId",
                Labels =
{
["contosoLabel"] = true
},
            };
            Response<TaskResource> response = await client.UpdateAssetsAsync("state%20%3D%20%22confirmed%22%20AND%20name%20%5E%3D%20%22contoso.com%22", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_GetAssetResource_AssetsGetAssetResource()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetAssetResource("aG9zdCQkY29udG9zby5jb20", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_GetAssetResource_AssetsGetAssetResource_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetAssetResourceAsync("aG9zdCQkY29udG9zby5jb20", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_GetAssetResource_AssetsGetAssetResource_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<AssetResource> response = client.GetAssetResource("aG9zdCQkY29udG9zby5jb20");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_GetAssetResource_AssetsGetAssetResource_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<AssetResource> response = await client.GetAssetResourceAsync("aG9zdCQkY29udG9zby5jb20");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_ValidateDataConnection_DataConnectionsValidateDataConnection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "logAnalytics",
                properties = new
                {
                    apiKey = "ThisisApiKey",
                    workspaceId = "ThisisWorkspaceId",
                },
                frequency = "weekly",
                frequencyOffset = 1,
                name = "ThisisaDataConnection",
            });
            Response response = client.ValidateDataConnection(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_ValidateDataConnection_DataConnectionsValidateDataConnection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "logAnalytics",
                properties = new
                {
                    apiKey = "ThisisApiKey",
                    workspaceId = "ThisisWorkspaceId",
                },
                frequency = "weekly",
                frequencyOffset = 1,
                name = "ThisisaDataConnection",
            });
            Response response = await client.ValidateDataConnectionAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_ValidateDataConnection_DataConnectionsValidateDataConnection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DataConnectionPayload body = new LogAnalyticsDataConnectionPayload(new LogAnalyticsDataConnectionProperties
            {
                ApiKey = "ThisisApiKey",
                WorkspaceId = "ThisisWorkspaceId",
            })
            {
                Name = "ThisisaDataConnection",
                Frequency = DataConnectionFrequency.Weekly,
                FrequencyOffset = 1,
            };
            Response<ValidateResult> response = client.ValidateDataConnection(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_ValidateDataConnection_DataConnectionsValidateDataConnection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DataConnectionPayload body = new LogAnalyticsDataConnectionPayload(new LogAnalyticsDataConnectionProperties
            {
                ApiKey = "ThisisApiKey",
                WorkspaceId = "ThisisWorkspaceId",
            })
            {
                Name = "ThisisaDataConnection",
                Frequency = DataConnectionFrequency.Weekly,
                FrequencyOffset = 1,
            };
            Response<ValidateResult> response = await client.ValidateDataConnectionAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_GetDataConnection_DataConnectionsGetDataConnection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetDataConnection("ThisisaDataConnection", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_GetDataConnection_DataConnectionsGetDataConnection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetDataConnectionAsync("ThisisaDataConnection", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_GetDataConnection_DataConnectionsGetDataConnection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DataConnection> response = client.GetDataConnection("ThisisaDataConnection");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_GetDataConnection_DataConnectionsGetDataConnection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DataConnection> response = await client.GetDataConnectionAsync("ThisisaDataConnection");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_CreateOrReplaceDataConnection_DataConnectionsCreateOrReplaceDataConnection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "logAnalytics",
                properties = new
                {
                    apiKey = "ThisisApiKey",
                    workspaceId = "ThisisWorkspaceId",
                },
                frequency = "weekly",
                frequencyOffset = 1,
            });
            Response response = client.CreateOrReplaceDataConnection("ThisisaDataConnection", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_CreateOrReplaceDataConnection_DataConnectionsCreateOrReplaceDataConnection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "logAnalytics",
                properties = new
                {
                    apiKey = "ThisisApiKey",
                    workspaceId = "ThisisWorkspaceId",
                },
                frequency = "weekly",
                frequencyOffset = 1,
            });
            Response response = await client.CreateOrReplaceDataConnectionAsync("ThisisaDataConnection", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_CreateOrReplaceDataConnection_DataConnectionsCreateOrReplaceDataConnection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DataConnectionPayload body = new LogAnalyticsDataConnectionPayload(new LogAnalyticsDataConnectionProperties
            {
                ApiKey = "ThisisApiKey",
                WorkspaceId = "ThisisWorkspaceId",
            })
            {
                Frequency = DataConnectionFrequency.Weekly,
                FrequencyOffset = 1,
            };
            Response<DataConnection> response = client.CreateOrReplaceDataConnection("ThisisaDataConnection", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_CreateOrReplaceDataConnection_DataConnectionsCreateOrReplaceDataConnection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DataConnectionPayload body = new LogAnalyticsDataConnectionPayload(new LogAnalyticsDataConnectionProperties
            {
                ApiKey = "ThisisApiKey",
                WorkspaceId = "ThisisWorkspaceId",
            })
            {
                Frequency = DataConnectionFrequency.Weekly,
                FrequencyOffset = 1,
            };
            Response<DataConnection> response = await client.CreateOrReplaceDataConnectionAsync("ThisisaDataConnection", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_DeleteDataConnection_DataConnectionsDeleteDataConnection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.DeleteDataConnection("ThisisaDataConnection");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_DeleteDataConnection_DataConnectionsDeleteDataConnection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.DeleteDataConnectionAsync("ThisisaDataConnection");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_ValidateDiscoveryGroup_DiscoveryGroupsValidateDiscoGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                description = "This is a disco group",
                frequencyMilliseconds = 604800000L,
                tier = "advanced",
                seeds = new object[]
            {
new
{
name = "thisisatest.microsoft.com",
kind = "host",
}
            },
            });
            Response response = client.ValidateDiscoveryGroup(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_ValidateDiscoveryGroup_DiscoveryGroupsValidateDiscoGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                description = "This is a disco group",
                frequencyMilliseconds = 604800000L,
                tier = "advanced",
                seeds = new object[]
            {
new
{
name = "thisisatest.microsoft.com",
kind = "host",
}
            },
            });
            Response response = await client.ValidateDiscoveryGroupAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_ValidateDiscoveryGroup_DiscoveryGroupsValidateDiscoGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DiscoveryGroupPayload body = new DiscoveryGroupPayload
            {
                Description = "This is a disco group",
                Tier = "advanced",
                FrequencyMilliseconds = 604800000L,
                Seeds = {new DiscoverySource
{
Kind = DiscoverySourceKind.Host,
Name = "thisisatest.microsoft.com",
}},
            };
            Response<ValidateResult> response = client.ValidateDiscoveryGroup(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_ValidateDiscoveryGroup_DiscoveryGroupsValidateDiscoGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DiscoveryGroupPayload body = new DiscoveryGroupPayload
            {
                Description = "This is a disco group",
                Tier = "advanced",
                FrequencyMilliseconds = 604800000L,
                Seeds = {new DiscoverySource
{
Kind = DiscoverySourceKind.Host,
Name = "thisisatest.microsoft.com",
}},
            };
            Response<ValidateResult> response = await client.ValidateDiscoveryGroupAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_GetDiscoveryGroup_DiscoveryGroupsGetDiscoGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetDiscoveryGroup("ThisisaDiscoGroup", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_GetDiscoveryGroup_DiscoveryGroupsGetDiscoGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetDiscoveryGroupAsync("ThisisaDiscoGroup", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_GetDiscoveryGroup_DiscoveryGroupsGetDiscoGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DiscoveryGroup> response = client.GetDiscoveryGroup("ThisisaDiscoGroup");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_GetDiscoveryGroup_DiscoveryGroupsGetDiscoGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DiscoveryGroup> response = await client.GetDiscoveryGroupAsync("ThisisaDiscoGroup");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_CreateOrReplaceDiscoveryGroup_DiscoveryGroupsCreateOrReplaceDiscoGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                description = "This is a disco group",
                frequencyMilliseconds = 604800000L,
                tier = "advanced",
                seeds = new object[]
            {
new
{
name = "thisisatest.microsoft.com",
kind = "host",
}
            },
            });
            Response response = client.CreateOrReplaceDiscoveryGroup("ThisisaDiscoGroup", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_CreateOrReplaceDiscoveryGroup_DiscoveryGroupsCreateOrReplaceDiscoGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                description = "This is a disco group",
                frequencyMilliseconds = 604800000L,
                tier = "advanced",
                seeds = new object[]
            {
new
{
name = "thisisatest.microsoft.com",
kind = "host",
}
            },
            });
            Response response = await client.CreateOrReplaceDiscoveryGroupAsync("ThisisaDiscoGroup", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_CreateOrReplaceDiscoveryGroup_DiscoveryGroupsCreateOrReplaceDiscoGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DiscoveryGroupPayload body = new DiscoveryGroupPayload
            {
                Description = "This is a disco group",
                Tier = "advanced",
                FrequencyMilliseconds = 604800000L,
                Seeds = {new DiscoverySource
{
Kind = DiscoverySourceKind.Host,
Name = "thisisatest.microsoft.com",
}},
            };
            Response<DiscoveryGroup> response = client.CreateOrReplaceDiscoveryGroup("ThisisaDiscoGroup", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_CreateOrReplaceDiscoveryGroup_DiscoveryGroupsCreateOrReplaceDiscoGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            DiscoveryGroupPayload body = new DiscoveryGroupPayload
            {
                Description = "This is a disco group",
                Tier = "advanced",
                FrequencyMilliseconds = 604800000L,
                Seeds = {new DiscoverySource
{
Kind = DiscoverySourceKind.Host,
Name = "thisisatest.microsoft.com",
}},
            };
            Response<DiscoveryGroup> response = await client.CreateOrReplaceDiscoveryGroupAsync("ThisisaDiscoGroup", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_RunDiscoveryGroup_DiscoveryGroupsRunDiscoGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.RunDiscoveryGroup("ThisisaDiscoGroup");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_RunDiscoveryGroup_DiscoveryGroupsRunDiscoGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.RunDiscoveryGroupAsync("ThisisaDiscoGroup");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoTemplate_GetDiscoveryTemplate_DiscoveryTemplatesGetDiscoTemplate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetDiscoveryTemplate("12345", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoTemplate_GetDiscoveryTemplate_DiscoveryTemplatesGetDiscoTemplate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetDiscoveryTemplateAsync("12345", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoTemplate_GetDiscoveryTemplate_DiscoveryTemplatesGetDiscoTemplate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DiscoveryTemplate> response = client.GetDiscoveryTemplate("12345");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoTemplate_GetDiscoveryTemplate_DiscoveryTemplatesGetDiscoTemplate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<DiscoveryTemplate> response = await client.GetDiscoveryTemplateAsync("12345");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetBillable_ReportsGetBillable()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetBillable(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetBillable_ReportsGetBillable_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetBillableAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetBillable_ReportsGetBillable_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<ReportBillableAssetSummaryResult> response = client.GetBillable();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetBillable_ReportsGetBillable_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<ReportBillableAssetSummaryResult> response = await client.GetBillableAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetSnapshot_ReportsGetSnapshot()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                metric = "site_status_active",
                page = 0,
                size = 5,
            });
            Response response = client.GetSnapshot(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetSnapshot_ReportsGetSnapshot_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                metric = "site_status_active",
                page = 0,
                size = 5,
            });
            Response response = await client.GetSnapshotAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetSnapshot_ReportsGetSnapshot_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            ReportAssetSnapshotPayload body = new ReportAssetSnapshotPayload
            {
                Metric = "site_status_active",
                Size = 5,
                Page = 0,
            };
            Response<ReportAssetSnapshotResult> response = client.GetSnapshot(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetSnapshot_ReportsGetSnapshot_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            ReportAssetSnapshotPayload body = new ReportAssetSnapshotPayload
            {
                Metric = "site_status_active",
                Size = 5,
                Page = 0,
            };
            Response<ReportAssetSnapshotResult> response = await client.GetSnapshotAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetSummary_ReportsGetSummary()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                filters = new object[]
            {
"state = \"confirmed\" AND kind = \"domain\"",
"state = \"confirmed\" AND kind = \"host\"",
"state = \"confirmed\" AND kind = \"page\""
            },
            });
            Response response = client.GetSummary(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetSummary_ReportsGetSummary_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                filters = new object[]
            {
"state = \"confirmed\" AND kind = \"domain\"",
"state = \"confirmed\" AND kind = \"host\"",
"state = \"confirmed\" AND kind = \"page\""
            },
            });
            Response response = await client.GetSummaryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetSummary_ReportsGetSummary_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            ReportAssetSummaryPayload body = new ReportAssetSummaryPayload
            {
                Filters = { "state = \"confirmed\" AND kind = \"domain\"", "state = \"confirmed\" AND kind = \"host\"", "state = \"confirmed\" AND kind = \"page\"" },
            };
            Response<ReportAssetSummaryResult> response = client.GetSummary(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetSummary_ReportsGetSummary_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            ReportAssetSummaryPayload body = new ReportAssetSummaryPayload
            {
                Filters = { "state = \"confirmed\" AND kind = \"domain\"", "state = \"confirmed\" AND kind = \"host\"", "state = \"confirmed\" AND kind = \"page\"" },
            };
            Response<ReportAssetSummaryResult> response = await client.GetSummaryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_GetSavedFilter_SavedFiltersGetSavedFilter()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetSavedFilter("ThisisaSavedFilter", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_GetSavedFilter_SavedFiltersGetSavedFilter_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetSavedFilterAsync("ThisisaSavedFilter", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_GetSavedFilter_SavedFiltersGetSavedFilter_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<SavedFilter> response = client.GetSavedFilter("ThisisaSavedFilter");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_GetSavedFilter_SavedFiltersGetSavedFilter_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<SavedFilter> response = await client.GetSavedFilterAsync("ThisisaSavedFilter");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_CreateOrReplaceSavedFilter_SavedFiltersCreateOrReplaceSavedFilter()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                filter = "state IN (\"confirmed\")",
                description = "This is a saved filter",
            });
            Response response = client.CreateOrReplaceSavedFilter("ThisisaSavedFilter", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_CreateOrReplaceSavedFilter_SavedFiltersCreateOrReplaceSavedFilter_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                filter = "state IN (\"confirmed\")",
                description = "This is a saved filter",
            });
            Response response = await client.CreateOrReplaceSavedFilterAsync("ThisisaSavedFilter", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_CreateOrReplaceSavedFilter_SavedFiltersCreateOrReplaceSavedFilter_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            SavedFilterPayload body = new SavedFilterPayload("state IN (\"confirmed\")", "This is a saved filter");
            Response<SavedFilter> response = client.CreateOrReplaceSavedFilter("ThisisaSavedFilter", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_CreateOrReplaceSavedFilter_SavedFiltersCreateOrReplaceSavedFilter_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            SavedFilterPayload body = new SavedFilterPayload("state IN (\"confirmed\")", "This is a saved filter");
            Response<SavedFilter> response = await client.CreateOrReplaceSavedFilterAsync("ThisisaSavedFilter", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_DeleteSavedFilter_SavedFiltersDeleteSavedFilter()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.DeleteSavedFilter("ThisisaSavedFilter");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_DeleteSavedFilter_SavedFiltersDeleteSavedFilter_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.DeleteSavedFilterAsync("ThisisaSavedFilter");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Task_GetTask_TasksGetTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.GetTask("ThisisaTaskId", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Task_GetTask_TasksGetTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.GetTaskAsync("ThisisaTaskId", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Task_GetTask_TasksGetTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<TaskResource> response = client.GetTask("ThisisaTaskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Task_GetTask_TasksGetTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<TaskResource> response = await client.GetTaskAsync("ThisisaTaskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_CancelTask_TasksCancelTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = client.CancelTask("ThisisaTaskId", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_CancelTask_TasksCancelTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response response = await client.CancelTaskAsync("ThisisaTaskId", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_CancelTask_TasksCancelTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<TaskResource> response = client.CancelTask("ThisisaTaskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_CancelTask_TasksCancelTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            Response<TaskResource> response = await client.CancelTaskAsync("ThisisaTaskId");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_GetAssetResources_AssetsListAssetResource()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetAssetResources("state%20%3D%20%22confirmed%22", null, 0, 5, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_GetAssetResources_AssetsListAssetResource_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetAssetResourcesAsync("state%20%3D%20%22confirmed%22", null, 0, 5, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AssetResource_GetAssetResources_AssetsListAssetResource_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (AssetResource item in client.GetAssetResources())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AssetResource_GetAssetResources_AssetsListAssetResource_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (AssetResource item in client.GetAssetResourcesAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_GetDataConnections_DataConnectionsListDataConnection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetDataConnections(null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_GetDataConnections_DataConnectionsListDataConnection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDataConnectionsAsync(null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DataConnection_GetDataConnections_DataConnectionsListDataConnection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (DataConnection item in client.GetDataConnections())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DataConnection_GetDataConnections_DataConnectionsListDataConnection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (DataConnection item in client.GetDataConnectionsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_GetDiscoveryGroups_DiscoveryGroupsListDiscoGroup()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetDiscoveryGroups(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_GetDiscoveryGroups_DiscoveryGroupsListDiscoGroup_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDiscoveryGroupsAsync(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoGroup_GetDiscoveryGroups_DiscoveryGroupsListDiscoGroup_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (DiscoveryGroup item in client.GetDiscoveryGroups())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoGroup_GetDiscoveryGroups_DiscoveryGroupsListDiscoGroup_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (DiscoveryGroup item in client.GetDiscoveryGroupsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetDiscoveryGroupRuns_DiscoveryGroupsListRuns()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetDiscoveryGroupRuns("ThisisaDiscoGroup", null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetDiscoveryGroupRuns_DiscoveryGroupsListRuns_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDiscoveryGroupRunsAsync("ThisisaDiscoGroup", null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EasmClient_GetDiscoveryGroupRuns_DiscoveryGroupsListRuns_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (DiscoveryRunResult item in client.GetDiscoveryGroupRuns("ThisisaDiscoGroup"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EasmClient_GetDiscoveryGroupRuns_DiscoveryGroupsListRuns_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (DiscoveryRunResult item in client.GetDiscoveryGroupRunsAsync("ThisisaDiscoGroup"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoTemplate_GetDiscoveryTemplates_DiscoveryTemplatesListDiscoTemplate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetDiscoveryTemplates(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoTemplate_GetDiscoveryTemplates_DiscoveryTemplatesListDiscoTemplate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDiscoveryTemplatesAsync(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DiscoTemplate_GetDiscoveryTemplates_DiscoveryTemplatesListDiscoTemplate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (DiscoveryTemplate item in client.GetDiscoveryTemplates())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DiscoTemplate_GetDiscoveryTemplates_DiscoveryTemplatesListDiscoTemplate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (DiscoveryTemplate item in client.GetDiscoveryTemplatesAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_GetSavedFilters_SavedFiltersListSavedFilter()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetSavedFilters(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_GetSavedFilters_SavedFiltersListSavedFilter_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetSavedFiltersAsync(null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SavedFilter_GetSavedFilters_SavedFiltersListSavedFilter_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (SavedFilter item in client.GetSavedFilters())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SavedFilter_GetSavedFilters_SavedFiltersListSavedFilter_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (SavedFilter item in client.GetSavedFiltersAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Task_GetTasks_TasksListTask()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (BinaryData item in client.GetTasks(null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Task_GetTasks_TasksListTask_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (BinaryData item in client.GetTasksAsync(null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Task_GetTasks_TasksListTask_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            foreach (TaskResource item in client.GetTasks())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Task_GetTasks_TasksListTask_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            EasmClient client = new EasmClient(endpoint, credential);

            await foreach (TaskResource item in client.GetTasksAsync())
            {
            }
        }
    }
}
