// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The state the task is in. </summary>
    public readonly partial struct TaskResourceState : IEquatable<TaskResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TaskResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TaskResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "pending";
        private const string RunningValue = "running";
        private const string PausedValue = "paused";
        private const string CompleteValue = "complete";
        private const string IncompleteValue = "incomplete";
        private const string FailedValue = "failed";
        private const string WarningValue = "warning";

        /// <summary> pending. </summary>
        public static TaskResourceState Pending { get; } = new TaskResourceState(PendingValue);
        /// <summary> running. </summary>
        public static TaskResourceState Running { get; } = new TaskResourceState(RunningValue);
        /// <summary> paused. </summary>
        public static TaskResourceState Paused { get; } = new TaskResourceState(PausedValue);
        /// <summary> complete. </summary>
        public static TaskResourceState Complete { get; } = new TaskResourceState(CompleteValue);
        /// <summary> incomplete. </summary>
        public static TaskResourceState Incomplete { get; } = new TaskResourceState(IncompleteValue);
        /// <summary> failed. </summary>
        public static TaskResourceState Failed { get; } = new TaskResourceState(FailedValue);
        /// <summary> warning. </summary>
        public static TaskResourceState Warning { get; } = new TaskResourceState(WarningValue);
        /// <summary> Determines if two <see cref="TaskResourceState"/> values are the same. </summary>
        public static bool operator ==(TaskResourceState left, TaskResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TaskResourceState"/> values are not the same. </summary>
        public static bool operator !=(TaskResourceState left, TaskResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TaskResourceState"/>. </summary>
        public static implicit operator TaskResourceState(string value) => new TaskResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TaskResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TaskResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
