// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    public partial class SslCertAsset : IUtf8JsonSerializable, IJsonModel<SslCertAsset>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SslCertAsset>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SslCertAsset>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SslCertAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SslCertAsset)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Sha1))
            {
                writer.WritePropertyName("sha1"u8);
                writer.WriteStringValue(Sha1);
            }
            if (Optional.IsCollectionDefined(SubjectCommonNames))
            {
                writer.WritePropertyName("subjectCommonNames"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectCommonNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Organizations))
            {
                writer.WritePropertyName("organizations"u8);
                writer.WriteStartArray();
                foreach (var item in Organizations)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(OrganizationalUnits))
            {
                writer.WritePropertyName("organizationalUnits"u8);
                writer.WriteStartArray();
                foreach (var item in OrganizationalUnits)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerCommonNames))
            {
                writer.WritePropertyName("issuerCommonNames"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerCommonNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SigAlgName))
            {
                writer.WritePropertyName("sigAlgName"u8);
                writer.WriteStringValue(SigAlgName);
            }
            if (Optional.IsDefined(InvalidAfter))
            {
                writer.WritePropertyName("invalidAfter"u8);
                writer.WriteStringValue(InvalidAfter.Value, "O");
            }
            if (Optional.IsDefined(SerialNumber))
            {
                writer.WritePropertyName("serialNumber"u8);
                writer.WriteStringValue(SerialNumber);
            }
            if (Optional.IsCollectionDefined(SubjectAlternativeNames))
            {
                writer.WritePropertyName("subjectAlternativeNames"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectAlternativeNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerAlternativeNames))
            {
                writer.WritePropertyName("issuerAlternativeNames"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerAlternativeNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sources))
            {
                writer.WritePropertyName("sources"u8);
                writer.WriteStartArray();
                foreach (var item in Sources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FirstSeen))
            {
                writer.WritePropertyName("firstSeen"u8);
                writer.WriteStringValue(FirstSeen.Value, "O");
            }
            if (Optional.IsDefined(LastSeen))
            {
                writer.WritePropertyName("lastSeen"u8);
                writer.WriteStringValue(LastSeen.Value, "O");
            }
            if (Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (Optional.IsDefined(InvalidBefore))
            {
                writer.WritePropertyName("invalidBefore"u8);
                writer.WriteStringValue(InvalidBefore.Value, "O");
            }
            if (Optional.IsDefined(KeySize))
            {
                writer.WritePropertyName("keySize"u8);
                writer.WriteNumberValue(KeySize.Value);
            }
            if (Optional.IsDefined(KeyAlgorithm))
            {
                writer.WritePropertyName("keyAlgorithm"u8);
                writer.WriteStringValue(KeyAlgorithm);
            }
            if (Optional.IsCollectionDefined(SubjectLocality))
            {
                writer.WritePropertyName("subjectLocality"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectLocality)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SubjectState))
            {
                writer.WritePropertyName("subjectState"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectState)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SubjectCountry))
            {
                writer.WritePropertyName("subjectCountry"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectCountry)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerLocality))
            {
                writer.WritePropertyName("issuerLocality"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerLocality)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerState))
            {
                writer.WritePropertyName("issuerState"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerState)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerCountry))
            {
                writer.WritePropertyName("issuerCountry"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerCountry)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SubjectOrganizations))
            {
                writer.WritePropertyName("subjectOrganizations"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectOrganizations)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SubjectOrganizationalUnits))
            {
                writer.WritePropertyName("subjectOrganizationalUnits"u8);
                writer.WriteStartArray();
                foreach (var item in SubjectOrganizationalUnits)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerOrganizations))
            {
                writer.WritePropertyName("issuerOrganizations"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerOrganizations)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IssuerOrganizationalUnits))
            {
                writer.WritePropertyName("issuerOrganizationalUnits"u8);
                writer.WriteStartArray();
                foreach (var item in IssuerOrganizationalUnits)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteNumberValue(Version.Value);
            }
            if (Optional.IsDefined(CertificateAuthority))
            {
                writer.WritePropertyName("certificateAuthority"u8);
                writer.WriteBooleanValue(CertificateAuthority.Value);
            }
            if (Optional.IsDefined(SelfSigned))
            {
                writer.WritePropertyName("selfSigned"u8);
                writer.WriteBooleanValue(SelfSigned.Value);
            }
            if (Optional.IsDefined(SigAlgOid))
            {
                writer.WritePropertyName("sigAlgOid"u8);
                writer.WriteStringValue(SigAlgOid);
            }
            if (Optional.IsDefined(Recent))
            {
                writer.WritePropertyName("recent"u8);
                writer.WriteBooleanValue(Recent.Value);
            }
            if (Optional.IsDefined(ValidationType))
            {
                writer.WritePropertyName("validationType"u8);
                writer.WriteStringValue(ValidationType.Value.ToString());
            }
        }

        SslCertAsset IJsonModel<SslCertAsset>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SslCertAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SslCertAsset)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSslCertAsset(document.RootElement, options);
        }

        internal static SslCertAsset DeserializeSslCertAsset(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sha1 = default;
            IReadOnlyList<string> subjectCommonNames = default;
            IReadOnlyList<string> organizations = default;
            IReadOnlyList<string> organizationalUnits = default;
            IReadOnlyList<string> issuerCommonNames = default;
            string sigAlgName = default;
            DateTimeOffset? invalidAfter = default;
            string serialNumber = default;
            IReadOnlyList<string> subjectAlternativeNames = default;
            IReadOnlyList<string> issuerAlternativeNames = default;
            IReadOnlyList<SourceDetails> sources = default;
            DateTimeOffset? firstSeen = default;
            DateTimeOffset? lastSeen = default;
            long? count = default;
            DateTimeOffset? invalidBefore = default;
            int? keySize = default;
            string keyAlgorithm = default;
            IReadOnlyList<string> subjectLocality = default;
            IReadOnlyList<string> subjectState = default;
            IReadOnlyList<string> subjectCountry = default;
            IReadOnlyList<string> issuerLocality = default;
            IReadOnlyList<string> issuerState = default;
            IReadOnlyList<string> issuerCountry = default;
            IReadOnlyList<string> subjectOrganizations = default;
            IReadOnlyList<string> subjectOrganizationalUnits = default;
            IReadOnlyList<string> issuerOrganizations = default;
            IReadOnlyList<string> issuerOrganizationalUnits = default;
            int? version = default;
            bool? certificateAuthority = default;
            bool? selfSigned = default;
            string sigAlgOid = default;
            bool? recent = default;
            SslCertAssetValidationType? validationType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sha1"u8))
                {
                    sha1 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subjectCommonNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectCommonNames = array;
                    continue;
                }
                if (property.NameEquals("organizations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    organizations = array;
                    continue;
                }
                if (property.NameEquals("organizationalUnits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    organizationalUnits = array;
                    continue;
                }
                if (property.NameEquals("issuerCommonNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerCommonNames = array;
                    continue;
                }
                if (property.NameEquals("sigAlgName"u8))
                {
                    sigAlgName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("invalidAfter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invalidAfter = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("serialNumber"u8))
                {
                    serialNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subjectAlternativeNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectAlternativeNames = array;
                    continue;
                }
                if (property.NameEquals("issuerAlternativeNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerAlternativeNames = array;
                    continue;
                }
                if (property.NameEquals("sources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SourceDetails> array = new List<SourceDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SourceDetails.DeserializeSourceDetails(item, options));
                    }
                    sources = array;
                    continue;
                }
                if (property.NameEquals("firstSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("count"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    count = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("invalidBefore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invalidBefore = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("keySize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    keySize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("keyAlgorithm"u8))
                {
                    keyAlgorithm = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subjectLocality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectLocality = array;
                    continue;
                }
                if (property.NameEquals("subjectState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectState = array;
                    continue;
                }
                if (property.NameEquals("subjectCountry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectCountry = array;
                    continue;
                }
                if (property.NameEquals("issuerLocality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerLocality = array;
                    continue;
                }
                if (property.NameEquals("issuerState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerState = array;
                    continue;
                }
                if (property.NameEquals("issuerCountry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerCountry = array;
                    continue;
                }
                if (property.NameEquals("subjectOrganizations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectOrganizations = array;
                    continue;
                }
                if (property.NameEquals("subjectOrganizationalUnits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    subjectOrganizationalUnits = array;
                    continue;
                }
                if (property.NameEquals("issuerOrganizations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerOrganizations = array;
                    continue;
                }
                if (property.NameEquals("issuerOrganizationalUnits"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    issuerOrganizationalUnits = array;
                    continue;
                }
                if (property.NameEquals("version"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    version = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("certificateAuthority"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    certificateAuthority = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("selfSigned"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    selfSigned = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sigAlgOid"u8))
                {
                    sigAlgOid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recent = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("validationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationType = new SslCertAssetValidationType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SslCertAsset(
                serializedAdditionalRawData,
                sha1,
                subjectCommonNames ?? new ChangeTrackingList<string>(),
                organizations ?? new ChangeTrackingList<string>(),
                organizationalUnits ?? new ChangeTrackingList<string>(),
                issuerCommonNames ?? new ChangeTrackingList<string>(),
                sigAlgName,
                invalidAfter,
                serialNumber,
                subjectAlternativeNames ?? new ChangeTrackingList<string>(),
                issuerAlternativeNames ?? new ChangeTrackingList<string>(),
                sources ?? new ChangeTrackingList<SourceDetails>(),
                firstSeen,
                lastSeen,
                count,
                invalidBefore,
                keySize,
                keyAlgorithm,
                subjectLocality ?? new ChangeTrackingList<string>(),
                subjectState ?? new ChangeTrackingList<string>(),
                subjectCountry ?? new ChangeTrackingList<string>(),
                issuerLocality ?? new ChangeTrackingList<string>(),
                issuerState ?? new ChangeTrackingList<string>(),
                issuerCountry ?? new ChangeTrackingList<string>(),
                subjectOrganizations ?? new ChangeTrackingList<string>(),
                subjectOrganizationalUnits ?? new ChangeTrackingList<string>(),
                issuerOrganizations ?? new ChangeTrackingList<string>(),
                issuerOrganizationalUnits ?? new ChangeTrackingList<string>(),
                version,
                certificateAuthority,
                selfSigned,
                sigAlgOid,
                recent,
                validationType);
        }

        BinaryData IPersistableModel<SslCertAsset>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SslCertAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SslCertAsset)} does not support writing '{options.Format}' format.");
            }
        }

        SslCertAsset IPersistableModel<SslCertAsset>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SslCertAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSslCertAsset(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SslCertAsset)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SslCertAsset>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new SslCertAsset FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSslCertAsset(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
