// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The SoaRecord. </summary>
    public partial class SoaRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SoaRecord"/>. </summary>
        internal SoaRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SoaRecord"/>. </summary>
        /// <param name="nameServer"></param>
        /// <param name="email"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="serialNumber"></param>
        /// <param name="recent"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SoaRecord(string nameServer, string email, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, long? serialNumber, bool? recent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NameServer = nameServer;
            Email = email;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            SerialNumber = serialNumber;
            Recent = recent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the name server. </summary>
        public string NameServer { get; }
        /// <summary> Gets the email. </summary>
        public string Email { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the serial number. </summary>
        public long? SerialNumber { get; }
        /// <summary> Gets the recent. </summary>
        public bool? Recent { get; }
    }
}
