// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ScanMetadata. </summary>
    public partial class ScanMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScanMetadata"/>. </summary>
        internal ScanMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScanMetadata"/>. </summary>
        /// <param name="port"></param>
        /// <param name="bannerMetadata"></param>
        /// <param name="startScan"></param>
        /// <param name="endScan"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScanMetadata(int? port, string bannerMetadata, DateTimeOffset? startScan, DateTimeOffset? endScan, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Port = port;
            BannerMetadata = bannerMetadata;
            StartScan = startScan;
            EndScan = endScan;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the port. </summary>
        public int? Port { get; }
        /// <summary> Gets the banner metadata. </summary>
        public string BannerMetadata { get; }
        /// <summary> Gets the start scan. </summary>
        public DateTimeOffset? StartScan { get; }
        /// <summary> Gets the end scan. </summary>
        public DateTimeOffset? EndScan { get; }
    }
}
