// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ReportBillableAssetSummaryResult. </summary>
    public partial class ReportBillableAssetSummaryResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReportBillableAssetSummaryResult"/>. </summary>
        internal ReportBillableAssetSummaryResult()
        {
            AssetSummaries = new ChangeTrackingList<ReportBillableAssetSnapshotResult>();
        }

        /// <summary> Initializes a new instance of <see cref="ReportBillableAssetSummaryResult"/>. </summary>
        /// <param name="assetSummaries"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReportBillableAssetSummaryResult(IReadOnlyList<ReportBillableAssetSnapshotResult> assetSummaries, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AssetSummaries = assetSummaries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the asset summaries. </summary>
        public IReadOnlyList<ReportBillableAssetSnapshotResult> AssetSummaries { get; }
    }
}
