// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ReportAssetSummaryResult. </summary>
    public partial class ReportAssetSummaryResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReportAssetSummaryResult"/>. </summary>
        internal ReportAssetSummaryResult()
        {
            AssetSummaries = new ChangeTrackingList<AssetSummaryResult>();
        }

        /// <summary> Initializes a new instance of <see cref="ReportAssetSummaryResult"/>. </summary>
        /// <param name="assetSummaries"> The collection of asset summaries. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReportAssetSummaryResult(IReadOnlyList<AssetSummaryResult> assetSummaries, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AssetSummaries = assetSummaries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The collection of asset summaries. </summary>
        public IReadOnlyList<AssetSummaryResult> AssetSummaries { get; }
    }
}
