// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The PageCause. </summary>
    public partial class PageCause
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PageCause"/>. </summary>
        internal PageCause()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PageCause"/>. </summary>
        /// <param name="cause"></param>
        /// <param name="causeElementXPath"></param>
        /// <param name="location"></param>
        /// <param name="possibleMatches"></param>
        /// <param name="loopDetected"></param>
        /// <param name="version"></param>
        /// <param name="domChangeIndex"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PageCause(string cause, string causeElementXPath, string location, int? possibleMatches, bool? loopDetected, int? version, int? domChangeIndex, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cause = cause;
            CauseElementXPath = causeElementXPath;
            Location = location;
            PossibleMatches = possibleMatches;
            LoopDetected = loopDetected;
            Version = version;
            DomChangeIndex = domChangeIndex;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the cause. </summary>
        public string Cause { get; }
        /// <summary> Gets the cause element x path. </summary>
        public string CauseElementXPath { get; }
        /// <summary> Gets the location. </summary>
        public string Location { get; }
        /// <summary> Gets the possible matches. </summary>
        public int? PossibleMatches { get; }
        /// <summary> Gets the loop detected. </summary>
        public bool? LoopDetected { get; }
        /// <summary> Gets the version. </summary>
        public int? Version { get; }
        /// <summary> Gets the dom change index. </summary>
        public int? DomChangeIndex { get; }
    }
}
