// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    public partial class PageAsset : IUtf8JsonSerializable, IJsonModel<PageAsset>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PageAsset>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PageAsset>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PageAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PageAsset)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url.AbsoluteUri);
            }
            if (Optional.IsDefined(HttpMethod))
            {
                writer.WritePropertyName("httpMethod"u8);
                writer.WriteStringValue(HttpMethod);
            }
            if (Optional.IsDefined(Service))
            {
                writer.WritePropertyName("service"u8);
                writer.WriteStringValue(Service);
            }
            if (Optional.IsCollectionDefined(IpAddresses))
            {
                writer.WritePropertyName("ipAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in IpAddresses)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Successful))
            {
                writer.WritePropertyName("successful"u8);
                writer.WriteStartArray();
                foreach (var item in Successful)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(HttpResponseCodes))
            {
                writer.WritePropertyName("httpResponseCodes"u8);
                writer.WriteStartArray();
                foreach (var item in HttpResponseCodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(HttpResponseMessages))
            {
                writer.WritePropertyName("httpResponseMessages"u8);
                writer.WriteStartArray();
                foreach (var item in HttpResponseMessages)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseTimes))
            {
                writer.WritePropertyName("responseTimes"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseTimes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Frames))
            {
                writer.WritePropertyName("frames"u8);
                writer.WriteStartArray();
                foreach (var item in Frames)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Windows))
            {
                writer.WritePropertyName("windows"u8);
                writer.WriteStartArray();
                foreach (var item in Windows)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(NonHtmlFrames))
            {
                writer.WritePropertyName("nonHtmlFrames"u8);
                writer.WriteStartArray();
                foreach (var item in NonHtmlFrames)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(UndirectedContent))
            {
                writer.WritePropertyName("undirectedContent"u8);
                writer.WriteStartArray();
                foreach (var item in UndirectedContent)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ContentTypes))
            {
                writer.WritePropertyName("contentTypes"u8);
                writer.WriteStartArray();
                foreach (var item in ContentTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ContentLengths))
            {
                writer.WritePropertyName("contentLengths"u8);
                writer.WriteStartArray();
                foreach (var item in ContentLengths)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(WindowNames))
            {
                writer.WritePropertyName("windowNames"u8);
                writer.WriteStartArray();
                foreach (var item in WindowNames)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Charsets))
            {
                writer.WritePropertyName("charsets"u8);
                writer.WriteStartArray();
                foreach (var item in Charsets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Titles))
            {
                writer.WritePropertyName("titles"u8);
                writer.WriteStartArray();
                foreach (var item in Titles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Languages))
            {
                writer.WritePropertyName("languages"u8);
                writer.WriteStartArray();
                foreach (var item in Languages)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseHeaders))
            {
                writer.WritePropertyName("responseHeaders"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseHeaders)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Cookies))
            {
                writer.WritePropertyName("cookies"u8);
                writer.WriteStartArray();
                foreach (var item in Cookies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(WebComponents))
            {
                writer.WritePropertyName("webComponents"u8);
                writer.WriteStartArray();
                foreach (var item in WebComponents)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Attributes))
            {
                writer.WritePropertyName("attributes"u8);
                writer.WriteStartArray();
                foreach (var item in Attributes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AssetSecurityPolicies))
            {
                writer.WritePropertyName("assetSecurityPolicies"u8);
                writer.WriteStartArray();
                foreach (var item in AssetSecurityPolicies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseBodyMinhashSignatures))
            {
                writer.WritePropertyName("responseBodyMinhashSignatures"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseBodyMinhashSignatures)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FullDomMinhashSignatures))
            {
                writer.WritePropertyName("fullDomMinhashSignatures"u8);
                writer.WriteStartArray();
                foreach (var item in FullDomMinhashSignatures)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseBodyHashSignatures))
            {
                writer.WritePropertyName("responseBodyHashSignatures"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseBodyHashSignatures)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SslCerts))
            {
                writer.WritePropertyName("sslCerts"u8);
                writer.WriteStartArray();
                foreach (var item in SslCerts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sources))
            {
                writer.WritePropertyName("sources"u8);
                writer.WriteStartArray();
                foreach (var item in Sources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FirstSeen))
            {
                writer.WritePropertyName("firstSeen"u8);
                writer.WriteStringValue(FirstSeen.Value, "O");
            }
            if (Optional.IsDefined(LastSeen))
            {
                writer.WritePropertyName("lastSeen"u8);
                writer.WriteStringValue(LastSeen.Value, "O");
            }
            if (Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (Optional.IsDefined(Cause))
            {
                writer.WritePropertyName("cause"u8);
                writer.WriteObjectValue(Cause, options);
            }
            if (Optional.IsDefined(Referrer))
            {
                writer.WritePropertyName("referrer"u8);
                writer.WriteStringValue(Referrer);
            }
            if (Optional.IsCollectionDefined(RedirectUrls))
            {
                writer.WritePropertyName("redirectUrls"u8);
                writer.WriteStartArray();
                foreach (var item in RedirectUrls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(RedirectType))
            {
                writer.WritePropertyName("redirectType"u8);
                writer.WriteStringValue(RedirectType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(FinalUrls))
            {
                writer.WritePropertyName("finalUrls"u8);
                writer.WriteStartArray();
                foreach (var item in FinalUrls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FinalResponseCodes))
            {
                writer.WritePropertyName("finalResponseCodes"u8);
                writer.WriteStartArray();
                foreach (var item in FinalResponseCodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ParkedPage))
            {
                writer.WritePropertyName("parkedPage"u8);
                writer.WriteStartArray();
                foreach (var item in ParkedPage)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResourceUrls))
            {
                writer.WritePropertyName("resourceUrls"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceUrls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Guids))
            {
                writer.WritePropertyName("guids"u8);
                writer.WriteStartArray();
                foreach (var item in Guids)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FinalIpAddresses))
            {
                writer.WritePropertyName("finalIpAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in FinalIpAddresses)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Asns))
            {
                writer.WritePropertyName("asns"u8);
                writer.WriteStartArray();
                foreach (var item in Asns)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IpBlocks))
            {
                writer.WritePropertyName("ipBlocks"u8);
                writer.WriteStartArray();
                foreach (var item in IpBlocks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FinalAsns))
            {
                writer.WritePropertyName("finalAsns"u8);
                writer.WriteStartArray();
                foreach (var item in FinalAsns)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FinalIpBlocks))
            {
                writer.WritePropertyName("finalIpBlocks"u8);
                writer.WriteStartArray();
                foreach (var item in FinalIpBlocks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseBodies))
            {
                writer.WritePropertyName("responseBodies"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseBodies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DomainAsset))
            {
                writer.WritePropertyName("domainAsset"u8);
                writer.WriteObjectValue(DomainAsset, options);
            }
            if (Optional.IsDefined(RootUrl))
            {
                writer.WritePropertyName("rootUrl"u8);
                writer.WriteObjectValue(RootUrl, options);
            }
            if (Optional.IsDefined(IsRootUrl))
            {
                writer.WritePropertyName("isRootUrl"u8);
                writer.WriteBooleanValue(IsRootUrl.Value);
            }
            if (Optional.IsCollectionDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStartArray();
                foreach (var item in Location)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Services))
            {
                writer.WritePropertyName("services"u8);
                writer.WriteStartArray();
                foreach (var item in Services)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SiteStatus))
            {
                writer.WritePropertyName("siteStatus"u8);
                writer.WriteStringValue(SiteStatus);
            }
            if (Optional.IsCollectionDefined(Cnames))
            {
                writer.WritePropertyName("cnames"u8);
                writer.WriteStartArray();
                foreach (var item in Cnames)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Cdns))
            {
                writer.WritePropertyName("cdns"u8);
                writer.WriteStartArray();
                foreach (var item in Cdns)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Host))
            {
                writer.WritePropertyName("host"u8);
                writer.WriteStringValue(Host);
            }
            if (Optional.IsDefined(Domain))
            {
                writer.WritePropertyName("domain"u8);
                writer.WriteStringValue(Domain);
            }
            if (Optional.IsCollectionDefined(SslServerConfig))
            {
                writer.WritePropertyName("sslServerConfig"u8);
                writer.WriteStartArray();
                foreach (var item in SslServerConfig)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GdprAssetSecurityPolicies))
            {
                writer.WritePropertyName("gdprAssetSecurityPolicies"u8);
                writer.WriteStartArray();
                foreach (var item in GdprAssetSecurityPolicies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ipv4))
            {
                writer.WritePropertyName("ipv4"u8);
                writer.WriteStartArray();
                foreach (var item in Ipv4)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ipv6))
            {
                writer.WritePropertyName("ipv6"u8);
                writer.WriteStartArray();
                foreach (var item in Ipv6)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
        }

        PageAsset IJsonModel<PageAsset>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PageAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PageAsset)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePageAsset(document.RootElement, options);
        }

        internal static PageAsset DeserializePageAsset(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri url = default;
            string httpMethod = default;
            string service = default;
            IReadOnlyList<ObservedString> ipAddresses = default;
            IReadOnlyList<ObservedBoolean> successful = default;
            IReadOnlyList<ObservedInteger> httpResponseCodes = default;
            IReadOnlyList<ObservedString> httpResponseMessages = default;
            IReadOnlyList<ObservedLong> responseTimes = default;
            IReadOnlyList<ObservedBoolean> frames = default;
            IReadOnlyList<ObservedBoolean> windows = default;
            IReadOnlyList<ObservedBoolean> nonHtmlFrames = default;
            IReadOnlyList<ObservedBoolean> undirectedContent = default;
            IReadOnlyList<ObservedString> contentTypes = default;
            IReadOnlyList<ObservedLong> contentLengths = default;
            IReadOnlyList<ObservedString> windowNames = default;
            IReadOnlyList<ObservedString> charsets = default;
            IReadOnlyList<ObservedString> titles = default;
            IReadOnlyList<ObservedString> languages = default;
            IReadOnlyList<ObservedHeader> responseHeaders = default;
            IReadOnlyList<CookieDetails> cookies = default;
            IReadOnlyList<WebComponent> webComponents = default;
            IReadOnlyList<AttributeDetails> attributes = default;
            IReadOnlyList<AssetSecurityPolicy> assetSecurityPolicies = default;
            IReadOnlyList<ObservedIntegers> responseBodyMinhashSignatures = default;
            IReadOnlyList<ObservedIntegers> fullDomMinhashSignatures = default;
            IReadOnlyList<ObservedString> responseBodyHashSignatures = default;
            IReadOnlyList<ObservedString> errors = default;
            IReadOnlyList<SslCertAsset> sslCerts = default;
            IReadOnlyList<SourceDetails> sources = default;
            DateTimeOffset? firstSeen = default;
            DateTimeOffset? lastSeen = default;
            long? count = default;
            PageCause cause = default;
            string referrer = default;
            IReadOnlyList<ObservedString> redirectUrls = default;
            PageAssetRedirectType? redirectType = default;
            IReadOnlyList<ObservedString> finalUrls = default;
            IReadOnlyList<ObservedInteger> finalResponseCodes = default;
            IReadOnlyList<ObservedBoolean> parkedPage = default;
            IReadOnlyList<ResourceUri> resourceUrls = default;
            IReadOnlyList<GuidPair> guids = default;
            IReadOnlyList<ObservedString> finalIpAddresses = default;
            IReadOnlyList<ObservedLong> asns = default;
            IReadOnlyList<IpBlock> ipBlocks = default;
            IReadOnlyList<ObservedLong> finalAsns = default;
            IReadOnlyList<IpBlock> finalIpBlocks = default;
            IReadOnlyList<ObservedString> responseBodies = default;
            DomainAsset domainAsset = default;
            ObservedBoolean rootUrl = default;
            bool? isRootUrl = default;
            IReadOnlyList<ObservedLocation> location = default;
            IReadOnlyList<AssetService> services = default;
            string siteStatus = default;
            IReadOnlyList<ObservedString> cnames = default;
            IReadOnlyList<ObservedString> cdns = default;
            string host = default;
            string domain = default;
            IReadOnlyList<SslServerConfig> sslServerConfig = default;
            IReadOnlyList<AssetSecurityPolicy> gdprAssetSecurityPolicies = default;
            IReadOnlyList<ObservedBoolean> ipv4 = default;
            IReadOnlyList<ObservedBoolean> ipv6 = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("url"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    url = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("httpMethod"u8))
                {
                    httpMethod = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("service"u8))
                {
                    service = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    ipAddresses = array;
                    continue;
                }
                if (property.NameEquals("successful"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    successful = array;
                    continue;
                }
                if (property.NameEquals("httpResponseCodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedInteger> array = new List<ObservedInteger>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedInteger.DeserializeObservedInteger(item, options));
                    }
                    httpResponseCodes = array;
                    continue;
                }
                if (property.NameEquals("httpResponseMessages"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    httpResponseMessages = array;
                    continue;
                }
                if (property.NameEquals("responseTimes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLong> array = new List<ObservedLong>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLong.DeserializeObservedLong(item, options));
                    }
                    responseTimes = array;
                    continue;
                }
                if (property.NameEquals("frames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    frames = array;
                    continue;
                }
                if (property.NameEquals("windows"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    windows = array;
                    continue;
                }
                if (property.NameEquals("nonHtmlFrames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    nonHtmlFrames = array;
                    continue;
                }
                if (property.NameEquals("undirectedContent"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    undirectedContent = array;
                    continue;
                }
                if (property.NameEquals("contentTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    contentTypes = array;
                    continue;
                }
                if (property.NameEquals("contentLengths"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLong> array = new List<ObservedLong>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLong.DeserializeObservedLong(item, options));
                    }
                    contentLengths = array;
                    continue;
                }
                if (property.NameEquals("windowNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    windowNames = array;
                    continue;
                }
                if (property.NameEquals("charsets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    charsets = array;
                    continue;
                }
                if (property.NameEquals("titles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    titles = array;
                    continue;
                }
                if (property.NameEquals("languages"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    languages = array;
                    continue;
                }
                if (property.NameEquals("responseHeaders"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedHeader> array = new List<ObservedHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedHeader.DeserializeObservedHeader(item, options));
                    }
                    responseHeaders = array;
                    continue;
                }
                if (property.NameEquals("cookies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CookieDetails> array = new List<CookieDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CookieDetails.DeserializeCookieDetails(item, options));
                    }
                    cookies = array;
                    continue;
                }
                if (property.NameEquals("webComponents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WebComponent> array = new List<WebComponent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(WebComponent.DeserializeWebComponent(item, options));
                    }
                    webComponents = array;
                    continue;
                }
                if (property.NameEquals("attributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AttributeDetails> array = new List<AttributeDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AttributeDetails.DeserializeAttributeDetails(item, options));
                    }
                    attributes = array;
                    continue;
                }
                if (property.NameEquals("assetSecurityPolicies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AssetSecurityPolicy> array = new List<AssetSecurityPolicy>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AssetSecurityPolicy.DeserializeAssetSecurityPolicy(item, options));
                    }
                    assetSecurityPolicies = array;
                    continue;
                }
                if (property.NameEquals("responseBodyMinhashSignatures"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedIntegers> array = new List<ObservedIntegers>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedIntegers.DeserializeObservedIntegers(item, options));
                    }
                    responseBodyMinhashSignatures = array;
                    continue;
                }
                if (property.NameEquals("fullDomMinhashSignatures"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedIntegers> array = new List<ObservedIntegers>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedIntegers.DeserializeObservedIntegers(item, options));
                    }
                    fullDomMinhashSignatures = array;
                    continue;
                }
                if (property.NameEquals("responseBodyHashSignatures"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    responseBodyHashSignatures = array;
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    errors = array;
                    continue;
                }
                if (property.NameEquals("sslCerts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SslCertAsset> array = new List<SslCertAsset>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SslCertAsset.DeserializeSslCertAsset(item, options));
                    }
                    sslCerts = array;
                    continue;
                }
                if (property.NameEquals("sources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SourceDetails> array = new List<SourceDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SourceDetails.DeserializeSourceDetails(item, options));
                    }
                    sources = array;
                    continue;
                }
                if (property.NameEquals("firstSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("count"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    count = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("cause"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cause = PageCause.DeserializePageCause(property.Value, options);
                    continue;
                }
                if (property.NameEquals("referrer"u8))
                {
                    referrer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("redirectUrls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    redirectUrls = array;
                    continue;
                }
                if (property.NameEquals("redirectType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    redirectType = new PageAssetRedirectType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("finalUrls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    finalUrls = array;
                    continue;
                }
                if (property.NameEquals("finalResponseCodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedInteger> array = new List<ObservedInteger>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedInteger.DeserializeObservedInteger(item, options));
                    }
                    finalResponseCodes = array;
                    continue;
                }
                if (property.NameEquals("parkedPage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    parkedPage = array;
                    continue;
                }
                if (property.NameEquals("resourceUrls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceUri> array = new List<ResourceUri>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceUri.DeserializeResourceUri(item, options));
                    }
                    resourceUrls = array;
                    continue;
                }
                if (property.NameEquals("guids"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GuidPair> array = new List<GuidPair>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GuidPair.DeserializeGuidPair(item, options));
                    }
                    guids = array;
                    continue;
                }
                if (property.NameEquals("finalIpAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    finalIpAddresses = array;
                    continue;
                }
                if (property.NameEquals("asns"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLong> array = new List<ObservedLong>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLong.DeserializeObservedLong(item, options));
                    }
                    asns = array;
                    continue;
                }
                if (property.NameEquals("ipBlocks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IpBlock> array = new List<IpBlock>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IpBlock.DeserializeIpBlock(item, options));
                    }
                    ipBlocks = array;
                    continue;
                }
                if (property.NameEquals("finalAsns"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLong> array = new List<ObservedLong>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLong.DeserializeObservedLong(item, options));
                    }
                    finalAsns = array;
                    continue;
                }
                if (property.NameEquals("finalIpBlocks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IpBlock> array = new List<IpBlock>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IpBlock.DeserializeIpBlock(item, options));
                    }
                    finalIpBlocks = array;
                    continue;
                }
                if (property.NameEquals("responseBodies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    responseBodies = array;
                    continue;
                }
                if (property.NameEquals("domainAsset"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    domainAsset = DomainAsset.DeserializeDomainAsset(property.Value, options);
                    continue;
                }
                if (property.NameEquals("rootUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rootUrl = ObservedBoolean.DeserializeObservedBoolean(property.Value, options);
                    continue;
                }
                if (property.NameEquals("isRootUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRootUrl = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLocation> array = new List<ObservedLocation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLocation.DeserializeObservedLocation(item, options));
                    }
                    location = array;
                    continue;
                }
                if (property.NameEquals("services"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AssetService> array = new List<AssetService>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AssetService.DeserializeAssetService(item, options));
                    }
                    services = array;
                    continue;
                }
                if (property.NameEquals("siteStatus"u8))
                {
                    siteStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cnames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    cnames = array;
                    continue;
                }
                if (property.NameEquals("cdns"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    cdns = array;
                    continue;
                }
                if (property.NameEquals("host"u8))
                {
                    host = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("domain"u8))
                {
                    domain = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sslServerConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SslServerConfig> array = new List<SslServerConfig>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Easm.SslServerConfig.DeserializeSslServerConfig(item, options));
                    }
                    sslServerConfig = array;
                    continue;
                }
                if (property.NameEquals("gdprAssetSecurityPolicies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AssetSecurityPolicy> array = new List<AssetSecurityPolicy>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AssetSecurityPolicy.DeserializeAssetSecurityPolicy(item, options));
                    }
                    gdprAssetSecurityPolicies = array;
                    continue;
                }
                if (property.NameEquals("ipv4"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    ipv4 = array;
                    continue;
                }
                if (property.NameEquals("ipv6"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    ipv6 = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PageAsset(
                serializedAdditionalRawData,
                url,
                httpMethod,
                service,
                ipAddresses ?? new ChangeTrackingList<ObservedString>(),
                successful ?? new ChangeTrackingList<ObservedBoolean>(),
                httpResponseCodes ?? new ChangeTrackingList<ObservedInteger>(),
                httpResponseMessages ?? new ChangeTrackingList<ObservedString>(),
                responseTimes ?? new ChangeTrackingList<ObservedLong>(),
                frames ?? new ChangeTrackingList<ObservedBoolean>(),
                windows ?? new ChangeTrackingList<ObservedBoolean>(),
                nonHtmlFrames ?? new ChangeTrackingList<ObservedBoolean>(),
                undirectedContent ?? new ChangeTrackingList<ObservedBoolean>(),
                contentTypes ?? new ChangeTrackingList<ObservedString>(),
                contentLengths ?? new ChangeTrackingList<ObservedLong>(),
                windowNames ?? new ChangeTrackingList<ObservedString>(),
                charsets ?? new ChangeTrackingList<ObservedString>(),
                titles ?? new ChangeTrackingList<ObservedString>(),
                languages ?? new ChangeTrackingList<ObservedString>(),
                responseHeaders ?? new ChangeTrackingList<ObservedHeader>(),
                cookies ?? new ChangeTrackingList<CookieDetails>(),
                webComponents ?? new ChangeTrackingList<WebComponent>(),
                attributes ?? new ChangeTrackingList<AttributeDetails>(),
                assetSecurityPolicies ?? new ChangeTrackingList<AssetSecurityPolicy>(),
                responseBodyMinhashSignatures ?? new ChangeTrackingList<ObservedIntegers>(),
                fullDomMinhashSignatures ?? new ChangeTrackingList<ObservedIntegers>(),
                responseBodyHashSignatures ?? new ChangeTrackingList<ObservedString>(),
                errors ?? new ChangeTrackingList<ObservedString>(),
                sslCerts ?? new ChangeTrackingList<SslCertAsset>(),
                sources ?? new ChangeTrackingList<SourceDetails>(),
                firstSeen,
                lastSeen,
                count,
                cause,
                referrer,
                redirectUrls ?? new ChangeTrackingList<ObservedString>(),
                redirectType,
                finalUrls ?? new ChangeTrackingList<ObservedString>(),
                finalResponseCodes ?? new ChangeTrackingList<ObservedInteger>(),
                parkedPage ?? new ChangeTrackingList<ObservedBoolean>(),
                resourceUrls ?? new ChangeTrackingList<ResourceUri>(),
                guids ?? new ChangeTrackingList<GuidPair>(),
                finalIpAddresses ?? new ChangeTrackingList<ObservedString>(),
                asns ?? new ChangeTrackingList<ObservedLong>(),
                ipBlocks ?? new ChangeTrackingList<IpBlock>(),
                finalAsns ?? new ChangeTrackingList<ObservedLong>(),
                finalIpBlocks ?? new ChangeTrackingList<IpBlock>(),
                responseBodies ?? new ChangeTrackingList<ObservedString>(),
                domainAsset,
                rootUrl,
                isRootUrl,
                location ?? new ChangeTrackingList<ObservedLocation>(),
                services ?? new ChangeTrackingList<AssetService>(),
                siteStatus,
                cnames ?? new ChangeTrackingList<ObservedString>(),
                cdns ?? new ChangeTrackingList<ObservedString>(),
                host,
                domain,
                sslServerConfig ?? new ChangeTrackingList<SslServerConfig>(),
                gdprAssetSecurityPolicies ?? new ChangeTrackingList<AssetSecurityPolicy>(),
                ipv4 ?? new ChangeTrackingList<ObservedBoolean>(),
                ipv6 ?? new ChangeTrackingList<ObservedBoolean>());
        }

        BinaryData IPersistableModel<PageAsset>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PageAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PageAsset)} does not support writing '{options.Format}' format.");
            }
        }

        PageAsset IPersistableModel<PageAsset>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PageAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePageAsset(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PageAsset)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PageAsset>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new PageAsset FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePageAsset(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
