// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ObservedPortState. </summary>
    public partial class ObservedPortState : ObservedValue
    {
        /// <summary> Initializes a new instance of <see cref="ObservedPortState"/>. </summary>
        internal ObservedPortState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ObservedPortState"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"></param>
        /// <param name="port"></param>
        internal ObservedPortState(DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, bool? recent, IDictionary<string, BinaryData> serializedAdditionalRawData, ObservedPortStateValue? value, int? port) : base(firstSeen, lastSeen, count, recent, serializedAdditionalRawData)
        {
            Value = value;
            Port = port;
        }

        /// <summary> Gets the value. </summary>
        public ObservedPortStateValue? Value { get; }
        /// <summary> Gets the port. </summary>
        public int? Port { get; }
    }
}
