// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ObservedLocationDetails. </summary>
    public partial class ObservedLocationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ObservedLocationDetails"/>. </summary>
        internal ObservedLocationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ObservedLocationDetails"/>. </summary>
        /// <param name="countryCode"></param>
        /// <param name="countryName"></param>
        /// <param name="region"></param>
        /// <param name="regionName"></param>
        /// <param name="city"></param>
        /// <param name="areaCode"></param>
        /// <param name="postalCode"></param>
        /// <param name="latitude"></param>
        /// <param name="longitude"></param>
        /// <param name="dmaCode"></param>
        /// <param name="metroCodeId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ObservedLocationDetails(string countryCode, string countryName, string region, string regionName, string city, int? areaCode, string postalCode, float? latitude, float? longitude, int? dmaCode, int? metroCodeId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CountryCode = countryCode;
            CountryName = countryName;
            Region = region;
            RegionName = regionName;
            City = city;
            AreaCode = areaCode;
            PostalCode = postalCode;
            Latitude = latitude;
            Longitude = longitude;
            DmaCode = dmaCode;
            MetroCodeId = metroCodeId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the country code. </summary>
        public string CountryCode { get; }
        /// <summary> Gets the country name. </summary>
        public string CountryName { get; }
        /// <summary> Gets the region. </summary>
        public string Region { get; }
        /// <summary> Gets the region name. </summary>
        public string RegionName { get; }
        /// <summary> Gets the city. </summary>
        public string City { get; }
        /// <summary> Gets the area code. </summary>
        public int? AreaCode { get; }
        /// <summary> Gets the postal code. </summary>
        public string PostalCode { get; }
        /// <summary> Gets the latitude. </summary>
        public float? Latitude { get; }
        /// <summary> Gets the longitude. </summary>
        public float? Longitude { get; }
        /// <summary> Gets the dma code. </summary>
        public int? DmaCode { get; }
        /// <summary> Gets the metro code id. </summary>
        public int? MetroCodeId { get; }
    }
}
