// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The ObservedHeader. </summary>
    public partial class ObservedHeader : ObservedValue
    {
        /// <summary> Initializes a new instance of <see cref="ObservedHeader"/>. </summary>
        internal ObservedHeader()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ObservedHeader"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="headerName"></param>
        /// <param name="headerValue"></param>
        internal ObservedHeader(DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, bool? recent, IDictionary<string, BinaryData> serializedAdditionalRawData, string headerName, string headerValue) : base(firstSeen, lastSeen, count, recent, serializedAdditionalRawData)
        {
            HeaderName = headerName;
            HeaderValue = headerValue;
        }

        /// <summary> Gets the header name. </summary>
        public string HeaderName { get; }
        /// <summary> Gets the header value. </summary>
        public string HeaderValue { get; }
    }
}
