// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The IpBlockAsset. </summary>
    public partial class IpBlockAsset : InventoryAsset
    {
        /// <summary> Initializes a new instance of <see cref="IpBlockAsset"/>. </summary>
        internal IpBlockAsset()
        {
            Asns = new ChangeTrackingList<ObservedLong>();
            BgpPrefixes = new ChangeTrackingList<ObservedString>();
            NetNames = new ChangeTrackingList<ObservedString>();
            RegistrantContacts = new ChangeTrackingList<ObservedString>();
            RegistrantOrgs = new ChangeTrackingList<ObservedString>();
            AdminContacts = new ChangeTrackingList<ObservedString>();
            TechnicalContacts = new ChangeTrackingList<ObservedString>();
            RegistrarCreatedAt = new ChangeTrackingList<ObservedLong>();
            RegistrarUpdatedAt = new ChangeTrackingList<ObservedLong>();
            NetRanges = new ChangeTrackingList<ObservedString>();
            Reputations = new ChangeTrackingList<ReputationDetails>();
            Sources = new ChangeTrackingList<SourceDetails>();
            Location = new ChangeTrackingList<ObservedLocation>();
            RegistrarExpiresAt = new ChangeTrackingList<ObservedLong>();
            RegistrantNames = new ChangeTrackingList<ObservedString>();
            AdminNames = new ChangeTrackingList<ObservedString>();
            TechnicalNames = new ChangeTrackingList<ObservedString>();
            AdminOrgs = new ChangeTrackingList<ObservedString>();
            TechnicalOrgs = new ChangeTrackingList<ObservedString>();
            RegistrantPhones = new ChangeTrackingList<ObservedString>();
            AdminPhones = new ChangeTrackingList<ObservedString>();
            TechnicalPhones = new ChangeTrackingList<ObservedString>();
        }

        /// <summary> Initializes a new instance of <see cref="IpBlockAsset"/>. </summary>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="ipBlock"></param>
        /// <param name="asns"></param>
        /// <param name="bgpPrefixes"></param>
        /// <param name="netNames"></param>
        /// <param name="registrantContacts"></param>
        /// <param name="registrantOrgs"></param>
        /// <param name="adminContacts"></param>
        /// <param name="technicalContacts"></param>
        /// <param name="registrarCreatedAt"></param>
        /// <param name="registrarUpdatedAt"></param>
        /// <param name="netRanges"></param>
        /// <param name="startIp"></param>
        /// <param name="endIp"></param>
        /// <param name="reputations"></param>
        /// <param name="detailedFromWhoisAt"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="location"></param>
        /// <param name="registrarExpiresAt"></param>
        /// <param name="registrantNames"></param>
        /// <param name="adminNames"></param>
        /// <param name="technicalNames"></param>
        /// <param name="adminOrgs"></param>
        /// <param name="technicalOrgs"></param>
        /// <param name="registrantPhones"></param>
        /// <param name="adminPhones"></param>
        /// <param name="technicalPhones"></param>
        /// <param name="ipv4"></param>
        /// <param name="ipv6"></param>
        internal IpBlockAsset(IDictionary<string, BinaryData> serializedAdditionalRawData, string ipBlock, IReadOnlyList<ObservedLong> asns, IReadOnlyList<ObservedString> bgpPrefixes, IReadOnlyList<ObservedString> netNames, IReadOnlyList<ObservedString> registrantContacts, IReadOnlyList<ObservedString> registrantOrgs, IReadOnlyList<ObservedString> adminContacts, IReadOnlyList<ObservedString> technicalContacts, IReadOnlyList<ObservedLong> registrarCreatedAt, IReadOnlyList<ObservedLong> registrarUpdatedAt, IReadOnlyList<ObservedString> netRanges, string startIp, string endIp, IReadOnlyList<ReputationDetails> reputations, DateTimeOffset? detailedFromWhoisAt, IReadOnlyList<SourceDetails> sources, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, IReadOnlyList<ObservedLocation> location, IReadOnlyList<ObservedLong> registrarExpiresAt, IReadOnlyList<ObservedString> registrantNames, IReadOnlyList<ObservedString> adminNames, IReadOnlyList<ObservedString> technicalNames, IReadOnlyList<ObservedString> adminOrgs, IReadOnlyList<ObservedString> technicalOrgs, IReadOnlyList<ObservedString> registrantPhones, IReadOnlyList<ObservedString> adminPhones, IReadOnlyList<ObservedString> technicalPhones, bool? ipv4, bool? ipv6) : base(serializedAdditionalRawData)
        {
            IpBlock = ipBlock;
            Asns = asns;
            BgpPrefixes = bgpPrefixes;
            NetNames = netNames;
            RegistrantContacts = registrantContacts;
            RegistrantOrgs = registrantOrgs;
            AdminContacts = adminContacts;
            TechnicalContacts = technicalContacts;
            RegistrarCreatedAt = registrarCreatedAt;
            RegistrarUpdatedAt = registrarUpdatedAt;
            NetRanges = netRanges;
            StartIp = startIp;
            EndIp = endIp;
            Reputations = reputations;
            DetailedFromWhoisAt = detailedFromWhoisAt;
            Sources = sources;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            Location = location;
            RegistrarExpiresAt = registrarExpiresAt;
            RegistrantNames = registrantNames;
            AdminNames = adminNames;
            TechnicalNames = technicalNames;
            AdminOrgs = adminOrgs;
            TechnicalOrgs = technicalOrgs;
            RegistrantPhones = registrantPhones;
            AdminPhones = adminPhones;
            TechnicalPhones = technicalPhones;
            Ipv4 = ipv4;
            Ipv6 = ipv6;
        }

        /// <summary> Gets the ip block. </summary>
        public string IpBlock { get; }
        /// <summary> Gets the asns. </summary>
        public IReadOnlyList<ObservedLong> Asns { get; }
        /// <summary> Gets the bgp prefixes. </summary>
        public IReadOnlyList<ObservedString> BgpPrefixes { get; }
        /// <summary> Gets the net names. </summary>
        public IReadOnlyList<ObservedString> NetNames { get; }
        /// <summary> Gets the registrant contacts. </summary>
        public IReadOnlyList<ObservedString> RegistrantContacts { get; }
        /// <summary> Gets the registrant orgs. </summary>
        public IReadOnlyList<ObservedString> RegistrantOrgs { get; }
        /// <summary> Gets the admin contacts. </summary>
        public IReadOnlyList<ObservedString> AdminContacts { get; }
        /// <summary> Gets the technical contacts. </summary>
        public IReadOnlyList<ObservedString> TechnicalContacts { get; }
        /// <summary> Gets the registrar created at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarCreatedAt { get; }
        /// <summary> Gets the registrar updated at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarUpdatedAt { get; }
        /// <summary> Gets the net ranges. </summary>
        public IReadOnlyList<ObservedString> NetRanges { get; }
        /// <summary> Gets the start ip. </summary>
        public string StartIp { get; }
        /// <summary> Gets the end ip. </summary>
        public string EndIp { get; }
        /// <summary> Gets the reputations. </summary>
        public IReadOnlyList<ReputationDetails> Reputations { get; }
        /// <summary> Gets the detailed from whois at. </summary>
        public DateTimeOffset? DetailedFromWhoisAt { get; }
        /// <summary> Gets the sources. </summary>
        public IReadOnlyList<SourceDetails> Sources { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the location. </summary>
        public IReadOnlyList<ObservedLocation> Location { get; }
        /// <summary> Gets the registrar expires at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarExpiresAt { get; }
        /// <summary> Gets the registrant names. </summary>
        public IReadOnlyList<ObservedString> RegistrantNames { get; }
        /// <summary> Gets the admin names. </summary>
        public IReadOnlyList<ObservedString> AdminNames { get; }
        /// <summary> Gets the technical names. </summary>
        public IReadOnlyList<ObservedString> TechnicalNames { get; }
        /// <summary> Gets the admin orgs. </summary>
        public IReadOnlyList<ObservedString> AdminOrgs { get; }
        /// <summary> Gets the technical orgs. </summary>
        public IReadOnlyList<ObservedString> TechnicalOrgs { get; }
        /// <summary> Gets the registrant phones. </summary>
        public IReadOnlyList<ObservedString> RegistrantPhones { get; }
        /// <summary> Gets the admin phones. </summary>
        public IReadOnlyList<ObservedString> AdminPhones { get; }
        /// <summary> Gets the technical phones. </summary>
        public IReadOnlyList<ObservedString> TechnicalPhones { get; }
        /// <summary> Gets the ipv 4. </summary>
        public bool? Ipv4 { get; }
        /// <summary> Gets the ipv 6. </summary>
        public bool? Ipv6 { get; }
    }
}
