// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    public partial class HostAsset : IUtf8JsonSerializable, IJsonModel<HostAsset>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HostAsset>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HostAsset>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HostAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HostAsset)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Host))
            {
                writer.WritePropertyName("host"u8);
                writer.WriteStringValue(Host);
            }
            if (Optional.IsDefined(Domain))
            {
                writer.WritePropertyName("domain"u8);
                writer.WriteStringValue(Domain);
            }
            if (Optional.IsCollectionDefined(IpAddresses))
            {
                writer.WritePropertyName("ipAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in IpAddresses)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(WebComponents))
            {
                writer.WritePropertyName("webComponents"u8);
                writer.WriteStartArray();
                foreach (var item in WebComponents)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Headers))
            {
                writer.WritePropertyName("headers"u8);
                writer.WriteStartArray();
                foreach (var item in Headers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Attributes))
            {
                writer.WritePropertyName("attributes"u8);
                writer.WriteStartArray();
                foreach (var item in Attributes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Cookies))
            {
                writer.WritePropertyName("cookies"u8);
                writer.WriteStartArray();
                foreach (var item in Cookies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SslCerts))
            {
                writer.WritePropertyName("sslCerts"u8);
                writer.WriteStartArray();
                foreach (var item in SslCerts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ParentHosts))
            {
                writer.WritePropertyName("parentHosts"u8);
                writer.WriteStartArray();
                foreach (var item in ParentHosts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ChildHosts))
            {
                writer.WritePropertyName("childHosts"u8);
                writer.WriteStartArray();
                foreach (var item in ChildHosts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HostCore))
            {
                writer.WritePropertyName("hostCore"u8);
                writer.WriteObjectValue(HostCore, options);
            }
            if (Optional.IsCollectionDefined(Services))
            {
                writer.WritePropertyName("services"u8);
                writer.WriteStartArray();
                foreach (var item in Services)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Cnames))
            {
                writer.WritePropertyName("cnames"u8);
                writer.WriteStartArray();
                foreach (var item in Cnames)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sources))
            {
                writer.WritePropertyName("sources"u8);
                writer.WriteStartArray();
                foreach (var item in Sources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FirstSeen))
            {
                writer.WritePropertyName("firstSeen"u8);
                writer.WriteStringValue(FirstSeen.Value, "O");
            }
            if (Optional.IsDefined(LastSeen))
            {
                writer.WritePropertyName("lastSeen"u8);
                writer.WriteStringValue(LastSeen.Value, "O");
            }
            if (Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (Optional.IsCollectionDefined(ResourceUrls))
            {
                writer.WritePropertyName("resourceUrls"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceUrls)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ScanMetadata))
            {
                writer.WritePropertyName("scanMetadata"u8);
                writer.WriteStartArray();
                foreach (var item in ScanMetadata)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Asns))
            {
                writer.WritePropertyName("asns"u8);
                writer.WriteStartArray();
                foreach (var item in Asns)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IpBlocks))
            {
                writer.WritePropertyName("ipBlocks"u8);
                writer.WriteStartArray();
                foreach (var item in IpBlocks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ResponseBodies))
            {
                writer.WritePropertyName("responseBodies"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseBodies)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DomainAsset))
            {
                writer.WritePropertyName("domainAsset"u8);
                writer.WriteObjectValue(DomainAsset, options);
            }
            if (Optional.IsCollectionDefined(NsRecord))
            {
                writer.WritePropertyName("nsRecord"u8);
                writer.WriteStartArray();
                foreach (var item in NsRecord)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(MxRecord))
            {
                writer.WritePropertyName("mxRecord"u8);
                writer.WriteStartArray();
                foreach (var item in MxRecord)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Webserver))
            {
                writer.WritePropertyName("webserver"u8);
                writer.WriteStartArray();
                foreach (var item in Webserver)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStartArray();
                foreach (var item in Location)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Nxdomain))
            {
                writer.WritePropertyName("nxdomain"u8);
                writer.WriteStartArray();
                foreach (var item in Nxdomain)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(SslServerConfig))
            {
                writer.WritePropertyName("sslServerConfig"u8);
                writer.WriteStartArray();
                foreach (var item in SslServerConfig)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(IsWildcard))
            {
                writer.WritePropertyName("isWildcard"u8);
                writer.WriteStartArray();
                foreach (var item in IsWildcard)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Banners))
            {
                writer.WritePropertyName("banners"u8);
                writer.WriteStartArray();
                foreach (var item in Banners)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ipv4))
            {
                writer.WritePropertyName("ipv4"u8);
                writer.WriteStartArray();
                foreach (var item in Ipv4)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ipv6))
            {
                writer.WritePropertyName("ipv6"u8);
                writer.WriteStartArray();
                foreach (var item in Ipv6)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
        }

        HostAsset IJsonModel<HostAsset>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HostAsset>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HostAsset)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHostAsset(document.RootElement, options);
        }

        internal static HostAsset DeserializeHostAsset(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string host = default;
            string domain = default;
            IReadOnlyList<ObservedString> ipAddresses = default;
            IReadOnlyList<WebComponent> webComponents = default;
            IReadOnlyList<ObservedHeader> headers = default;
            IReadOnlyList<AttributeDetails> attributes = default;
            IReadOnlyList<CookieDetails> cookies = default;
            IReadOnlyList<SslCertAsset> sslCerts = default;
            IReadOnlyList<ObservedString> parentHosts = default;
            IReadOnlyList<ObservedString> childHosts = default;
            HostCore hostCore = default;
            IReadOnlyList<AssetService> services = default;
            IReadOnlyList<ObservedString> cnames = default;
            IReadOnlyList<SourceDetails> sources = default;
            DateTimeOffset? firstSeen = default;
            DateTimeOffset? lastSeen = default;
            long? count = default;
            IReadOnlyList<ResourceUri> resourceUrls = default;
            IReadOnlyList<ScanMetadata> scanMetadata = default;
            IReadOnlyList<ObservedLong> asns = default;
            IReadOnlyList<IpBlock> ipBlocks = default;
            IReadOnlyList<ObservedString> responseBodies = default;
            DomainAsset domainAsset = default;
            IReadOnlyList<ObservedBoolean> nsRecord = default;
            IReadOnlyList<ObservedBoolean> mxRecord = default;
            IReadOnlyList<ObservedBoolean> webserver = default;
            IReadOnlyList<ObservedLocation> location = default;
            IReadOnlyList<ObservedBoolean> nxdomain = default;
            IReadOnlyList<SslServerConfig> sslServerConfig = default;
            IReadOnlyList<ObservedBoolean> isWildcard = default;
            IReadOnlyList<BannerDetails> banners = default;
            IReadOnlyList<ObservedBoolean> ipv4 = default;
            IReadOnlyList<ObservedBoolean> ipv6 = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("host"u8))
                {
                    host = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("domain"u8))
                {
                    domain = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    ipAddresses = array;
                    continue;
                }
                if (property.NameEquals("webComponents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<WebComponent> array = new List<WebComponent>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(WebComponent.DeserializeWebComponent(item, options));
                    }
                    webComponents = array;
                    continue;
                }
                if (property.NameEquals("headers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedHeader> array = new List<ObservedHeader>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedHeader.DeserializeObservedHeader(item, options));
                    }
                    headers = array;
                    continue;
                }
                if (property.NameEquals("attributes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AttributeDetails> array = new List<AttributeDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AttributeDetails.DeserializeAttributeDetails(item, options));
                    }
                    attributes = array;
                    continue;
                }
                if (property.NameEquals("cookies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CookieDetails> array = new List<CookieDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CookieDetails.DeserializeCookieDetails(item, options));
                    }
                    cookies = array;
                    continue;
                }
                if (property.NameEquals("sslCerts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SslCertAsset> array = new List<SslCertAsset>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SslCertAsset.DeserializeSslCertAsset(item, options));
                    }
                    sslCerts = array;
                    continue;
                }
                if (property.NameEquals("parentHosts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    parentHosts = array;
                    continue;
                }
                if (property.NameEquals("childHosts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    childHosts = array;
                    continue;
                }
                if (property.NameEquals("hostCore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hostCore = HostCore.DeserializeHostCore(property.Value, options);
                    continue;
                }
                if (property.NameEquals("services"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<AssetService> array = new List<AssetService>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(AssetService.DeserializeAssetService(item, options));
                    }
                    services = array;
                    continue;
                }
                if (property.NameEquals("cnames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    cnames = array;
                    continue;
                }
                if (property.NameEquals("sources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SourceDetails> array = new List<SourceDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SourceDetails.DeserializeSourceDetails(item, options));
                    }
                    sources = array;
                    continue;
                }
                if (property.NameEquals("firstSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("count"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    count = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("resourceUrls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceUri> array = new List<ResourceUri>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceUri.DeserializeResourceUri(item, options));
                    }
                    resourceUrls = array;
                    continue;
                }
                if (property.NameEquals("scanMetadata"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ScanMetadata> array = new List<ScanMetadata>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Easm.ScanMetadata.DeserializeScanMetadata(item, options));
                    }
                    scanMetadata = array;
                    continue;
                }
                if (property.NameEquals("asns"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLong> array = new List<ObservedLong>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLong.DeserializeObservedLong(item, options));
                    }
                    asns = array;
                    continue;
                }
                if (property.NameEquals("ipBlocks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IpBlock> array = new List<IpBlock>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(IpBlock.DeserializeIpBlock(item, options));
                    }
                    ipBlocks = array;
                    continue;
                }
                if (property.NameEquals("responseBodies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedString> array = new List<ObservedString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedString.DeserializeObservedString(item, options));
                    }
                    responseBodies = array;
                    continue;
                }
                if (property.NameEquals("domainAsset"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    domainAsset = DomainAsset.DeserializeDomainAsset(property.Value, options);
                    continue;
                }
                if (property.NameEquals("nsRecord"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    nsRecord = array;
                    continue;
                }
                if (property.NameEquals("mxRecord"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    mxRecord = array;
                    continue;
                }
                if (property.NameEquals("webserver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    webserver = array;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedLocation> array = new List<ObservedLocation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedLocation.DeserializeObservedLocation(item, options));
                    }
                    location = array;
                    continue;
                }
                if (property.NameEquals("nxdomain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    nxdomain = array;
                    continue;
                }
                if (property.NameEquals("sslServerConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SslServerConfig> array = new List<SslServerConfig>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Easm.SslServerConfig.DeserializeSslServerConfig(item, options));
                    }
                    sslServerConfig = array;
                    continue;
                }
                if (property.NameEquals("isWildcard"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    isWildcard = array;
                    continue;
                }
                if (property.NameEquals("banners"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BannerDetails> array = new List<BannerDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BannerDetails.DeserializeBannerDetails(item, options));
                    }
                    banners = array;
                    continue;
                }
                if (property.NameEquals("ipv4"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    ipv4 = array;
                    continue;
                }
                if (property.NameEquals("ipv6"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ObservedBoolean> array = new List<ObservedBoolean>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ObservedBoolean.DeserializeObservedBoolean(item, options));
                    }
                    ipv6 = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HostAsset(
                serializedAdditionalRawData,
                host,
                domain,
                ipAddresses ?? new ChangeTrackingList<ObservedString>(),
                webComponents ?? new ChangeTrackingList<WebComponent>(),
                headers ?? new ChangeTrackingList<ObservedHeader>(),
                attributes ?? new ChangeTrackingList<AttributeDetails>(),
                cookies ?? new ChangeTrackingList<CookieDetails>(),
                sslCerts ?? new ChangeTrackingList<SslCertAsset>(),
                parentHosts ?? new ChangeTrackingList<ObservedString>(),
                childHosts ?? new ChangeTrackingList<ObservedString>(),
                hostCore,
                services ?? new ChangeTrackingList<AssetService>(),
                cnames ?? new ChangeTrackingList<ObservedString>(),
                sources ?? new ChangeTrackingList<SourceDetails>(),
                firstSeen,
                lastSeen,
                count,
                resourceUrls ?? new ChangeTrackingList<ResourceUri>(),
                scanMetadata ?? new ChangeTrackingList<ScanMetadata>(),
                asns ?? new ChangeTrackingList<ObservedLong>(),
                ipBlocks ?? new ChangeTrackingList<IpBlock>(),
                responseBodies ?? new ChangeTrackingList<ObservedString>(),
                domainAsset,
                nsRecord ?? new ChangeTrackingList<ObservedBoolean>(),
                mxRecord ?? new ChangeTrackingList<ObservedBoolean>(),
                webserver ?? new ChangeTrackingList<ObservedBoolean>(),
                location ?? new ChangeTrackingList<ObservedLocation>(),
                nxdomain ?? new ChangeTrackingList<ObservedBoolean>(),
                sslServerConfig ?? new ChangeTrackingList<SslServerConfig>(),
                isWildcard ?? new ChangeTrackingList<ObservedBoolean>(),
                banners ?? new ChangeTrackingList<BannerDetails>(),
                ipv4 ?? new ChangeTrackingList<ObservedBoolean>(),
                ipv6 ?? new ChangeTrackingList<ObservedBoolean>());
        }

        BinaryData IPersistableModel<HostAsset>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HostAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HostAsset)} does not support writing '{options.Format}' format.");
            }
        }

        HostAsset IPersistableModel<HostAsset>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HostAsset>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHostAsset(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HostAsset)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HostAsset>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new HostAsset FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHostAsset(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
