// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The GuidPair. </summary>
    public partial class GuidPair
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GuidPair"/>. </summary>
        internal GuidPair()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GuidPair"/>. </summary>
        /// <param name="pageGuid"></param>
        /// <param name="crawlStateGuid"></param>
        /// <param name="loadDate"></param>
        /// <param name="recent"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GuidPair(string pageGuid, string crawlStateGuid, DateTimeOffset? loadDate, bool? recent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PageGuid = pageGuid;
            CrawlStateGuid = crawlStateGuid;
            LoadDate = loadDate;
            Recent = recent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the page guid. </summary>
        public string PageGuid { get; }
        /// <summary> Gets the crawl state guid. </summary>
        public string CrawlStateGuid { get; }
        /// <summary> Gets the load date. </summary>
        public DateTimeOffset? LoadDate { get; }
        /// <summary> Gets the recent. </summary>
        public bool? Recent { get; }
    }
}
