// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> Client options for EasmClient. </summary>
    public partial class EasmClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2023_03_01_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2023-03-01-preview". </summary>
            V2023_03_01_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of EasmClientOptions. </summary>
        public EasmClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2023_03_01_Preview => "2023-03-01-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
