// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The DomainAsset. </summary>
    public partial class DomainAsset
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DomainAsset"/>. </summary>
        internal DomainAsset()
        {
            RegistrarIanaIds = new ChangeTrackingList<ObservedInteger>();
            RegistrantContacts = new ChangeTrackingList<ObservedString>();
            RegistrantOrgs = new ChangeTrackingList<ObservedString>();
            AdminContacts = new ChangeTrackingList<ObservedString>();
            TechnicalContacts = new ChangeTrackingList<ObservedString>();
            AlexaInfos = new ChangeTrackingList<AlexaInfo>();
            NameServers = new ChangeTrackingList<ObservedString>();
            MailServers = new ChangeTrackingList<ObservedString>();
            WhoisServers = new ChangeTrackingList<ObservedString>();
            DomainStatuses = new ChangeTrackingList<ObservedString>();
            RegistrarCreatedAt = new ChangeTrackingList<ObservedLong>();
            RegistrarUpdatedAt = new ChangeTrackingList<ObservedLong>();
            RegistrarExpiresAt = new ChangeTrackingList<ObservedLong>();
            SoaRecords = new ChangeTrackingList<SoaRecord>();
            RegistrarNames = new ChangeTrackingList<ObservedString>();
            Sources = new ChangeTrackingList<SourceDetails>();
            ParkedDomain = new ChangeTrackingList<ObservedBoolean>();
            RegistrantNames = new ChangeTrackingList<ObservedString>();
            AdminNames = new ChangeTrackingList<ObservedString>();
            TechnicalNames = new ChangeTrackingList<ObservedString>();
            AdminOrgs = new ChangeTrackingList<ObservedString>();
            TechnicalOrgs = new ChangeTrackingList<ObservedString>();
            RegistrantPhones = new ChangeTrackingList<ObservedString>();
            AdminPhones = new ChangeTrackingList<ObservedString>();
            TechnicalPhones = new ChangeTrackingList<ObservedString>();
        }

        /// <summary> Initializes a new instance of <see cref="DomainAsset"/>. </summary>
        /// <param name="domain"></param>
        /// <param name="whoisId"></param>
        /// <param name="registrarIanaIds"></param>
        /// <param name="registrantContacts"></param>
        /// <param name="registrantOrgs"></param>
        /// <param name="adminContacts"></param>
        /// <param name="technicalContacts"></param>
        /// <param name="alexaInfos"></param>
        /// <param name="nameServers"></param>
        /// <param name="mailServers"></param>
        /// <param name="whoisServers"></param>
        /// <param name="domainStatuses"></param>
        /// <param name="registrarCreatedAt"></param>
        /// <param name="registrarUpdatedAt"></param>
        /// <param name="registrarExpiresAt"></param>
        /// <param name="soaRecords"></param>
        /// <param name="detailedFromWhoisAt"></param>
        /// <param name="registrarNames"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="parkedDomain"></param>
        /// <param name="registrantNames"></param>
        /// <param name="adminNames"></param>
        /// <param name="technicalNames"></param>
        /// <param name="adminOrgs"></param>
        /// <param name="technicalOrgs"></param>
        /// <param name="registrantPhones"></param>
        /// <param name="adminPhones"></param>
        /// <param name="technicalPhones"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DomainAsset(string domain, long? whoisId, IReadOnlyList<ObservedInteger> registrarIanaIds, IReadOnlyList<ObservedString> registrantContacts, IReadOnlyList<ObservedString> registrantOrgs, IReadOnlyList<ObservedString> adminContacts, IReadOnlyList<ObservedString> technicalContacts, IReadOnlyList<AlexaInfo> alexaInfos, IReadOnlyList<ObservedString> nameServers, IReadOnlyList<ObservedString> mailServers, IReadOnlyList<ObservedString> whoisServers, IReadOnlyList<ObservedString> domainStatuses, IReadOnlyList<ObservedLong> registrarCreatedAt, IReadOnlyList<ObservedLong> registrarUpdatedAt, IReadOnlyList<ObservedLong> registrarExpiresAt, IReadOnlyList<SoaRecord> soaRecords, DateTimeOffset? detailedFromWhoisAt, IReadOnlyList<ObservedString> registrarNames, IReadOnlyList<SourceDetails> sources, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, IReadOnlyList<ObservedBoolean> parkedDomain, IReadOnlyList<ObservedString> registrantNames, IReadOnlyList<ObservedString> adminNames, IReadOnlyList<ObservedString> technicalNames, IReadOnlyList<ObservedString> adminOrgs, IReadOnlyList<ObservedString> technicalOrgs, IReadOnlyList<ObservedString> registrantPhones, IReadOnlyList<ObservedString> adminPhones, IReadOnlyList<ObservedString> technicalPhones, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Domain = domain;
            WhoisId = whoisId;
            RegistrarIanaIds = registrarIanaIds;
            RegistrantContacts = registrantContacts;
            RegistrantOrgs = registrantOrgs;
            AdminContacts = adminContacts;
            TechnicalContacts = technicalContacts;
            AlexaInfos = alexaInfos;
            NameServers = nameServers;
            MailServers = mailServers;
            WhoisServers = whoisServers;
            DomainStatuses = domainStatuses;
            RegistrarCreatedAt = registrarCreatedAt;
            RegistrarUpdatedAt = registrarUpdatedAt;
            RegistrarExpiresAt = registrarExpiresAt;
            SoaRecords = soaRecords;
            DetailedFromWhoisAt = detailedFromWhoisAt;
            RegistrarNames = registrarNames;
            Sources = sources;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            ParkedDomain = parkedDomain;
            RegistrantNames = registrantNames;
            AdminNames = adminNames;
            TechnicalNames = technicalNames;
            AdminOrgs = adminOrgs;
            TechnicalOrgs = technicalOrgs;
            RegistrantPhones = registrantPhones;
            AdminPhones = adminPhones;
            TechnicalPhones = technicalPhones;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the domain. </summary>
        public string Domain { get; }
        /// <summary> Gets the whois id. </summary>
        public long? WhoisId { get; }
        /// <summary> Gets the registrar iana ids. </summary>
        public IReadOnlyList<ObservedInteger> RegistrarIanaIds { get; }
        /// <summary> Gets the registrant contacts. </summary>
        public IReadOnlyList<ObservedString> RegistrantContacts { get; }
        /// <summary> Gets the registrant orgs. </summary>
        public IReadOnlyList<ObservedString> RegistrantOrgs { get; }
        /// <summary> Gets the admin contacts. </summary>
        public IReadOnlyList<ObservedString> AdminContacts { get; }
        /// <summary> Gets the technical contacts. </summary>
        public IReadOnlyList<ObservedString> TechnicalContacts { get; }
        /// <summary> Gets the alexa infos. </summary>
        public IReadOnlyList<AlexaInfo> AlexaInfos { get; }
        /// <summary> Gets the name servers. </summary>
        public IReadOnlyList<ObservedString> NameServers { get; }
        /// <summary> Gets the mail servers. </summary>
        public IReadOnlyList<ObservedString> MailServers { get; }
        /// <summary> Gets the whois servers. </summary>
        public IReadOnlyList<ObservedString> WhoisServers { get; }
        /// <summary> Gets the domain statuses. </summary>
        public IReadOnlyList<ObservedString> DomainStatuses { get; }
        /// <summary> Gets the registrar created at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarCreatedAt { get; }
        /// <summary> Gets the registrar updated at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarUpdatedAt { get; }
        /// <summary> Gets the registrar expires at. </summary>
        public IReadOnlyList<ObservedLong> RegistrarExpiresAt { get; }
        /// <summary> Gets the soa records. </summary>
        public IReadOnlyList<SoaRecord> SoaRecords { get; }
        /// <summary> Gets the detailed from whois at. </summary>
        public DateTimeOffset? DetailedFromWhoisAt { get; }
        /// <summary> Gets the registrar names. </summary>
        public IReadOnlyList<ObservedString> RegistrarNames { get; }
        /// <summary> Gets the sources. </summary>
        public IReadOnlyList<SourceDetails> Sources { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the parked domain. </summary>
        public IReadOnlyList<ObservedBoolean> ParkedDomain { get; }
        /// <summary> Gets the registrant names. </summary>
        public IReadOnlyList<ObservedString> RegistrantNames { get; }
        /// <summary> Gets the admin names. </summary>
        public IReadOnlyList<ObservedString> AdminNames { get; }
        /// <summary> Gets the technical names. </summary>
        public IReadOnlyList<ObservedString> TechnicalNames { get; }
        /// <summary> Gets the admin orgs. </summary>
        public IReadOnlyList<ObservedString> AdminOrgs { get; }
        /// <summary> Gets the technical orgs. </summary>
        public IReadOnlyList<ObservedString> TechnicalOrgs { get; }
        /// <summary> Gets the registrant phones. </summary>
        public IReadOnlyList<ObservedString> RegistrantPhones { get; }
        /// <summary> Gets the admin phones. </summary>
        public IReadOnlyList<ObservedString> AdminPhones { get; }
        /// <summary> Gets the technical phones. </summary>
        public IReadOnlyList<ObservedString> TechnicalPhones { get; }
    }
}
