// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The kind of disco source. </summary>
    public readonly partial struct DiscoverySourceKind : IEquatable<DiscoverySourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiscoverySourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiscoverySourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AsValue = "as";
        private const string AttributeValue = "attribute";
        private const string ContactValue = "contact";
        private const string DomainValue = "domain";
        private const string HostValue = "host";
        private const string IpBlockValue = "ipBlock";

        /// <summary> as. </summary>
        public static DiscoverySourceKind As { get; } = new DiscoverySourceKind(AsValue);
        /// <summary> attribute. </summary>
        public static DiscoverySourceKind Attribute { get; } = new DiscoverySourceKind(AttributeValue);
        /// <summary> contact. </summary>
        public static DiscoverySourceKind Contact { get; } = new DiscoverySourceKind(ContactValue);
        /// <summary> domain. </summary>
        public static DiscoverySourceKind Domain { get; } = new DiscoverySourceKind(DomainValue);
        /// <summary> host. </summary>
        public static DiscoverySourceKind Host { get; } = new DiscoverySourceKind(HostValue);
        /// <summary> ipBlock. </summary>
        public static DiscoverySourceKind IpBlock { get; } = new DiscoverySourceKind(IpBlockValue);
        /// <summary> Determines if two <see cref="DiscoverySourceKind"/> values are the same. </summary>
        public static bool operator ==(DiscoverySourceKind left, DiscoverySourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiscoverySourceKind"/> values are not the same. </summary>
        public static bool operator !=(DiscoverySourceKind left, DiscoverySourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiscoverySourceKind"/>. </summary>
        public static implicit operator DiscoverySourceKind(string value) => new DiscoverySourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiscoverySourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiscoverySourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
