// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The DiscoveryGroup. </summary>
    public partial class DiscoveryGroup
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiscoveryGroup"/>. </summary>
        internal DiscoveryGroup()
        {
            Seeds = new ChangeTrackingList<DiscoverySource>();
            Names = new ChangeTrackingList<string>();
            Excludes = new ChangeTrackingList<DiscoverySource>();
        }

        /// <summary> Initializes a new instance of <see cref="DiscoveryGroup"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="description"> The description for a disco group. </param>
        /// <param name="tier"> The tier for the disco group which will affect the algorithm used for the disco runs in this group. </param>
        /// <param name="frequencyMilliseconds"> The frequency at which the disco group is supposed to be rerun in milliseconds. </param>
        /// <param name="seeds"> The list of seeds used for the disco group runs. </param>
        /// <param name="names"> The list of names used for the disco group runs. </param>
        /// <param name="excludes"> The list of excludes used for the disco group runs, aka assets to exclude from the discovery algorithm. </param>
        /// <param name="latestRun"> The latest run of this disco group with some limited information, null if the group has never been run. </param>
        /// <param name="createdDate"> The date for the disco group was created. </param>
        /// <param name="templateId"> The unique identifier for the disco template used for the disco group creation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiscoveryGroup(string id, string name, string displayName, string description, string tier, long? frequencyMilliseconds, IReadOnlyList<DiscoverySource> seeds, IReadOnlyList<string> names, IReadOnlyList<DiscoverySource> excludes, DiscoveryRunResult latestRun, DateTimeOffset? createdDate, string templateId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            DisplayName = displayName;
            Description = description;
            Tier = tier;
            FrequencyMilliseconds = frequencyMilliseconds;
            Seeds = seeds;
            Names = names;
            Excludes = excludes;
            LatestRun = latestRun;
            CreatedDate = createdDate;
            TemplateId = templateId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The system generated unique id for the resource. </summary>
        public string Id { get; }
        /// <summary> The caller provided unique name for the resource. </summary>
        public string Name { get; }
        /// <summary> The name that can be used for display purposes. </summary>
        public string DisplayName { get; }
        /// <summary> The description for a disco group. </summary>
        public string Description { get; }
        /// <summary> The tier for the disco group which will affect the algorithm used for the disco runs in this group. </summary>
        public string Tier { get; }
        /// <summary> The frequency at which the disco group is supposed to be rerun in milliseconds. </summary>
        public long? FrequencyMilliseconds { get; }
        /// <summary> The list of seeds used for the disco group runs. </summary>
        public IReadOnlyList<DiscoverySource> Seeds { get; }
        /// <summary> The list of names used for the disco group runs. </summary>
        public IReadOnlyList<string> Names { get; }
        /// <summary> The list of excludes used for the disco group runs, aka assets to exclude from the discovery algorithm. </summary>
        public IReadOnlyList<DiscoverySource> Excludes { get; }
        /// <summary> The latest run of this disco group with some limited information, null if the group has never been run. </summary>
        public DiscoveryRunResult LatestRun { get; }
        /// <summary> The date for the disco group was created. </summary>
        public DateTimeOffset? CreatedDate { get; }
        /// <summary> The unique identifier for the disco template used for the disco group creation. </summary>
        public string TemplateId { get; }
    }
}
