// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The DependentResource. </summary>
    public partial class DependentResource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DependentResource"/>. </summary>
        internal DependentResource()
        {
            ResponseBodyMinhash = new ChangeTrackingList<int>();
            SriChecks = new ChangeTrackingList<SubResourceIntegrityCheck>();
        }

        /// <summary> Initializes a new instance of <see cref="DependentResource"/>. </summary>
        /// <param name="md5"></param>
        /// <param name="responseBodySize"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="firstSeenCrawlGuid"></param>
        /// <param name="firstSeenPageGuid"></param>
        /// <param name="firstSeenResourceGuid"></param>
        /// <param name="lastSeenCrawlGuid"></param>
        /// <param name="lastSeenPageGuid"></param>
        /// <param name="lastSeenResourceGuid"></param>
        /// <param name="responseBodyMinhash"></param>
        /// <param name="contentType"></param>
        /// <param name="sha256"></param>
        /// <param name="sha384"></param>
        /// <param name="sha512"></param>
        /// <param name="url"></param>
        /// <param name="cached"></param>
        /// <param name="sriChecks"></param>
        /// <param name="host"></param>
        /// <param name="lastObservedViolation"></param>
        /// <param name="lastObservedValidation"></param>
        /// <param name="lastObservedActualSriHash"></param>
        /// <param name="lastObservedExpectedSriHash"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DependentResource(string md5, long? responseBodySize, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, string firstSeenCrawlGuid, string firstSeenPageGuid, string firstSeenResourceGuid, string lastSeenCrawlGuid, string lastSeenPageGuid, string lastSeenResourceGuid, IReadOnlyList<int> responseBodyMinhash, string contentType, string sha256, string sha384, string sha512, Uri url, bool? cached, IReadOnlyList<SubResourceIntegrityCheck> sriChecks, string host, DateTimeOffset? lastObservedViolation, DateTimeOffset? lastObservedValidation, string lastObservedActualSriHash, string lastObservedExpectedSriHash, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Md5 = md5;
            ResponseBodySize = responseBodySize;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            FirstSeenCrawlGuid = firstSeenCrawlGuid;
            FirstSeenPageGuid = firstSeenPageGuid;
            FirstSeenResourceGuid = firstSeenResourceGuid;
            LastSeenCrawlGuid = lastSeenCrawlGuid;
            LastSeenPageGuid = lastSeenPageGuid;
            LastSeenResourceGuid = lastSeenResourceGuid;
            ResponseBodyMinhash = responseBodyMinhash;
            ContentType = contentType;
            Sha256 = sha256;
            Sha384 = sha384;
            Sha512 = sha512;
            Url = url;
            Cached = cached;
            SriChecks = sriChecks;
            Host = host;
            LastObservedViolation = lastObservedViolation;
            LastObservedValidation = lastObservedValidation;
            LastObservedActualSriHash = lastObservedActualSriHash;
            LastObservedExpectedSriHash = lastObservedExpectedSriHash;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the md 5. </summary>
        public string Md5 { get; }
        /// <summary> Gets the response body size. </summary>
        public long? ResponseBodySize { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the first seen crawl guid. </summary>
        public string FirstSeenCrawlGuid { get; }
        /// <summary> Gets the first seen page guid. </summary>
        public string FirstSeenPageGuid { get; }
        /// <summary> Gets the first seen resource guid. </summary>
        public string FirstSeenResourceGuid { get; }
        /// <summary> Gets the last seen crawl guid. </summary>
        public string LastSeenCrawlGuid { get; }
        /// <summary> Gets the last seen page guid. </summary>
        public string LastSeenPageGuid { get; }
        /// <summary> Gets the last seen resource guid. </summary>
        public string LastSeenResourceGuid { get; }
        /// <summary> Gets the response body minhash. </summary>
        public IReadOnlyList<int> ResponseBodyMinhash { get; }
        /// <summary> Gets the content type. </summary>
        public string ContentType { get; }
        /// <summary> Gets the sha 256. </summary>
        public string Sha256 { get; }
        /// <summary> Gets the sha 384. </summary>
        public string Sha384 { get; }
        /// <summary> Gets the sha 512. </summary>
        public string Sha512 { get; }
        /// <summary> Gets the url. </summary>
        public Uri Url { get; }
        /// <summary> Gets the cached. </summary>
        public bool? Cached { get; }
        /// <summary> Gets the sri checks. </summary>
        public IReadOnlyList<SubResourceIntegrityCheck> SriChecks { get; }
        /// <summary> Gets the host. </summary>
        public string Host { get; }
        /// <summary> Gets the last observed violation. </summary>
        public DateTimeOffset? LastObservedViolation { get; }
        /// <summary> Gets the last observed validation. </summary>
        public DateTimeOffset? LastObservedValidation { get; }
        /// <summary> Gets the last observed actual sri hash. </summary>
        public string LastObservedActualSriHash { get; }
        /// <summary> Gets the last observed expected sri hash. </summary>
        public string LastObservedExpectedSriHash { get; }
    }
}
