// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    public partial class DependentResource : IUtf8JsonSerializable, IJsonModel<DependentResource>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DependentResource>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DependentResource>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DependentResource>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DependentResource)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Md5))
            {
                writer.WritePropertyName("md5"u8);
                writer.WriteStringValue(Md5);
            }
            if (Optional.IsDefined(ResponseBodySize))
            {
                writer.WritePropertyName("responseBodySize"u8);
                writer.WriteNumberValue(ResponseBodySize.Value);
            }
            if (Optional.IsDefined(FirstSeen))
            {
                writer.WritePropertyName("firstSeen"u8);
                writer.WriteStringValue(FirstSeen.Value, "O");
            }
            if (Optional.IsDefined(LastSeen))
            {
                writer.WritePropertyName("lastSeen"u8);
                writer.WriteStringValue(LastSeen.Value, "O");
            }
            if (Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (Optional.IsDefined(FirstSeenCrawlGuid))
            {
                writer.WritePropertyName("firstSeenCrawlGuid"u8);
                writer.WriteStringValue(FirstSeenCrawlGuid);
            }
            if (Optional.IsDefined(FirstSeenPageGuid))
            {
                writer.WritePropertyName("firstSeenPageGuid"u8);
                writer.WriteStringValue(FirstSeenPageGuid);
            }
            if (Optional.IsDefined(FirstSeenResourceGuid))
            {
                writer.WritePropertyName("firstSeenResourceGuid"u8);
                writer.WriteStringValue(FirstSeenResourceGuid);
            }
            if (Optional.IsDefined(LastSeenCrawlGuid))
            {
                writer.WritePropertyName("lastSeenCrawlGuid"u8);
                writer.WriteStringValue(LastSeenCrawlGuid);
            }
            if (Optional.IsDefined(LastSeenPageGuid))
            {
                writer.WritePropertyName("lastSeenPageGuid"u8);
                writer.WriteStringValue(LastSeenPageGuid);
            }
            if (Optional.IsDefined(LastSeenResourceGuid))
            {
                writer.WritePropertyName("lastSeenResourceGuid"u8);
                writer.WriteStringValue(LastSeenResourceGuid);
            }
            if (Optional.IsCollectionDefined(ResponseBodyMinhash))
            {
                writer.WritePropertyName("responseBodyMinhash"u8);
                writer.WriteStartArray();
                foreach (var item in ResponseBodyMinhash)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ContentType))
            {
                writer.WritePropertyName("contentType"u8);
                writer.WriteStringValue(ContentType);
            }
            if (Optional.IsDefined(Sha256))
            {
                writer.WritePropertyName("sha256"u8);
                writer.WriteStringValue(Sha256);
            }
            if (Optional.IsDefined(Sha384))
            {
                writer.WritePropertyName("sha384"u8);
                writer.WriteStringValue(Sha384);
            }
            if (Optional.IsDefined(Sha512))
            {
                writer.WritePropertyName("sha512"u8);
                writer.WriteStringValue(Sha512);
            }
            if (Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url.AbsoluteUri);
            }
            if (Optional.IsDefined(Cached))
            {
                writer.WritePropertyName("cached"u8);
                writer.WriteBooleanValue(Cached.Value);
            }
            if (Optional.IsCollectionDefined(SriChecks))
            {
                writer.WritePropertyName("sriChecks"u8);
                writer.WriteStartArray();
                foreach (var item in SriChecks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Host))
            {
                writer.WritePropertyName("host"u8);
                writer.WriteStringValue(Host);
            }
            if (Optional.IsDefined(LastObservedViolation))
            {
                writer.WritePropertyName("lastObservedViolation"u8);
                writer.WriteStringValue(LastObservedViolation.Value, "O");
            }
            if (Optional.IsDefined(LastObservedValidation))
            {
                writer.WritePropertyName("lastObservedValidation"u8);
                writer.WriteStringValue(LastObservedValidation.Value, "O");
            }
            if (Optional.IsDefined(LastObservedActualSriHash))
            {
                writer.WritePropertyName("lastObservedActualSriHash"u8);
                writer.WriteStringValue(LastObservedActualSriHash);
            }
            if (Optional.IsDefined(LastObservedExpectedSriHash))
            {
                writer.WritePropertyName("lastObservedExpectedSriHash"u8);
                writer.WriteStringValue(LastObservedExpectedSriHash);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DependentResource IJsonModel<DependentResource>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DependentResource>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DependentResource)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDependentResource(document.RootElement, options);
        }

        internal static DependentResource DeserializeDependentResource(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string md5 = default;
            long? responseBodySize = default;
            DateTimeOffset? firstSeen = default;
            DateTimeOffset? lastSeen = default;
            long? count = default;
            string firstSeenCrawlGuid = default;
            string firstSeenPageGuid = default;
            string firstSeenResourceGuid = default;
            string lastSeenCrawlGuid = default;
            string lastSeenPageGuid = default;
            string lastSeenResourceGuid = default;
            IReadOnlyList<int> responseBodyMinhash = default;
            string contentType = default;
            string sha256 = default;
            string sha384 = default;
            string sha512 = default;
            Uri url = default;
            bool? cached = default;
            IReadOnlyList<SubResourceIntegrityCheck> sriChecks = default;
            string host = default;
            DateTimeOffset? lastObservedViolation = default;
            DateTimeOffset? lastObservedValidation = default;
            string lastObservedActualSriHash = default;
            string lastObservedExpectedSriHash = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("md5"u8))
                {
                    md5 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responseBodySize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responseBodySize = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("firstSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firstSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastSeen"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSeen = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("count"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    count = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("firstSeenCrawlGuid"u8))
                {
                    firstSeenCrawlGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstSeenPageGuid"u8))
                {
                    firstSeenPageGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstSeenResourceGuid"u8))
                {
                    firstSeenResourceGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastSeenCrawlGuid"u8))
                {
                    lastSeenCrawlGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastSeenPageGuid"u8))
                {
                    lastSeenPageGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastSeenResourceGuid"u8))
                {
                    lastSeenResourceGuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("responseBodyMinhash"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    responseBodyMinhash = array;
                    continue;
                }
                if (property.NameEquals("contentType"u8))
                {
                    contentType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sha256"u8))
                {
                    sha256 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sha384"u8))
                {
                    sha384 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sha512"u8))
                {
                    sha512 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    url = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cached"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cached = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sriChecks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SubResourceIntegrityCheck> array = new List<SubResourceIntegrityCheck>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SubResourceIntegrityCheck.DeserializeSubResourceIntegrityCheck(item, options));
                    }
                    sriChecks = array;
                    continue;
                }
                if (property.NameEquals("host"u8))
                {
                    host = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastObservedViolation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastObservedViolation = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastObservedValidation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastObservedValidation = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastObservedActualSriHash"u8))
                {
                    lastObservedActualSriHash = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastObservedExpectedSriHash"u8))
                {
                    lastObservedExpectedSriHash = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DependentResource(
                md5,
                responseBodySize,
                firstSeen,
                lastSeen,
                count,
                firstSeenCrawlGuid,
                firstSeenPageGuid,
                firstSeenResourceGuid,
                lastSeenCrawlGuid,
                lastSeenPageGuid,
                lastSeenResourceGuid,
                responseBodyMinhash ?? new ChangeTrackingList<int>(),
                contentType,
                sha256,
                sha384,
                sha512,
                url,
                cached,
                sriChecks ?? new ChangeTrackingList<SubResourceIntegrityCheck>(),
                host,
                lastObservedViolation,
                lastObservedValidation,
                lastObservedActualSriHash,
                lastObservedExpectedSriHash,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DependentResource>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DependentResource>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DependentResource)} does not support writing '{options.Format}' format.");
            }
        }

        DependentResource IPersistableModel<DependentResource>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DependentResource>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDependentResource(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DependentResource)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DependentResource>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DependentResource FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDependentResource(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
