// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary>
    /// The DataConnection.
    /// Please note <see cref="DataConnection"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureDataExplorerDataConnection"/> and <see cref="LogAnalyticsDataConnection"/>.
    /// </summary>
    public abstract partial class DataConnection
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataConnection"/>. </summary>
        protected DataConnection()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataConnection"/>. </summary>
        /// <param name="kind"> Discriminator property for DataConnection. </param>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="createdDate"> The date the data connection was created. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. </param>
        /// <param name="updatedDate"> The date the data connection was last updated. </param>
        /// <param name="userUpdatedAt"> The date the data connection was last updated by user. </param>
        /// <param name="active"> An indicator of whether the data connection is active. </param>
        /// <param name="inactiveMessage"> A message that specifies details about data connection if inactive. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataConnection(string kind, string id, string name, string displayName, DataConnectionContent? content, DateTimeOffset? createdDate, DataConnectionFrequency? frequency, int? frequencyOffset, DateTimeOffset? updatedDate, DateTimeOffset? userUpdatedAt, bool? active, string inactiveMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Id = id;
            Name = name;
            DisplayName = displayName;
            Content = content;
            CreatedDate = createdDate;
            Frequency = frequency;
            FrequencyOffset = frequencyOffset;
            UpdatedDate = updatedDate;
            UserUpdatedAt = userUpdatedAt;
            Active = active;
            InactiveMessage = inactiveMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Discriminator property for DataConnection. </summary>
        internal string Kind { get; set; }
        /// <summary> The system generated unique id for the resource. </summary>
        public string Id { get; }
        /// <summary> The caller provided unique name for the resource. </summary>
        public string Name { get; }
        /// <summary> The name that can be used for display purposes. </summary>
        public string DisplayName { get; }
        /// <summary> The type of data the data connection will transfer. </summary>
        public DataConnectionContent? Content { get; }
        /// <summary> The date the data connection was created. </summary>
        public DateTimeOffset? CreatedDate { get; }
        /// <summary> The rate at which the data connection will receive updates. </summary>
        public DataConnectionFrequency? Frequency { get; }
        /// <summary> The day to update the data connection on. </summary>
        public int? FrequencyOffset { get; }
        /// <summary> The date the data connection was last updated. </summary>
        public DateTimeOffset? UpdatedDate { get; }
        /// <summary> The date the data connection was last updated by user. </summary>
        public DateTimeOffset? UserUpdatedAt { get; }
        /// <summary> An indicator of whether the data connection is active. </summary>
        public bool? Active { get; }
        /// <summary> A message that specifies details about data connection if inactive. </summary>
        public string InactiveMessage { get; }
    }
}
