// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The Cvss3Summary. </summary>
    public partial class Cvss3Summary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="Cvss3Summary"/>. </summary>
        internal Cvss3Summary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="Cvss3Summary"/>. </summary>
        /// <param name="version"></param>
        /// <param name="vectorString"></param>
        /// <param name="attackVector"></param>
        /// <param name="attackComplexity"></param>
        /// <param name="privilegesRequired"></param>
        /// <param name="userInteraction"></param>
        /// <param name="scope"></param>
        /// <param name="confidentialityImpact"></param>
        /// <param name="integrityImpact"></param>
        /// <param name="availabilityImpact"></param>
        /// <param name="baseScore"></param>
        /// <param name="baseSeverity"></param>
        /// <param name="exploitCodeMaturity"></param>
        /// <param name="remediationLevel"></param>
        /// <param name="reportConfidence"></param>
        /// <param name="exploitabilityScore"></param>
        /// <param name="impactScore"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal Cvss3Summary(string version, string vectorString, string attackVector, string attackComplexity, string privilegesRequired, string userInteraction, string scope, string confidentialityImpact, string integrityImpact, string availabilityImpact, float? baseScore, string baseSeverity, string exploitCodeMaturity, string remediationLevel, string reportConfidence, float? exploitabilityScore, float? impactScore, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            VectorString = vectorString;
            AttackVector = attackVector;
            AttackComplexity = attackComplexity;
            PrivilegesRequired = privilegesRequired;
            UserInteraction = userInteraction;
            Scope = scope;
            ConfidentialityImpact = confidentialityImpact;
            IntegrityImpact = integrityImpact;
            AvailabilityImpact = availabilityImpact;
            BaseScore = baseScore;
            BaseSeverity = baseSeverity;
            ExploitCodeMaturity = exploitCodeMaturity;
            RemediationLevel = remediationLevel;
            ReportConfidence = reportConfidence;
            ExploitabilityScore = exploitabilityScore;
            ImpactScore = impactScore;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the version. </summary>
        public string Version { get; }
        /// <summary> Gets the vector string. </summary>
        public string VectorString { get; }
        /// <summary> Gets the attack vector. </summary>
        public string AttackVector { get; }
        /// <summary> Gets the attack complexity. </summary>
        public string AttackComplexity { get; }
        /// <summary> Gets the privileges required. </summary>
        public string PrivilegesRequired { get; }
        /// <summary> Gets the user interaction. </summary>
        public string UserInteraction { get; }
        /// <summary> Gets the scope. </summary>
        public string Scope { get; }
        /// <summary> Gets the confidentiality impact. </summary>
        public string ConfidentialityImpact { get; }
        /// <summary> Gets the integrity impact. </summary>
        public string IntegrityImpact { get; }
        /// <summary> Gets the availability impact. </summary>
        public string AvailabilityImpact { get; }
        /// <summary> Gets the base score. </summary>
        public float? BaseScore { get; }
        /// <summary> Gets the base severity. </summary>
        public string BaseSeverity { get; }
        /// <summary> Gets the exploit code maturity. </summary>
        public string ExploitCodeMaturity { get; }
        /// <summary> Gets the remediation level. </summary>
        public string RemediationLevel { get; }
        /// <summary> Gets the report confidence. </summary>
        public string ReportConfidence { get; }
        /// <summary> Gets the exploitability score. </summary>
        public float? ExploitabilityScore { get; }
        /// <summary> Gets the impact score. </summary>
        public float? ImpactScore { get; }
    }
}
