// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Defender.Easm
{
    public partial class Cvss3Summary : IUtf8JsonSerializable, IJsonModel<Cvss3Summary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<Cvss3Summary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<Cvss3Summary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Cvss3Summary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Cvss3Summary)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (Optional.IsDefined(VectorString))
            {
                writer.WritePropertyName("vectorString"u8);
                writer.WriteStringValue(VectorString);
            }
            if (Optional.IsDefined(AttackVector))
            {
                writer.WritePropertyName("attackVector"u8);
                writer.WriteStringValue(AttackVector);
            }
            if (Optional.IsDefined(AttackComplexity))
            {
                writer.WritePropertyName("attackComplexity"u8);
                writer.WriteStringValue(AttackComplexity);
            }
            if (Optional.IsDefined(PrivilegesRequired))
            {
                writer.WritePropertyName("privilegesRequired"u8);
                writer.WriteStringValue(PrivilegesRequired);
            }
            if (Optional.IsDefined(UserInteraction))
            {
                writer.WritePropertyName("userInteraction"u8);
                writer.WriteStringValue(UserInteraction);
            }
            if (Optional.IsDefined(Scope))
            {
                writer.WritePropertyName("scope"u8);
                writer.WriteStringValue(Scope);
            }
            if (Optional.IsDefined(ConfidentialityImpact))
            {
                writer.WritePropertyName("confidentialityImpact"u8);
                writer.WriteStringValue(ConfidentialityImpact);
            }
            if (Optional.IsDefined(IntegrityImpact))
            {
                writer.WritePropertyName("integrityImpact"u8);
                writer.WriteStringValue(IntegrityImpact);
            }
            if (Optional.IsDefined(AvailabilityImpact))
            {
                writer.WritePropertyName("availabilityImpact"u8);
                writer.WriteStringValue(AvailabilityImpact);
            }
            if (Optional.IsDefined(BaseScore))
            {
                writer.WritePropertyName("baseScore"u8);
                writer.WriteNumberValue(BaseScore.Value);
            }
            if (Optional.IsDefined(BaseSeverity))
            {
                writer.WritePropertyName("baseSeverity"u8);
                writer.WriteStringValue(BaseSeverity);
            }
            if (Optional.IsDefined(ExploitCodeMaturity))
            {
                writer.WritePropertyName("exploitCodeMaturity"u8);
                writer.WriteStringValue(ExploitCodeMaturity);
            }
            if (Optional.IsDefined(RemediationLevel))
            {
                writer.WritePropertyName("remediationLevel"u8);
                writer.WriteStringValue(RemediationLevel);
            }
            if (Optional.IsDefined(ReportConfidence))
            {
                writer.WritePropertyName("reportConfidence"u8);
                writer.WriteStringValue(ReportConfidence);
            }
            if (Optional.IsDefined(ExploitabilityScore))
            {
                writer.WritePropertyName("exploitabilityScore"u8);
                writer.WriteNumberValue(ExploitabilityScore.Value);
            }
            if (Optional.IsDefined(ImpactScore))
            {
                writer.WritePropertyName("impactScore"u8);
                writer.WriteNumberValue(ImpactScore.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        Cvss3Summary IJsonModel<Cvss3Summary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Cvss3Summary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Cvss3Summary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCvss3Summary(document.RootElement, options);
        }

        internal static Cvss3Summary DeserializeCvss3Summary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string version = default;
            string vectorString = default;
            string attackVector = default;
            string attackComplexity = default;
            string privilegesRequired = default;
            string userInteraction = default;
            string scope = default;
            string confidentialityImpact = default;
            string integrityImpact = default;
            string availabilityImpact = default;
            float? baseScore = default;
            string baseSeverity = default;
            string exploitCodeMaturity = default;
            string remediationLevel = default;
            string reportConfidence = default;
            float? exploitabilityScore = default;
            float? impactScore = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vectorString"u8))
                {
                    vectorString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("attackVector"u8))
                {
                    attackVector = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("attackComplexity"u8))
                {
                    attackComplexity = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("privilegesRequired"u8))
                {
                    privilegesRequired = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userInteraction"u8))
                {
                    userInteraction = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("scope"u8))
                {
                    scope = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("confidentialityImpact"u8))
                {
                    confidentialityImpact = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("integrityImpact"u8))
                {
                    integrityImpact = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("availabilityImpact"u8))
                {
                    availabilityImpact = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("baseScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    baseScore = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("baseSeverity"u8))
                {
                    baseSeverity = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("exploitCodeMaturity"u8))
                {
                    exploitCodeMaturity = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("remediationLevel"u8))
                {
                    remediationLevel = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("reportConfidence"u8))
                {
                    reportConfidence = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("exploitabilityScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exploitabilityScore = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("impactScore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    impactScore = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new Cvss3Summary(
                version,
                vectorString,
                attackVector,
                attackComplexity,
                privilegesRequired,
                userInteraction,
                scope,
                confidentialityImpact,
                integrityImpact,
                availabilityImpact,
                baseScore,
                baseSeverity,
                exploitCodeMaturity,
                remediationLevel,
                reportConfidence,
                exploitabilityScore,
                impactScore,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<Cvss3Summary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Cvss3Summary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(Cvss3Summary)} does not support writing '{options.Format}' format.");
            }
        }

        Cvss3Summary IPersistableModel<Cvss3Summary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Cvss3Summary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCvss3Summary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(Cvss3Summary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<Cvss3Summary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Cvss3Summary FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCvss3Summary(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
