// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The CookieDetails. </summary>
    public partial class CookieDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CookieDetails"/>. </summary>
        internal CookieDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CookieDetails"/>. </summary>
        /// <param name="cookieName"></param>
        /// <param name="cookieDomain"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="cookieExpiryDate"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CookieDetails(string cookieName, string cookieDomain, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, bool? recent, DateTimeOffset? cookieExpiryDate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CookieName = cookieName;
            CookieDomain = cookieDomain;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            Recent = recent;
            CookieExpiryDate = cookieExpiryDate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the cookie name. </summary>
        public string CookieName { get; }
        /// <summary> Gets the cookie domain. </summary>
        public string CookieDomain { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the recent. </summary>
        public bool? Recent { get; }
        /// <summary> Gets the cookie expiry date. </summary>
        public DateTimeOffset? CookieExpiryDate { get; }
    }
}
