// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The BannerDetails. </summary>
    public partial class BannerDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BannerDetails"/>. </summary>
        internal BannerDetails()
        {
            Sources = new ChangeTrackingList<SourceDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="BannerDetails"/>. </summary>
        /// <param name="port"></param>
        /// <param name="bannerName"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="scanType"></param>
        /// <param name="bannerMetadata"></param>
        /// <param name="recent"></param>
        /// <param name="sha256"></param>
        /// <param name="sources"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BannerDetails(int? port, string bannerName, DateTimeOffset? firstSeen, DateTimeOffset? lastSeen, long? count, string scanType, string bannerMetadata, bool? recent, string sha256, IReadOnlyList<SourceDetails> sources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Port = port;
            BannerName = bannerName;
            FirstSeen = firstSeen;
            LastSeen = lastSeen;
            Count = count;
            ScanType = scanType;
            BannerMetadata = bannerMetadata;
            Recent = recent;
            Sha256 = sha256;
            Sources = sources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the port. </summary>
        public int? Port { get; }
        /// <summary> Gets the banner name. </summary>
        public string BannerName { get; }
        /// <summary> Gets the first seen. </summary>
        public DateTimeOffset? FirstSeen { get; }
        /// <summary> Gets the last seen. </summary>
        public DateTimeOffset? LastSeen { get; }
        /// <summary> Gets the count. </summary>
        public long? Count { get; }
        /// <summary> Gets the scan type. </summary>
        public string ScanType { get; }
        /// <summary> Gets the banner metadata. </summary>
        public string BannerMetadata { get; }
        /// <summary> Gets the recent. </summary>
        public bool? Recent { get; }
        /// <summary> Gets the sha 256. </summary>
        public string Sha256 { get; }
        /// <summary> Gets the sources. </summary>
        public IReadOnlyList<SourceDetails> Sources { get; }
    }
}
