// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The AzureDataExplorerDataConnectionPayload. </summary>
    public partial class AzureDataExplorerDataConnectionPayload : DataConnectionPayload
    {
        /// <summary> Initializes a new instance of <see cref="AzureDataExplorerDataConnectionPayload"/>. </summary>
        /// <param name="properties"> properties. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public AzureDataExplorerDataConnectionPayload(AzureDataExplorerDataConnectionProperties properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Kind = "azureDataExplorer";
            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="AzureDataExplorerDataConnectionPayload"/>. </summary>
        /// <param name="kind"> Discriminator property for DataConnectionPayload. </param>
        /// <param name="name"> The name of data connection. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. (1-7 for weekly, 1-31 for monthly). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> properties. </param>
        internal AzureDataExplorerDataConnectionPayload(string kind, string name, DataConnectionContent? content, DataConnectionFrequency? frequency, int? frequencyOffset, IDictionary<string, BinaryData> serializedAdditionalRawData, AzureDataExplorerDataConnectionProperties properties) : base(kind, name, content, frequency, frequencyOffset, serializedAdditionalRawData)
        {
            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="AzureDataExplorerDataConnectionPayload"/> for deserialization. </summary>
        internal AzureDataExplorerDataConnectionPayload()
        {
        }

        /// <summary> properties. </summary>
        public AzureDataExplorerDataConnectionProperties Properties { get; }
    }
}
