// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> The collection of asset summaries. </summary>
    public partial class AssetSummaryResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssetSummaryResult"/>. </summary>
        internal AssetSummaryResult()
        {
            Children = new ChangeTrackingList<AssetSummaryResult>();
        }

        /// <summary> Initializes a new instance of <see cref="AssetSummaryResult"/>. </summary>
        /// <param name="displayName"> The name of the summary response.  Depending on the request time this will either be the asset filter, risk category, or risk metric. </param>
        /// <param name="description"> The description of the summary response.  Filters don't have a description. </param>
        /// <param name="updatedAt"> The last time risk categories or risk metrics were captured. Set to the current time for asset filter requests, which always pull the live asset data. </param>
        /// <param name="metricCategory"> If the request is for a metric category, this will contain the requested unique category name. </param>
        /// <param name="metric"> If the request is for a metric, this will contain the requested unique metric name. </param>
        /// <param name="filter"> If the request is for an asset filter, this will contain the corresponding filter. </param>
        /// <param name="labelName"> An optional label used to filter requests results. </param>
        /// <param name="count"> The count of assets matching the request parameters. </param>
        /// <param name="link"> The link to the corresponding asset details. </param>
        /// <param name="children"> The corresponding child entities.  For metric categories this will contain metrics.  For filters with groupBy and segmentBy this will contain facets. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssetSummaryResult(string displayName, string description, DateTimeOffset? updatedAt, string metricCategory, string metric, string filter, string labelName, long? count, string link, IReadOnlyList<AssetSummaryResult> children, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            Description = description;
            UpdatedAt = updatedAt;
            MetricCategory = metricCategory;
            Metric = metric;
            Filter = filter;
            LabelName = labelName;
            Count = count;
            Link = link;
            Children = children;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the summary response.  Depending on the request time this will either be the asset filter, risk category, or risk metric. </summary>
        public string DisplayName { get; }
        /// <summary> The description of the summary response.  Filters don't have a description. </summary>
        public string Description { get; }
        /// <summary> The last time risk categories or risk metrics were captured. Set to the current time for asset filter requests, which always pull the live asset data. </summary>
        public DateTimeOffset? UpdatedAt { get; }
        /// <summary> If the request is for a metric category, this will contain the requested unique category name. </summary>
        public string MetricCategory { get; }
        /// <summary> If the request is for a metric, this will contain the requested unique metric name. </summary>
        public string Metric { get; }
        /// <summary> If the request is for an asset filter, this will contain the corresponding filter. </summary>
        public string Filter { get; }
        /// <summary> An optional label used to filter requests results. </summary>
        public string LabelName { get; }
        /// <summary> The count of assets matching the request parameters. </summary>
        public long? Count { get; }
        /// <summary> The link to the corresponding asset details. </summary>
        public string Link { get; }
        /// <summary> The corresponding child entities.  For metric categories this will contain metrics.  For filters with groupBy and segmentBy this will contain facets. </summary>
        public IReadOnlyList<AssetSummaryResult> Children { get; }
    }
}
