// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Defender.Easm
{
    /// <summary> Model factory for models. </summary>
    public static partial class AnalyticsDefenderEasmModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Easm.AssetResource"/>. </summary>
        /// <param name="kind"> Discriminator property for AssetResource. </param>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <returns> A new <see cref="Easm.AssetResource"/> instance for mocking. </returns>
        public static AssetResource AssetResource(string kind = null, string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new UnknownAssetResource(
                kind,
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AuditTrailItem"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="kind"> The kind of asset. </param>
        /// <param name="reason"> An explanation of why this audit trail node was discovered from the previous node. </param>
        /// <returns> A new <see cref="Easm.AuditTrailItem"/> instance for mocking. </returns>
        public static AuditTrailItem AuditTrailItem(string id = null, string name = null, string displayName = null, AuditTrailItemKind? kind = null, string reason = null)
        {
            return new AuditTrailItem(
                id,
                name,
                displayName,
                kind,
                reason,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AsAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.AsAssetResource"/> instance for mocking. </returns>
        public static AsAssetResource AsAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, AsAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new AsAssetResource(
                "as",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AsAsset"/>. </summary>
        /// <param name="asn"></param>
        /// <param name="asNames"></param>
        /// <param name="orgNames"></param>
        /// <param name="orgIds"></param>
        /// <param name="countries"></param>
        /// <param name="registries"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="registrarCreatedAt"></param>
        /// <param name="registrarUpdatedAt"></param>
        /// <param name="registrantContacts"></param>
        /// <param name="adminContacts"></param>
        /// <param name="technicalContacts"></param>
        /// <param name="registrarNames"></param>
        /// <param name="registrantNames"></param>
        /// <param name="adminNames"></param>
        /// <param name="technicalNames"></param>
        /// <param name="adminOrgs"></param>
        /// <param name="technicalOrgs"></param>
        /// <param name="registrantPhones"></param>
        /// <param name="adminPhones"></param>
        /// <param name="technicalPhones"></param>
        /// <param name="detailedFromWhoisAt"></param>
        /// <returns> A new <see cref="Easm.AsAsset"/> instance for mocking. </returns>
        public static AsAsset AsAsset(long? asn = null, IEnumerable<ObservedString> asNames = null, IEnumerable<ObservedString> orgNames = null, IEnumerable<ObservedString> orgIds = null, IEnumerable<ObservedString> countries = null, IEnumerable<ObservedString> registries = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<ObservedLong> registrarCreatedAt = null, IEnumerable<ObservedLong> registrarUpdatedAt = null, IEnumerable<ObservedString> registrantContacts = null, IEnumerable<ObservedString> adminContacts = null, IEnumerable<ObservedString> technicalContacts = null, IEnumerable<ObservedString> registrarNames = null, IEnumerable<ObservedString> registrantNames = null, IEnumerable<ObservedString> adminNames = null, IEnumerable<ObservedString> technicalNames = null, IEnumerable<ObservedString> adminOrgs = null, IEnumerable<ObservedString> technicalOrgs = null, IEnumerable<ObservedString> registrantPhones = null, IEnumerable<ObservedString> adminPhones = null, IEnumerable<ObservedString> technicalPhones = null, DateTimeOffset? detailedFromWhoisAt = null)
        {
            asNames ??= new List<ObservedString>();
            orgNames ??= new List<ObservedString>();
            orgIds ??= new List<ObservedString>();
            countries ??= new List<ObservedString>();
            registries ??= new List<ObservedString>();
            sources ??= new List<SourceDetails>();
            registrarCreatedAt ??= new List<ObservedLong>();
            registrarUpdatedAt ??= new List<ObservedLong>();
            registrantContacts ??= new List<ObservedString>();
            adminContacts ??= new List<ObservedString>();
            technicalContacts ??= new List<ObservedString>();
            registrarNames ??= new List<ObservedString>();
            registrantNames ??= new List<ObservedString>();
            adminNames ??= new List<ObservedString>();
            technicalNames ??= new List<ObservedString>();
            adminOrgs ??= new List<ObservedString>();
            technicalOrgs ??= new List<ObservedString>();
            registrantPhones ??= new List<ObservedString>();
            adminPhones ??= new List<ObservedString>();
            technicalPhones ??= new List<ObservedString>();

            return new AsAsset(
                serializedAdditionalRawData: null,
                asn,
                asNames?.ToList(),
                orgNames?.ToList(),
                orgIds?.ToList(),
                countries?.ToList(),
                registries?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                registrarCreatedAt?.ToList(),
                registrarUpdatedAt?.ToList(),
                registrantContacts?.ToList(),
                adminContacts?.ToList(),
                technicalContacts?.ToList(),
                registrarNames?.ToList(),
                registrantNames?.ToList(),
                adminNames?.ToList(),
                technicalNames?.ToList(),
                adminOrgs?.ToList(),
                technicalOrgs?.ToList(),
                registrantPhones?.ToList(),
                adminPhones?.ToList(),
                technicalPhones?.ToList(),
                detailedFromWhoisAt);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedString"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedString"/> instance for mocking. </returns>
        public static ObservedString ObservedString(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, string value = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new ObservedString(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SourceDetails"/>. </summary>
        /// <param name="sourceName"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="reason"></param>
        /// <returns> A new <see cref="Easm.SourceDetails"/> instance for mocking. </returns>
        public static SourceDetails SourceDetails(string sourceName = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, string reason = null)
        {
            return new SourceDetails(
                sourceName,
                firstSeen,
                lastSeen,
                count,
                reason,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedValue"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.ObservedValue"/> instance for mocking. </returns>
        public static ObservedValue ObservedValue(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null)
        {
            return new ObservedValue(firstSeen, lastSeen, count, recent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedLong"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedLong"/> instance for mocking. </returns>
        public static ObservedLong ObservedLong(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, long? value = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new ObservedLong(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ContactAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.ContactAssetResource"/> instance for mocking. </returns>
        public static ContactAssetResource ContactAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, ContactAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new ContactAssetResource(
                "contact",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ContactAsset"/>. </summary>
        /// <param name="email"></param>
        /// <param name="names"></param>
        /// <param name="organizations"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <returns> A new <see cref="Easm.ContactAsset"/> instance for mocking. </returns>
        public static ContactAsset ContactAsset(string email = null, IEnumerable<ObservedString> names = null, IEnumerable<ObservedString> organizations = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null)
        {
            names ??= new List<ObservedString>();
            organizations ??= new List<ObservedString>();
            sources ??= new List<SourceDetails>();

            return new ContactAsset(
                serializedAdditionalRawData: null,
                email,
                names?.ToList(),
                organizations?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DomainAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.DomainAssetResource"/> instance for mocking. </returns>
        public static DomainAssetResource DomainAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, DomainAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new DomainAssetResource(
                "domain",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DomainAsset"/>. </summary>
        /// <param name="domain"></param>
        /// <param name="whoisId"></param>
        /// <param name="registrarIanaIds"></param>
        /// <param name="registrantContacts"></param>
        /// <param name="registrantOrgs"></param>
        /// <param name="adminContacts"></param>
        /// <param name="technicalContacts"></param>
        /// <param name="alexaInfos"></param>
        /// <param name="nameServers"></param>
        /// <param name="mailServers"></param>
        /// <param name="whoisServers"></param>
        /// <param name="domainStatuses"></param>
        /// <param name="registrarCreatedAt"></param>
        /// <param name="registrarUpdatedAt"></param>
        /// <param name="registrarExpiresAt"></param>
        /// <param name="soaRecords"></param>
        /// <param name="detailedFromWhoisAt"></param>
        /// <param name="registrarNames"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="parkedDomain"></param>
        /// <param name="registrantNames"></param>
        /// <param name="adminNames"></param>
        /// <param name="technicalNames"></param>
        /// <param name="adminOrgs"></param>
        /// <param name="technicalOrgs"></param>
        /// <param name="registrantPhones"></param>
        /// <param name="adminPhones"></param>
        /// <param name="technicalPhones"></param>
        /// <returns> A new <see cref="Easm.DomainAsset"/> instance for mocking. </returns>
        public static DomainAsset DomainAsset(string domain = null, long? whoisId = null, IEnumerable<ObservedInteger> registrarIanaIds = null, IEnumerable<ObservedString> registrantContacts = null, IEnumerable<ObservedString> registrantOrgs = null, IEnumerable<ObservedString> adminContacts = null, IEnumerable<ObservedString> technicalContacts = null, IEnumerable<AlexaInfo> alexaInfos = null, IEnumerable<ObservedString> nameServers = null, IEnumerable<ObservedString> mailServers = null, IEnumerable<ObservedString> whoisServers = null, IEnumerable<ObservedString> domainStatuses = null, IEnumerable<ObservedLong> registrarCreatedAt = null, IEnumerable<ObservedLong> registrarUpdatedAt = null, IEnumerable<ObservedLong> registrarExpiresAt = null, IEnumerable<SoaRecord> soaRecords = null, DateTimeOffset? detailedFromWhoisAt = null, IEnumerable<ObservedString> registrarNames = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<ObservedBoolean> parkedDomain = null, IEnumerable<ObservedString> registrantNames = null, IEnumerable<ObservedString> adminNames = null, IEnumerable<ObservedString> technicalNames = null, IEnumerable<ObservedString> adminOrgs = null, IEnumerable<ObservedString> technicalOrgs = null, IEnumerable<ObservedString> registrantPhones = null, IEnumerable<ObservedString> adminPhones = null, IEnumerable<ObservedString> technicalPhones = null)
        {
            registrarIanaIds ??= new List<ObservedInteger>();
            registrantContacts ??= new List<ObservedString>();
            registrantOrgs ??= new List<ObservedString>();
            adminContacts ??= new List<ObservedString>();
            technicalContacts ??= new List<ObservedString>();
            alexaInfos ??= new List<AlexaInfo>();
            nameServers ??= new List<ObservedString>();
            mailServers ??= new List<ObservedString>();
            whoisServers ??= new List<ObservedString>();
            domainStatuses ??= new List<ObservedString>();
            registrarCreatedAt ??= new List<ObservedLong>();
            registrarUpdatedAt ??= new List<ObservedLong>();
            registrarExpiresAt ??= new List<ObservedLong>();
            soaRecords ??= new List<SoaRecord>();
            registrarNames ??= new List<ObservedString>();
            sources ??= new List<SourceDetails>();
            parkedDomain ??= new List<ObservedBoolean>();
            registrantNames ??= new List<ObservedString>();
            adminNames ??= new List<ObservedString>();
            technicalNames ??= new List<ObservedString>();
            adminOrgs ??= new List<ObservedString>();
            technicalOrgs ??= new List<ObservedString>();
            registrantPhones ??= new List<ObservedString>();
            adminPhones ??= new List<ObservedString>();
            technicalPhones ??= new List<ObservedString>();

            return new DomainAsset(
                domain,
                whoisId,
                registrarIanaIds?.ToList(),
                registrantContacts?.ToList(),
                registrantOrgs?.ToList(),
                adminContacts?.ToList(),
                technicalContacts?.ToList(),
                alexaInfos?.ToList(),
                nameServers?.ToList(),
                mailServers?.ToList(),
                whoisServers?.ToList(),
                domainStatuses?.ToList(),
                registrarCreatedAt?.ToList(),
                registrarUpdatedAt?.ToList(),
                registrarExpiresAt?.ToList(),
                soaRecords?.ToList(),
                detailedFromWhoisAt,
                registrarNames?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                parkedDomain?.ToList(),
                registrantNames?.ToList(),
                adminNames?.ToList(),
                technicalNames?.ToList(),
                adminOrgs?.ToList(),
                technicalOrgs?.ToList(),
                registrantPhones?.ToList(),
                adminPhones?.ToList(),
                technicalPhones?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedInteger"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedInteger"/> instance for mocking. </returns>
        public static ObservedInteger ObservedInteger(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, int? value = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new ObservedInteger(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AlexaInfo"/>. </summary>
        /// <param name="alexaRank"></param>
        /// <param name="category"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.AlexaInfo"/> instance for mocking. </returns>
        public static AlexaInfo AlexaInfo(long? alexaRank = null, string category = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null)
        {
            return new AlexaInfo(
                alexaRank,
                category,
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SoaRecord"/>. </summary>
        /// <param name="nameServer"></param>
        /// <param name="email"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="serialNumber"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.SoaRecord"/> instance for mocking. </returns>
        public static SoaRecord SoaRecord(string nameServer = null, string email = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, long? serialNumber = null, bool? recent = null)
        {
            return new SoaRecord(
                nameServer,
                email,
                firstSeen,
                lastSeen,
                count,
                serialNumber,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedBoolean"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedBoolean"/> instance for mocking. </returns>
        public static ObservedBoolean ObservedBoolean(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, bool? value = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new ObservedBoolean(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.HostAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.HostAssetResource"/> instance for mocking. </returns>
        public static HostAssetResource HostAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, HostAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new HostAssetResource(
                "host",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.HostAsset"/>. </summary>
        /// <param name="host"></param>
        /// <param name="domain"></param>
        /// <param name="ipAddresses"></param>
        /// <param name="webComponents"></param>
        /// <param name="headers"></param>
        /// <param name="attributes"></param>
        /// <param name="cookies"></param>
        /// <param name="sslCerts"></param>
        /// <param name="parentHosts"></param>
        /// <param name="childHosts"></param>
        /// <param name="hostCore"></param>
        /// <param name="services"></param>
        /// <param name="cnames"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="resourceUrls"></param>
        /// <param name="scanMetadata"></param>
        /// <param name="asns"></param>
        /// <param name="ipBlocks"></param>
        /// <param name="responseBodies"></param>
        /// <param name="domainAsset"></param>
        /// <param name="nsRecord"></param>
        /// <param name="mxRecord"></param>
        /// <param name="webserver"></param>
        /// <param name="location"></param>
        /// <param name="nxdomain"></param>
        /// <param name="sslServerConfig"></param>
        /// <param name="isWildcard"></param>
        /// <param name="banners"></param>
        /// <param name="ipv4"></param>
        /// <param name="ipv6"></param>
        /// <returns> A new <see cref="Easm.HostAsset"/> instance for mocking. </returns>
        public static HostAsset HostAsset(string host = null, string domain = null, IEnumerable<ObservedString> ipAddresses = null, IEnumerable<WebComponent> webComponents = null, IEnumerable<ObservedHeader> headers = null, IEnumerable<AttributeDetails> attributes = null, IEnumerable<CookieDetails> cookies = null, IEnumerable<SslCertAsset> sslCerts = null, IEnumerable<ObservedString> parentHosts = null, IEnumerable<ObservedString> childHosts = null, HostCore hostCore = null, IEnumerable<AssetService> services = null, IEnumerable<ObservedString> cnames = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<ResourceUri> resourceUrls = null, IEnumerable<ScanMetadata> scanMetadata = null, IEnumerable<ObservedLong> asns = null, IEnumerable<IpBlock> ipBlocks = null, IEnumerable<ObservedString> responseBodies = null, DomainAsset domainAsset = null, IEnumerable<ObservedBoolean> nsRecord = null, IEnumerable<ObservedBoolean> mxRecord = null, IEnumerable<ObservedBoolean> webserver = null, IEnumerable<ObservedLocation> location = null, IEnumerable<ObservedBoolean> nxdomain = null, IEnumerable<SslServerConfig> sslServerConfig = null, IEnumerable<ObservedBoolean> isWildcard = null, IEnumerable<BannerDetails> banners = null, IEnumerable<ObservedBoolean> ipv4 = null, IEnumerable<ObservedBoolean> ipv6 = null)
        {
            ipAddresses ??= new List<ObservedString>();
            webComponents ??= new List<WebComponent>();
            headers ??= new List<ObservedHeader>();
            attributes ??= new List<AttributeDetails>();
            cookies ??= new List<CookieDetails>();
            sslCerts ??= new List<SslCertAsset>();
            parentHosts ??= new List<ObservedString>();
            childHosts ??= new List<ObservedString>();
            services ??= new List<AssetService>();
            cnames ??= new List<ObservedString>();
            sources ??= new List<SourceDetails>();
            resourceUrls ??= new List<ResourceUri>();
            scanMetadata ??= new List<ScanMetadata>();
            asns ??= new List<ObservedLong>();
            ipBlocks ??= new List<IpBlock>();
            responseBodies ??= new List<ObservedString>();
            nsRecord ??= new List<ObservedBoolean>();
            mxRecord ??= new List<ObservedBoolean>();
            webserver ??= new List<ObservedBoolean>();
            location ??= new List<ObservedLocation>();
            nxdomain ??= new List<ObservedBoolean>();
            sslServerConfig ??= new List<SslServerConfig>();
            isWildcard ??= new List<ObservedBoolean>();
            banners ??= new List<BannerDetails>();
            ipv4 ??= new List<ObservedBoolean>();
            ipv6 ??= new List<ObservedBoolean>();

            return new HostAsset(
                serializedAdditionalRawData: null,
                host,
                domain,
                ipAddresses?.ToList(),
                webComponents?.ToList(),
                headers?.ToList(),
                attributes?.ToList(),
                cookies?.ToList(),
                sslCerts?.ToList(),
                parentHosts?.ToList(),
                childHosts?.ToList(),
                hostCore,
                services?.ToList(),
                cnames?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                resourceUrls?.ToList(),
                scanMetadata?.ToList(),
                asns?.ToList(),
                ipBlocks?.ToList(),
                responseBodies?.ToList(),
                domainAsset,
                nsRecord?.ToList(),
                mxRecord?.ToList(),
                webserver?.ToList(),
                location?.ToList(),
                nxdomain?.ToList(),
                sslServerConfig?.ToList(),
                isWildcard?.ToList(),
                banners?.ToList(),
                ipv4?.ToList(),
                ipv6?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.WebComponent"/>. </summary>
        /// <param name="name"></param>
        /// <param name="type"></param>
        /// <param name="version"></param>
        /// <param name="ruleId"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="cve"></param>
        /// <param name="endOfLife"></param>
        /// <param name="recent"></param>
        /// <param name="ports"></param>
        /// <param name="sources"></param>
        /// <param name="service"></param>
        /// <returns> A new <see cref="Easm.WebComponent"/> instance for mocking. </returns>
        public static WebComponent WebComponent(string name = null, string type = null, string version = null, IEnumerable<string> ruleId = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<CveDetails> cve = null, long? endOfLife = null, bool? recent = null, IEnumerable<PortDetails> ports = null, IEnumerable<SourceDetails> sources = null, string service = null)
        {
            ruleId ??= new List<string>();
            cve ??= new List<CveDetails>();
            ports ??= new List<PortDetails>();
            sources ??= new List<SourceDetails>();

            return new WebComponent(
                name,
                type,
                version,
                ruleId?.ToList(),
                firstSeen,
                lastSeen,
                count,
                cve?.ToList(),
                endOfLife,
                recent,
                ports?.ToList(),
                sources?.ToList(),
                service,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.CveDetails"/>. </summary>
        /// <param name="name"></param>
        /// <param name="cweId"></param>
        /// <param name="cvssScore"></param>
        /// <param name="cvss3Summary"></param>
        /// <returns> A new <see cref="Easm.CveDetails"/> instance for mocking. </returns>
        public static CveDetails CveDetails(string name = null, string cweId = null, float? cvssScore = null, Cvss3Summary cvss3Summary = null)
        {
            return new CveDetails(name, cweId, cvssScore, cvss3Summary, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.Cvss3Summary"/>. </summary>
        /// <param name="version"></param>
        /// <param name="vectorString"></param>
        /// <param name="attackVector"></param>
        /// <param name="attackComplexity"></param>
        /// <param name="privilegesRequired"></param>
        /// <param name="userInteraction"></param>
        /// <param name="scope"></param>
        /// <param name="confidentialityImpact"></param>
        /// <param name="integrityImpact"></param>
        /// <param name="availabilityImpact"></param>
        /// <param name="baseScore"></param>
        /// <param name="baseSeverity"></param>
        /// <param name="exploitCodeMaturity"></param>
        /// <param name="remediationLevel"></param>
        /// <param name="reportConfidence"></param>
        /// <param name="exploitabilityScore"></param>
        /// <param name="impactScore"></param>
        /// <returns> A new <see cref="Easm.Cvss3Summary"/> instance for mocking. </returns>
        public static Cvss3Summary Cvss3Summary(string version = null, string vectorString = null, string attackVector = null, string attackComplexity = null, string privilegesRequired = null, string userInteraction = null, string scope = null, string confidentialityImpact = null, string integrityImpact = null, string availabilityImpact = null, float? baseScore = null, string baseSeverity = null, string exploitCodeMaturity = null, string remediationLevel = null, string reportConfidence = null, float? exploitabilityScore = null, float? impactScore = null)
        {
            return new Cvss3Summary(
                version,
                vectorString,
                attackVector,
                attackComplexity,
                privilegesRequired,
                userInteraction,
                scope,
                confidentialityImpact,
                integrityImpact,
                availabilityImpact,
                baseScore,
                baseSeverity,
                exploitCodeMaturity,
                remediationLevel,
                reportConfidence,
                exploitabilityScore,
                impactScore,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.PortDetails"/>. </summary>
        /// <param name="portName"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <returns> A new <see cref="Easm.PortDetails"/> instance for mocking. </returns>
        public static PortDetails PortDetails(int? portName = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null)
        {
            return new PortDetails(portName, firstSeen, lastSeen, count, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedHeader"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="headerName"></param>
        /// <param name="headerValue"></param>
        /// <returns> A new <see cref="Easm.ObservedHeader"/> instance for mocking. </returns>
        public static ObservedHeader ObservedHeader(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, string headerName = null, string headerValue = null)
        {
            return new ObservedHeader(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                headerName,
                headerValue);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AttributeDetails"/>. </summary>
        /// <param name="attributeType"></param>
        /// <param name="attributeValue"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.AttributeDetails"/> instance for mocking. </returns>
        public static AttributeDetails AttributeDetails(string attributeType = null, string attributeValue = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null)
        {
            sources ??= new List<SourceDetails>();

            return new AttributeDetails(
                attributeType,
                attributeValue,
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.CookieDetails"/>. </summary>
        /// <param name="cookieName"></param>
        /// <param name="cookieDomain"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="cookieExpiryDate"></param>
        /// <returns> A new <see cref="Easm.CookieDetails"/> instance for mocking. </returns>
        public static CookieDetails CookieDetails(string cookieName = null, string cookieDomain = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, DateTimeOffset? cookieExpiryDate = null)
        {
            return new CookieDetails(
                cookieName,
                cookieDomain,
                firstSeen,
                lastSeen,
                count,
                recent,
                cookieExpiryDate,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SslCertAsset"/>. </summary>
        /// <param name="sha1"></param>
        /// <param name="subjectCommonNames"></param>
        /// <param name="organizations"></param>
        /// <param name="organizationalUnits"></param>
        /// <param name="issuerCommonNames"></param>
        /// <param name="sigAlgName"></param>
        /// <param name="invalidAfter"></param>
        /// <param name="serialNumber"></param>
        /// <param name="subjectAlternativeNames"></param>
        /// <param name="issuerAlternativeNames"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="invalidBefore"></param>
        /// <param name="keySize"></param>
        /// <param name="keyAlgorithm"></param>
        /// <param name="subjectLocality"></param>
        /// <param name="subjectState"></param>
        /// <param name="subjectCountry"></param>
        /// <param name="issuerLocality"></param>
        /// <param name="issuerState"></param>
        /// <param name="issuerCountry"></param>
        /// <param name="subjectOrganizations"></param>
        /// <param name="subjectOrganizationalUnits"></param>
        /// <param name="issuerOrganizations"></param>
        /// <param name="issuerOrganizationalUnits"></param>
        /// <param name="version"></param>
        /// <param name="certificateAuthority"></param>
        /// <param name="selfSigned"></param>
        /// <param name="sigAlgOid"></param>
        /// <param name="recent"></param>
        /// <param name="validationType"></param>
        /// <returns> A new <see cref="Easm.SslCertAsset"/> instance for mocking. </returns>
        public static SslCertAsset SslCertAsset(string sha1 = null, IEnumerable<string> subjectCommonNames = null, IEnumerable<string> organizations = null, IEnumerable<string> organizationalUnits = null, IEnumerable<string> issuerCommonNames = null, string sigAlgName = null, DateTimeOffset? invalidAfter = null, string serialNumber = null, IEnumerable<string> subjectAlternativeNames = null, IEnumerable<string> issuerAlternativeNames = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, DateTimeOffset? invalidBefore = null, int? keySize = null, string keyAlgorithm = null, IEnumerable<string> subjectLocality = null, IEnumerable<string> subjectState = null, IEnumerable<string> subjectCountry = null, IEnumerable<string> issuerLocality = null, IEnumerable<string> issuerState = null, IEnumerable<string> issuerCountry = null, IEnumerable<string> subjectOrganizations = null, IEnumerable<string> subjectOrganizationalUnits = null, IEnumerable<string> issuerOrganizations = null, IEnumerable<string> issuerOrganizationalUnits = null, int? version = null, bool? certificateAuthority = null, bool? selfSigned = null, string sigAlgOid = null, bool? recent = null, SslCertAssetValidationType? validationType = null)
        {
            subjectCommonNames ??= new List<string>();
            organizations ??= new List<string>();
            organizationalUnits ??= new List<string>();
            issuerCommonNames ??= new List<string>();
            subjectAlternativeNames ??= new List<string>();
            issuerAlternativeNames ??= new List<string>();
            sources ??= new List<SourceDetails>();
            subjectLocality ??= new List<string>();
            subjectState ??= new List<string>();
            subjectCountry ??= new List<string>();
            issuerLocality ??= new List<string>();
            issuerState ??= new List<string>();
            issuerCountry ??= new List<string>();
            subjectOrganizations ??= new List<string>();
            subjectOrganizationalUnits ??= new List<string>();
            issuerOrganizations ??= new List<string>();
            issuerOrganizationalUnits ??= new List<string>();

            return new SslCertAsset(
                serializedAdditionalRawData: null,
                sha1,
                subjectCommonNames?.ToList(),
                organizations?.ToList(),
                organizationalUnits?.ToList(),
                issuerCommonNames?.ToList(),
                sigAlgName,
                invalidAfter,
                serialNumber,
                subjectAlternativeNames?.ToList(),
                issuerAlternativeNames?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                invalidBefore,
                keySize,
                keyAlgorithm,
                subjectLocality?.ToList(),
                subjectState?.ToList(),
                subjectCountry?.ToList(),
                issuerLocality?.ToList(),
                issuerState?.ToList(),
                issuerCountry?.ToList(),
                subjectOrganizations?.ToList(),
                subjectOrganizationalUnits?.ToList(),
                issuerOrganizations?.ToList(),
                issuerOrganizationalUnits?.ToList(),
                version,
                certificateAuthority,
                selfSigned,
                sigAlgOid,
                recent,
                validationType);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.HostCore"/>. </summary>
        /// <param name="host"></param>
        /// <param name="domain"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="blacklistCauseFirstSeen"></param>
        /// <param name="blacklistCauseLastSeen"></param>
        /// <param name="blacklistCauseCount"></param>
        /// <param name="blacklistResourceFirstSeen"></param>
        /// <param name="blacklistResourceLastSeen"></param>
        /// <param name="blacklistResourceCount"></param>
        /// <param name="blacklistSequenceFirstSeen"></param>
        /// <param name="blacklistSequenceLastSeen"></param>
        /// <param name="blacklistSequenceCount"></param>
        /// <param name="phishCauseCount"></param>
        /// <param name="malwareCauseCount"></param>
        /// <param name="spamCauseCount"></param>
        /// <param name="scamCauseCount"></param>
        /// <param name="phishResourceCount"></param>
        /// <param name="malwareResourceCount"></param>
        /// <param name="spamResourceCount"></param>
        /// <param name="scamResourceCount"></param>
        /// <param name="phishSequenceCount"></param>
        /// <param name="malwareSequenceCount"></param>
        /// <param name="spamSequenceCount"></param>
        /// <param name="scamSequenceCount"></param>
        /// <param name="alexaRank"></param>
        /// <param name="hostReputationScore"></param>
        /// <param name="hostPhishReputationScore"></param>
        /// <param name="hostMalwareReputationScore"></param>
        /// <param name="hostSpamReputationScore"></param>
        /// <param name="hostScamReputationScore"></param>
        /// <param name="domainReputationScore"></param>
        /// <param name="domainPhishReputationScore"></param>
        /// <param name="domainMalwareReputationScore"></param>
        /// <param name="domainSpamReputationScore"></param>
        /// <param name="domainScamReputationScore"></param>
        /// <param name="uuid"></param>
        /// <returns> A new <see cref="Easm.HostCore"/> instance for mocking. </returns>
        public static HostCore HostCore(string host = null, string domain = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, DateTimeOffset? blacklistCauseFirstSeen = null, DateTimeOffset? blacklistCauseLastSeen = null, long? blacklistCauseCount = null, DateTimeOffset? blacklistResourceFirstSeen = null, DateTimeOffset? blacklistResourceLastSeen = null, long? blacklistResourceCount = null, DateTimeOffset? blacklistSequenceFirstSeen = null, DateTimeOffset? blacklistSequenceLastSeen = null, long? blacklistSequenceCount = null, long? phishCauseCount = null, long? malwareCauseCount = null, long? spamCauseCount = null, long? scamCauseCount = null, long? phishResourceCount = null, long? malwareResourceCount = null, long? spamResourceCount = null, long? scamResourceCount = null, long? phishSequenceCount = null, long? malwareSequenceCount = null, long? spamSequenceCount = null, long? scamSequenceCount = null, int? alexaRank = null, int? hostReputationScore = null, int? hostPhishReputationScore = null, int? hostMalwareReputationScore = null, int? hostSpamReputationScore = null, int? hostScamReputationScore = null, int? domainReputationScore = null, int? domainPhishReputationScore = null, int? domainMalwareReputationScore = null, int? domainSpamReputationScore = null, int? domainScamReputationScore = null, string uuid = null)
        {
            return new HostCore(
                host,
                domain,
                firstSeen,
                lastSeen,
                count,
                blacklistCauseFirstSeen,
                blacklistCauseLastSeen,
                blacklistCauseCount,
                blacklistResourceFirstSeen,
                blacklistResourceLastSeen,
                blacklistResourceCount,
                blacklistSequenceFirstSeen,
                blacklistSequenceLastSeen,
                blacklistSequenceCount,
                phishCauseCount,
                malwareCauseCount,
                spamCauseCount,
                scamCauseCount,
                phishResourceCount,
                malwareResourceCount,
                spamResourceCount,
                scamResourceCount,
                phishSequenceCount,
                malwareSequenceCount,
                spamSequenceCount,
                scamSequenceCount,
                alexaRank,
                hostReputationScore,
                hostPhishReputationScore,
                hostMalwareReputationScore,
                hostSpamReputationScore,
                hostScamReputationScore,
                domainReputationScore,
                domainPhishReputationScore,
                domainMalwareReputationScore,
                domainSpamReputationScore,
                domainScamReputationScore,
                uuid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AssetService"/>. </summary>
        /// <param name="scheme"></param>
        /// <param name="port"></param>
        /// <param name="webComponents"></param>
        /// <param name="sslCerts"></param>
        /// <param name="exceptions"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="portStates"></param>
        /// <returns> A new <see cref="Easm.AssetService"/> instance for mocking. </returns>
        public static AssetService AssetService(string scheme = null, int? port = null, IEnumerable<WebComponent> webComponents = null, IEnumerable<SslCertAsset> sslCerts = null, IEnumerable<ObservedString> exceptions = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, IEnumerable<ObservedPortState> portStates = null)
        {
            webComponents ??= new List<WebComponent>();
            sslCerts ??= new List<SslCertAsset>();
            exceptions ??= new List<ObservedString>();
            sources ??= new List<SourceDetails>();
            portStates ??= new List<ObservedPortState>();

            return new AssetService(
                scheme,
                port,
                webComponents?.ToList(),
                sslCerts?.ToList(),
                exceptions?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                recent,
                portStates?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedPortState"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="port"></param>
        /// <returns> A new <see cref="Easm.ObservedPortState"/> instance for mocking. </returns>
        public static ObservedPortState ObservedPortState(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, ObservedPortStateValue? value = null, int? port = null)
        {
            return new ObservedPortState(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                port);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ResourceUri"/>. </summary>
        /// <param name="url"></param>
        /// <param name="resources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.ResourceUri"/> instance for mocking. </returns>
        public static ResourceUri ResourceUri(Uri url = null, IEnumerable<DependentResource> resources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null)
        {
            resources ??= new List<DependentResource>();

            return new ResourceUri(
                url,
                resources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DependentResource"/>. </summary>
        /// <param name="md5"></param>
        /// <param name="responseBodySize"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="firstSeenCrawlGuid"></param>
        /// <param name="firstSeenPageGuid"></param>
        /// <param name="firstSeenResourceGuid"></param>
        /// <param name="lastSeenCrawlGuid"></param>
        /// <param name="lastSeenPageGuid"></param>
        /// <param name="lastSeenResourceGuid"></param>
        /// <param name="responseBodyMinhash"></param>
        /// <param name="contentType"></param>
        /// <param name="sha256"></param>
        /// <param name="sha384"></param>
        /// <param name="sha512"></param>
        /// <param name="url"></param>
        /// <param name="cached"></param>
        /// <param name="sriChecks"></param>
        /// <param name="host"></param>
        /// <param name="lastObservedViolation"></param>
        /// <param name="lastObservedValidation"></param>
        /// <param name="lastObservedActualSriHash"></param>
        /// <param name="lastObservedExpectedSriHash"></param>
        /// <returns> A new <see cref="Easm.DependentResource"/> instance for mocking. </returns>
        public static DependentResource DependentResource(string md5 = null, long? responseBodySize = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, string firstSeenCrawlGuid = null, string firstSeenPageGuid = null, string firstSeenResourceGuid = null, string lastSeenCrawlGuid = null, string lastSeenPageGuid = null, string lastSeenResourceGuid = null, IEnumerable<int> responseBodyMinhash = null, string contentType = null, string sha256 = null, string sha384 = null, string sha512 = null, Uri url = null, bool? cached = null, IEnumerable<SubResourceIntegrityCheck> sriChecks = null, string host = null, DateTimeOffset? lastObservedViolation = null, DateTimeOffset? lastObservedValidation = null, string lastObservedActualSriHash = null, string lastObservedExpectedSriHash = null)
        {
            responseBodyMinhash ??= new List<int>();
            sriChecks ??= new List<SubResourceIntegrityCheck>();

            return new DependentResource(
                md5,
                responseBodySize,
                firstSeen,
                lastSeen,
                count,
                firstSeenCrawlGuid,
                firstSeenPageGuid,
                firstSeenResourceGuid,
                lastSeenCrawlGuid,
                lastSeenPageGuid,
                lastSeenResourceGuid,
                responseBodyMinhash?.ToList(),
                contentType,
                sha256,
                sha384,
                sha512,
                url,
                cached,
                sriChecks?.ToList(),
                host,
                lastObservedViolation,
                lastObservedValidation,
                lastObservedActualSriHash,
                lastObservedExpectedSriHash,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SubResourceIntegrityCheck"/>. </summary>
        /// <param name="violation"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="causePageUrl"></param>
        /// <param name="crawlGuid"></param>
        /// <param name="pageGuid"></param>
        /// <param name="resourceGuid"></param>
        /// <param name="expectedHash"></param>
        /// <returns> A new <see cref="Easm.SubResourceIntegrityCheck"/> instance for mocking. </returns>
        public static SubResourceIntegrityCheck SubResourceIntegrityCheck(bool? violation = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, string causePageUrl = null, string crawlGuid = null, string pageGuid = null, string resourceGuid = null, string expectedHash = null)
        {
            return new SubResourceIntegrityCheck(
                violation,
                firstSeen,
                lastSeen,
                count,
                causePageUrl,
                crawlGuid,
                pageGuid,
                resourceGuid,
                expectedHash,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ScanMetadata"/>. </summary>
        /// <param name="port"></param>
        /// <param name="bannerMetadata"></param>
        /// <param name="startScan"></param>
        /// <param name="endScan"></param>
        /// <returns> A new <see cref="Easm.ScanMetadata"/> instance for mocking. </returns>
        public static ScanMetadata ScanMetadata(int? port = null, string bannerMetadata = null, DateTimeOffset? startScan = null, DateTimeOffset? endScan = null)
        {
            return new ScanMetadata(port, bannerMetadata, startScan, endScan, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.IpBlock"/>. </summary>
        /// <param name="ipBlockName"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.IpBlock"/> instance for mocking. </returns>
        public static IpBlock IpBlock(string ipBlockName = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null)
        {
            sources ??= new List<SourceDetails>();

            return new IpBlock(
                ipBlockName,
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedLocation"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="value"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedLocation"/> instance for mocking. </returns>
        public static ObservedLocation ObservedLocation(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, ObservedLocationDetails value = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new ObservedLocation(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                value,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedLocationDetails"/>. </summary>
        /// <param name="countryCode"></param>
        /// <param name="countryName"></param>
        /// <param name="region"></param>
        /// <param name="regionName"></param>
        /// <param name="city"></param>
        /// <param name="areaCode"></param>
        /// <param name="postalCode"></param>
        /// <param name="latitude"></param>
        /// <param name="longitude"></param>
        /// <param name="dmaCode"></param>
        /// <param name="metroCodeId"></param>
        /// <returns> A new <see cref="Easm.ObservedLocationDetails"/> instance for mocking. </returns>
        public static ObservedLocationDetails ObservedLocationDetails(string countryCode = null, string countryName = null, string region = null, string regionName = null, string city = null, int? areaCode = null, string postalCode = null, float? latitude = null, float? longitude = null, int? dmaCode = null, int? metroCodeId = null)
        {
            return new ObservedLocationDetails(
                countryCode,
                countryName,
                region,
                regionName,
                city,
                areaCode,
                postalCode,
                latitude,
                longitude,
                dmaCode,
                metroCodeId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SslServerConfig"/>. </summary>
        /// <param name="tlsVersions"></param>
        /// <param name="cipherSuites"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.SslServerConfig"/> instance for mocking. </returns>
        public static SslServerConfig SslServerConfig(IEnumerable<string> tlsVersions = null, IEnumerable<string> cipherSuites = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<SourceDetails> sources = null)
        {
            tlsVersions ??= new List<string>();
            cipherSuites ??= new List<string>();
            sources ??= new List<SourceDetails>();

            return new SslServerConfig(
                tlsVersions?.ToList(),
                cipherSuites?.ToList(),
                firstSeen,
                lastSeen,
                count,
                sources?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.BannerDetails"/>. </summary>
        /// <param name="port"></param>
        /// <param name="bannerName"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="scanType"></param>
        /// <param name="bannerMetadata"></param>
        /// <param name="recent"></param>
        /// <param name="sha256"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.BannerDetails"/> instance for mocking. </returns>
        public static BannerDetails BannerDetails(int? port = null, string bannerName = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, string scanType = null, string bannerMetadata = null, bool? recent = null, string sha256 = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new BannerDetails(
                port,
                bannerName,
                firstSeen,
                lastSeen,
                count,
                scanType,
                bannerMetadata,
                recent,
                sha256,
                sources?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.IpAddressAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.IpAddressAssetResource"/> instance for mocking. </returns>
        public static IpAddressAssetResource IpAddressAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, IpAddressAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new IpAddressAssetResource(
                "ipAddress",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.IpAddressAsset"/>. </summary>
        /// <param name="ipAddress"></param>
        /// <param name="asns"></param>
        /// <param name="reputations"></param>
        /// <param name="webComponents"></param>
        /// <param name="netRanges"></param>
        /// <param name="headers"></param>
        /// <param name="attributes"></param>
        /// <param name="cookies"></param>
        /// <param name="sslCerts"></param>
        /// <param name="services"></param>
        /// <param name="ipBlocks"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="banners"></param>
        /// <param name="scanMetadata"></param>
        /// <param name="nsRecord"></param>
        /// <param name="mxRecord"></param>
        /// <param name="location"></param>
        /// <param name="hosts"></param>
        /// <param name="nxdomain"></param>
        /// <param name="sslServerConfig"></param>
        /// <param name="ipv4"></param>
        /// <param name="ipv6"></param>
        /// <returns> A new <see cref="Easm.IpAddressAsset"/> instance for mocking. </returns>
        public static IpAddressAsset IpAddressAsset(string ipAddress = null, IEnumerable<ObservedLong> asns = null, IEnumerable<ReputationDetails> reputations = null, IEnumerable<WebComponent> webComponents = null, IEnumerable<ObservedString> netRanges = null, IEnumerable<ObservedHeader> headers = null, IEnumerable<AttributeDetails> attributes = null, IEnumerable<CookieDetails> cookies = null, IEnumerable<SslCertAsset> sslCerts = null, IEnumerable<AssetService> services = null, IEnumerable<IpBlock> ipBlocks = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<BannerDetails> banners = null, IEnumerable<ScanMetadata> scanMetadata = null, IEnumerable<ObservedBoolean> nsRecord = null, IEnumerable<ObservedBoolean> mxRecord = null, IEnumerable<ObservedLocation> location = null, IEnumerable<ObservedString> hosts = null, IEnumerable<ObservedBoolean> nxdomain = null, IEnumerable<SslServerConfig> sslServerConfig = null, bool? ipv4 = null, bool? ipv6 = null)
        {
            asns ??= new List<ObservedLong>();
            reputations ??= new List<ReputationDetails>();
            webComponents ??= new List<WebComponent>();
            netRanges ??= new List<ObservedString>();
            headers ??= new List<ObservedHeader>();
            attributes ??= new List<AttributeDetails>();
            cookies ??= new List<CookieDetails>();
            sslCerts ??= new List<SslCertAsset>();
            services ??= new List<AssetService>();
            ipBlocks ??= new List<IpBlock>();
            sources ??= new List<SourceDetails>();
            banners ??= new List<BannerDetails>();
            scanMetadata ??= new List<ScanMetadata>();
            nsRecord ??= new List<ObservedBoolean>();
            mxRecord ??= new List<ObservedBoolean>();
            location ??= new List<ObservedLocation>();
            hosts ??= new List<ObservedString>();
            nxdomain ??= new List<ObservedBoolean>();
            sslServerConfig ??= new List<SslServerConfig>();

            return new IpAddressAsset(
                serializedAdditionalRawData: null,
                ipAddress,
                asns?.ToList(),
                reputations?.ToList(),
                webComponents?.ToList(),
                netRanges?.ToList(),
                headers?.ToList(),
                attributes?.ToList(),
                cookies?.ToList(),
                sslCerts?.ToList(),
                services?.ToList(),
                ipBlocks?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                banners?.ToList(),
                scanMetadata?.ToList(),
                nsRecord?.ToList(),
                mxRecord?.ToList(),
                location?.ToList(),
                hosts?.ToList(),
                nxdomain?.ToList(),
                sslServerConfig?.ToList(),
                ipv4,
                ipv6);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReputationDetails"/>. </summary>
        /// <param name="listName"></param>
        /// <param name="threatType"></param>
        /// <param name="trusted"></param>
        /// <param name="cidr"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="listUpdatedAt"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.ReputationDetails"/> instance for mocking. </returns>
        public static ReputationDetails ReputationDetails(string listName = null, string threatType = null, bool? trusted = null, string cidr = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, DateTimeOffset? listUpdatedAt = null, bool? recent = null)
        {
            return new ReputationDetails(
                listName,
                threatType,
                trusted,
                cidr,
                firstSeen,
                lastSeen,
                listUpdatedAt,
                recent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.IpBlockAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.IpBlockAssetResource"/> instance for mocking. </returns>
        public static IpBlockAssetResource IpBlockAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, IpBlockAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new IpBlockAssetResource(
                "ipBlock",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.IpBlockAsset"/>. </summary>
        /// <param name="ipBlock"></param>
        /// <param name="asns"></param>
        /// <param name="bgpPrefixes"></param>
        /// <param name="netNames"></param>
        /// <param name="registrantContacts"></param>
        /// <param name="registrantOrgs"></param>
        /// <param name="adminContacts"></param>
        /// <param name="technicalContacts"></param>
        /// <param name="registrarCreatedAt"></param>
        /// <param name="registrarUpdatedAt"></param>
        /// <param name="netRanges"></param>
        /// <param name="startIp"></param>
        /// <param name="endIp"></param>
        /// <param name="reputations"></param>
        /// <param name="detailedFromWhoisAt"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="location"></param>
        /// <param name="registrarExpiresAt"></param>
        /// <param name="registrantNames"></param>
        /// <param name="adminNames"></param>
        /// <param name="technicalNames"></param>
        /// <param name="adminOrgs"></param>
        /// <param name="technicalOrgs"></param>
        /// <param name="registrantPhones"></param>
        /// <param name="adminPhones"></param>
        /// <param name="technicalPhones"></param>
        /// <param name="ipv4"></param>
        /// <param name="ipv6"></param>
        /// <returns> A new <see cref="Easm.IpBlockAsset"/> instance for mocking. </returns>
        public static IpBlockAsset IpBlockAsset(string ipBlock = null, IEnumerable<ObservedLong> asns = null, IEnumerable<ObservedString> bgpPrefixes = null, IEnumerable<ObservedString> netNames = null, IEnumerable<ObservedString> registrantContacts = null, IEnumerable<ObservedString> registrantOrgs = null, IEnumerable<ObservedString> adminContacts = null, IEnumerable<ObservedString> technicalContacts = null, IEnumerable<ObservedLong> registrarCreatedAt = null, IEnumerable<ObservedLong> registrarUpdatedAt = null, IEnumerable<ObservedString> netRanges = null, string startIp = null, string endIp = null, IEnumerable<ReputationDetails> reputations = null, DateTimeOffset? detailedFromWhoisAt = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, IEnumerable<ObservedLocation> location = null, IEnumerable<ObservedLong> registrarExpiresAt = null, IEnumerable<ObservedString> registrantNames = null, IEnumerable<ObservedString> adminNames = null, IEnumerable<ObservedString> technicalNames = null, IEnumerable<ObservedString> adminOrgs = null, IEnumerable<ObservedString> technicalOrgs = null, IEnumerable<ObservedString> registrantPhones = null, IEnumerable<ObservedString> adminPhones = null, IEnumerable<ObservedString> technicalPhones = null, bool? ipv4 = null, bool? ipv6 = null)
        {
            asns ??= new List<ObservedLong>();
            bgpPrefixes ??= new List<ObservedString>();
            netNames ??= new List<ObservedString>();
            registrantContacts ??= new List<ObservedString>();
            registrantOrgs ??= new List<ObservedString>();
            adminContacts ??= new List<ObservedString>();
            technicalContacts ??= new List<ObservedString>();
            registrarCreatedAt ??= new List<ObservedLong>();
            registrarUpdatedAt ??= new List<ObservedLong>();
            netRanges ??= new List<ObservedString>();
            reputations ??= new List<ReputationDetails>();
            sources ??= new List<SourceDetails>();
            location ??= new List<ObservedLocation>();
            registrarExpiresAt ??= new List<ObservedLong>();
            registrantNames ??= new List<ObservedString>();
            adminNames ??= new List<ObservedString>();
            technicalNames ??= new List<ObservedString>();
            adminOrgs ??= new List<ObservedString>();
            technicalOrgs ??= new List<ObservedString>();
            registrantPhones ??= new List<ObservedString>();
            adminPhones ??= new List<ObservedString>();
            technicalPhones ??= new List<ObservedString>();

            return new IpBlockAsset(
                serializedAdditionalRawData: null,
                ipBlock,
                asns?.ToList(),
                bgpPrefixes?.ToList(),
                netNames?.ToList(),
                registrantContacts?.ToList(),
                registrantOrgs?.ToList(),
                adminContacts?.ToList(),
                technicalContacts?.ToList(),
                registrarCreatedAt?.ToList(),
                registrarUpdatedAt?.ToList(),
                netRanges?.ToList(),
                startIp,
                endIp,
                reputations?.ToList(),
                detailedFromWhoisAt,
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                location?.ToList(),
                registrarExpiresAt?.ToList(),
                registrantNames?.ToList(),
                adminNames?.ToList(),
                technicalNames?.ToList(),
                adminOrgs?.ToList(),
                technicalOrgs?.ToList(),
                registrantPhones?.ToList(),
                adminPhones?.ToList(),
                technicalPhones?.ToList(),
                ipv4,
                ipv6);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.PageAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.PageAssetResource"/> instance for mocking. </returns>
        public static PageAssetResource PageAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, PageAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new PageAssetResource(
                "page",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.PageAsset"/>. </summary>
        /// <param name="url"></param>
        /// <param name="httpMethod"></param>
        /// <param name="service"></param>
        /// <param name="ipAddresses"></param>
        /// <param name="successful"></param>
        /// <param name="httpResponseCodes"></param>
        /// <param name="httpResponseMessages"></param>
        /// <param name="responseTimes"></param>
        /// <param name="frames"></param>
        /// <param name="windows"></param>
        /// <param name="nonHtmlFrames"></param>
        /// <param name="undirectedContent"></param>
        /// <param name="contentTypes"></param>
        /// <param name="contentLengths"></param>
        /// <param name="windowNames"></param>
        /// <param name="charsets"></param>
        /// <param name="titles"></param>
        /// <param name="languages"></param>
        /// <param name="responseHeaders"></param>
        /// <param name="cookies"></param>
        /// <param name="webComponents"></param>
        /// <param name="attributes"></param>
        /// <param name="assetSecurityPolicies"></param>
        /// <param name="responseBodyMinhashSignatures"></param>
        /// <param name="fullDomMinhashSignatures"></param>
        /// <param name="responseBodyHashSignatures"></param>
        /// <param name="errors"></param>
        /// <param name="sslCerts"></param>
        /// <param name="sources"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="cause"></param>
        /// <param name="referrer"></param>
        /// <param name="redirectUrls"></param>
        /// <param name="redirectType"></param>
        /// <param name="finalUrls"></param>
        /// <param name="finalResponseCodes"></param>
        /// <param name="parkedPage"></param>
        /// <param name="resourceUrls"></param>
        /// <param name="guids"></param>
        /// <param name="finalIpAddresses"></param>
        /// <param name="asns"></param>
        /// <param name="ipBlocks"></param>
        /// <param name="finalAsns"></param>
        /// <param name="finalIpBlocks"></param>
        /// <param name="responseBodies"></param>
        /// <param name="domainAsset"></param>
        /// <param name="rootUrl"></param>
        /// <param name="isRootUrl"></param>
        /// <param name="location"></param>
        /// <param name="services"></param>
        /// <param name="siteStatus"></param>
        /// <param name="cnames"></param>
        /// <param name="cdns"></param>
        /// <param name="host"></param>
        /// <param name="domain"></param>
        /// <param name="sslServerConfig"></param>
        /// <param name="gdprAssetSecurityPolicies"></param>
        /// <param name="ipv4"></param>
        /// <param name="ipv6"></param>
        /// <returns> A new <see cref="Easm.PageAsset"/> instance for mocking. </returns>
        public static PageAsset PageAsset(Uri url = null, string httpMethod = null, string service = null, IEnumerable<ObservedString> ipAddresses = null, IEnumerable<ObservedBoolean> successful = null, IEnumerable<ObservedInteger> httpResponseCodes = null, IEnumerable<ObservedString> httpResponseMessages = null, IEnumerable<ObservedLong> responseTimes = null, IEnumerable<ObservedBoolean> frames = null, IEnumerable<ObservedBoolean> windows = null, IEnumerable<ObservedBoolean> nonHtmlFrames = null, IEnumerable<ObservedBoolean> undirectedContent = null, IEnumerable<ObservedString> contentTypes = null, IEnumerable<ObservedLong> contentLengths = null, IEnumerable<ObservedString> windowNames = null, IEnumerable<ObservedString> charsets = null, IEnumerable<ObservedString> titles = null, IEnumerable<ObservedString> languages = null, IEnumerable<ObservedHeader> responseHeaders = null, IEnumerable<CookieDetails> cookies = null, IEnumerable<WebComponent> webComponents = null, IEnumerable<AttributeDetails> attributes = null, IEnumerable<AssetSecurityPolicy> assetSecurityPolicies = null, IEnumerable<ObservedIntegers> responseBodyMinhashSignatures = null, IEnumerable<ObservedIntegers> fullDomMinhashSignatures = null, IEnumerable<ObservedString> responseBodyHashSignatures = null, IEnumerable<ObservedString> errors = null, IEnumerable<SslCertAsset> sslCerts = null, IEnumerable<SourceDetails> sources = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, PageCause cause = null, string referrer = null, IEnumerable<ObservedString> redirectUrls = null, PageAssetRedirectType? redirectType = null, IEnumerable<ObservedString> finalUrls = null, IEnumerable<ObservedInteger> finalResponseCodes = null, IEnumerable<ObservedBoolean> parkedPage = null, IEnumerable<ResourceUri> resourceUrls = null, IEnumerable<GuidPair> guids = null, IEnumerable<ObservedString> finalIpAddresses = null, IEnumerable<ObservedLong> asns = null, IEnumerable<IpBlock> ipBlocks = null, IEnumerable<ObservedLong> finalAsns = null, IEnumerable<IpBlock> finalIpBlocks = null, IEnumerable<ObservedString> responseBodies = null, DomainAsset domainAsset = null, ObservedBoolean rootUrl = null, bool? isRootUrl = null, IEnumerable<ObservedLocation> location = null, IEnumerable<AssetService> services = null, string siteStatus = null, IEnumerable<ObservedString> cnames = null, IEnumerable<ObservedString> cdns = null, string host = null, string domain = null, IEnumerable<SslServerConfig> sslServerConfig = null, IEnumerable<AssetSecurityPolicy> gdprAssetSecurityPolicies = null, IEnumerable<ObservedBoolean> ipv4 = null, IEnumerable<ObservedBoolean> ipv6 = null)
        {
            ipAddresses ??= new List<ObservedString>();
            successful ??= new List<ObservedBoolean>();
            httpResponseCodes ??= new List<ObservedInteger>();
            httpResponseMessages ??= new List<ObservedString>();
            responseTimes ??= new List<ObservedLong>();
            frames ??= new List<ObservedBoolean>();
            windows ??= new List<ObservedBoolean>();
            nonHtmlFrames ??= new List<ObservedBoolean>();
            undirectedContent ??= new List<ObservedBoolean>();
            contentTypes ??= new List<ObservedString>();
            contentLengths ??= new List<ObservedLong>();
            windowNames ??= new List<ObservedString>();
            charsets ??= new List<ObservedString>();
            titles ??= new List<ObservedString>();
            languages ??= new List<ObservedString>();
            responseHeaders ??= new List<ObservedHeader>();
            cookies ??= new List<CookieDetails>();
            webComponents ??= new List<WebComponent>();
            attributes ??= new List<AttributeDetails>();
            assetSecurityPolicies ??= new List<AssetSecurityPolicy>();
            responseBodyMinhashSignatures ??= new List<ObservedIntegers>();
            fullDomMinhashSignatures ??= new List<ObservedIntegers>();
            responseBodyHashSignatures ??= new List<ObservedString>();
            errors ??= new List<ObservedString>();
            sslCerts ??= new List<SslCertAsset>();
            sources ??= new List<SourceDetails>();
            redirectUrls ??= new List<ObservedString>();
            finalUrls ??= new List<ObservedString>();
            finalResponseCodes ??= new List<ObservedInteger>();
            parkedPage ??= new List<ObservedBoolean>();
            resourceUrls ??= new List<ResourceUri>();
            guids ??= new List<GuidPair>();
            finalIpAddresses ??= new List<ObservedString>();
            asns ??= new List<ObservedLong>();
            ipBlocks ??= new List<IpBlock>();
            finalAsns ??= new List<ObservedLong>();
            finalIpBlocks ??= new List<IpBlock>();
            responseBodies ??= new List<ObservedString>();
            location ??= new List<ObservedLocation>();
            services ??= new List<AssetService>();
            cnames ??= new List<ObservedString>();
            cdns ??= new List<ObservedString>();
            sslServerConfig ??= new List<SslServerConfig>();
            gdprAssetSecurityPolicies ??= new List<AssetSecurityPolicy>();
            ipv4 ??= new List<ObservedBoolean>();
            ipv6 ??= new List<ObservedBoolean>();

            return new PageAsset(
                serializedAdditionalRawData: null,
                url,
                httpMethod,
                service,
                ipAddresses?.ToList(),
                successful?.ToList(),
                httpResponseCodes?.ToList(),
                httpResponseMessages?.ToList(),
                responseTimes?.ToList(),
                frames?.ToList(),
                windows?.ToList(),
                nonHtmlFrames?.ToList(),
                undirectedContent?.ToList(),
                contentTypes?.ToList(),
                contentLengths?.ToList(),
                windowNames?.ToList(),
                charsets?.ToList(),
                titles?.ToList(),
                languages?.ToList(),
                responseHeaders?.ToList(),
                cookies?.ToList(),
                webComponents?.ToList(),
                attributes?.ToList(),
                assetSecurityPolicies?.ToList(),
                responseBodyMinhashSignatures?.ToList(),
                fullDomMinhashSignatures?.ToList(),
                responseBodyHashSignatures?.ToList(),
                errors?.ToList(),
                sslCerts?.ToList(),
                sources?.ToList(),
                firstSeen,
                lastSeen,
                count,
                cause,
                referrer,
                redirectUrls?.ToList(),
                redirectType,
                finalUrls?.ToList(),
                finalResponseCodes?.ToList(),
                parkedPage?.ToList(),
                resourceUrls?.ToList(),
                guids?.ToList(),
                finalIpAddresses?.ToList(),
                asns?.ToList(),
                ipBlocks?.ToList(),
                finalAsns?.ToList(),
                finalIpBlocks?.ToList(),
                responseBodies?.ToList(),
                domainAsset,
                rootUrl,
                isRootUrl,
                location?.ToList(),
                services?.ToList(),
                siteStatus,
                cnames?.ToList(),
                cdns?.ToList(),
                host,
                domain,
                sslServerConfig?.ToList(),
                gdprAssetSecurityPolicies?.ToList(),
                ipv4?.ToList(),
                ipv6?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AssetSecurityPolicy"/>. </summary>
        /// <param name="policyName"></param>
        /// <param name="isAffected"></param>
        /// <param name="description"></param>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.AssetSecurityPolicy"/> instance for mocking. </returns>
        public static AssetSecurityPolicy AssetSecurityPolicy(string policyName = null, bool? isAffected = null, string description = null, DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, IEnumerable<SourceDetails> sources = null)
        {
            sources ??= new List<SourceDetails>();

            return new AssetSecurityPolicy(
                policyName,
                isAffected,
                description,
                firstSeen,
                lastSeen,
                count,
                recent,
                sources?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ObservedIntegers"/>. </summary>
        /// <param name="firstSeen"></param>
        /// <param name="lastSeen"></param>
        /// <param name="count"></param>
        /// <param name="recent"></param>
        /// <param name="values"></param>
        /// <param name="sources"></param>
        /// <returns> A new <see cref="Easm.ObservedIntegers"/> instance for mocking. </returns>
        public static ObservedIntegers ObservedIntegers(DateTimeOffset? firstSeen = null, DateTimeOffset? lastSeen = null, long? count = null, bool? recent = null, IEnumerable<int> values = null, IEnumerable<SourceDetails> sources = null)
        {
            values ??= new List<int>();
            sources ??= new List<SourceDetails>();

            return new ObservedIntegers(
                firstSeen,
                lastSeen,
                count,
                recent,
                serializedAdditionalRawData: null,
                values?.ToList(),
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Easm.PageCause"/>. </summary>
        /// <param name="cause"></param>
        /// <param name="causeElementXPath"></param>
        /// <param name="location"></param>
        /// <param name="possibleMatches"></param>
        /// <param name="loopDetected"></param>
        /// <param name="version"></param>
        /// <param name="domChangeIndex"></param>
        /// <returns> A new <see cref="Easm.PageCause"/> instance for mocking. </returns>
        public static PageCause PageCause(string cause = null, string causeElementXPath = null, string location = null, int? possibleMatches = null, bool? loopDetected = null, int? version = null, int? domChangeIndex = null)
        {
            return new PageCause(
                cause,
                causeElementXPath,
                location,
                possibleMatches,
                loopDetected,
                version,
                domChangeIndex,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.GuidPair"/>. </summary>
        /// <param name="pageGuid"></param>
        /// <param name="crawlStateGuid"></param>
        /// <param name="loadDate"></param>
        /// <param name="recent"></param>
        /// <returns> A new <see cref="Easm.GuidPair"/> instance for mocking. </returns>
        public static GuidPair GuidPair(string pageGuid = null, string crawlStateGuid = null, DateTimeOffset? loadDate = null, bool? recent = null)
        {
            return new GuidPair(pageGuid, crawlStateGuid, loadDate, recent, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SslCertAssetResource"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="uuid"> Global UUID for the asset. </param>
        /// <param name="createdDate"> The date this asset was first added to this workspace. </param>
        /// <param name="updatedDate"> The date this asset was last updated for this workspace. </param>
        /// <param name="state"></param>
        /// <param name="externalId"> An optional customer provided identifier for this asset. </param>
        /// <param name="labels"> Customer labels assigned to this asset. </param>
        /// <param name="wildcard"> An indicator of whether this asset represents a wildcard rollup of assets on this domain. </param>
        /// <param name="discoGroupName"> The name of the DiscoGroup that brought added this asset to the workspace. </param>
        /// <param name="auditTrail"> The history of how this asset was pulled into the workspace through the discovery process. </param>
        /// <param name="reason"></param>
        /// <param name="asset"> asset. </param>
        /// <returns> A new <see cref="Easm.SslCertAssetResource"/> instance for mocking. </returns>
        public static SslCertAssetResource SslCertAssetResource(string id = null, string name = null, string displayName = null, Guid? uuid = null, DateTimeOffset? createdDate = null, DateTimeOffset? updatedDate = null, AssetState? state = null, string externalId = null, IEnumerable<string> labels = null, bool? wildcard = null, string discoGroupName = null, IEnumerable<AuditTrailItem> auditTrail = null, string reason = null, SslCertAsset asset = null)
        {
            labels ??= new List<string>();
            auditTrail ??= new List<AuditTrailItem>();

            return new SslCertAssetResource(
                "sslCert",
                id,
                name,
                displayName,
                uuid,
                createdDate,
                updatedDate,
                state,
                externalId,
                labels?.ToList(),
                wildcard,
                discoGroupName,
                auditTrail?.ToList(),
                reason,
                serializedAdditionalRawData: null,
                asset);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.TaskResource"/>. </summary>
        /// <param name="id"> The unique identifier of the task. </param>
        /// <param name="startedAt"> The time the task started. </param>
        /// <param name="completedAt"> The time the task completed. </param>
        /// <param name="lastPolledAt"> The last time the status of the task was updated. </param>
        /// <param name="state"> The state the task is in. </param>
        /// <param name="phase"> The phase the task is in. </param>
        /// <param name="reason"> The reason the task was moved into its current state, if the task wasn't completed. </param>
        /// <param name="metadata"> Attributes unique to the task.  This differs by task type. </param>
        /// <returns> A new <see cref="Easm.TaskResource"/> instance for mocking. </returns>
        public static TaskResource TaskResource(string id = null, DateTimeOffset? startedAt = null, DateTimeOffset? completedAt = null, DateTimeOffset? lastPolledAt = null, TaskResourceState? state = null, TaskResourcePhase? phase = null, string reason = null, IReadOnlyDictionary<string, BinaryData> metadata = null)
        {
            metadata ??= new Dictionary<string, BinaryData>();

            return new TaskResource(
                id,
                startedAt,
                completedAt,
                lastPolledAt,
                state,
                phase,
                reason,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DataConnection"/>. </summary>
        /// <param name="kind"> Discriminator property for DataConnection. </param>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="createdDate"> The date the data connection was created. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. </param>
        /// <param name="updatedDate"> The date the data connection was last updated. </param>
        /// <param name="userUpdatedAt"> The date the data connection was last updated by user. </param>
        /// <param name="active"> An indicator of whether the data connection is active. </param>
        /// <param name="inactiveMessage"> A message that specifies details about data connection if inactive. </param>
        /// <returns> A new <see cref="Easm.DataConnection"/> instance for mocking. </returns>
        public static DataConnection DataConnection(string kind = null, string id = null, string name = null, string displayName = null, DataConnectionContent? content = null, DateTimeOffset? createdDate = null, DataConnectionFrequency? frequency = null, int? frequencyOffset = null, DateTimeOffset? updatedDate = null, DateTimeOffset? userUpdatedAt = null, bool? active = null, string inactiveMessage = null)
        {
            return new UnknownDataConnection(
                kind,
                id,
                name,
                displayName,
                content,
                createdDate,
                frequency,
                frequencyOffset,
                updatedDate,
                userUpdatedAt,
                active,
                inactiveMessage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.LogAnalyticsDataConnection"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="createdDate"> The date the data connection was created. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. </param>
        /// <param name="updatedDate"> The date the data connection was last updated. </param>
        /// <param name="userUpdatedAt"> The date the data connection was last updated by user. </param>
        /// <param name="active"> An indicator of whether the data connection is active. </param>
        /// <param name="inactiveMessage"> A message that specifies details about data connection if inactive. </param>
        /// <param name="properties"> properties. </param>
        /// <returns> A new <see cref="Easm.LogAnalyticsDataConnection"/> instance for mocking. </returns>
        public static LogAnalyticsDataConnection LogAnalyticsDataConnection(string id = null, string name = null, string displayName = null, DataConnectionContent? content = null, DateTimeOffset? createdDate = null, DataConnectionFrequency? frequency = null, int? frequencyOffset = null, DateTimeOffset? updatedDate = null, DateTimeOffset? userUpdatedAt = null, bool? active = null, string inactiveMessage = null, LogAnalyticsDataConnectionProperties properties = null)
        {
            return new LogAnalyticsDataConnection(
                "logAnalytics",
                id,
                name,
                displayName,
                content,
                createdDate,
                frequency,
                frequencyOffset,
                updatedDate,
                userUpdatedAt,
                active,
                inactiveMessage,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AzureDataExplorerDataConnection"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="createdDate"> The date the data connection was created. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. </param>
        /// <param name="updatedDate"> The date the data connection was last updated. </param>
        /// <param name="userUpdatedAt"> The date the data connection was last updated by user. </param>
        /// <param name="active"> An indicator of whether the data connection is active. </param>
        /// <param name="inactiveMessage"> A message that specifies details about data connection if inactive. </param>
        /// <param name="properties"> properties. </param>
        /// <returns> A new <see cref="Easm.AzureDataExplorerDataConnection"/> instance for mocking. </returns>
        public static AzureDataExplorerDataConnection AzureDataExplorerDataConnection(string id = null, string name = null, string displayName = null, DataConnectionContent? content = null, DateTimeOffset? createdDate = null, DataConnectionFrequency? frequency = null, int? frequencyOffset = null, DateTimeOffset? updatedDate = null, DateTimeOffset? userUpdatedAt = null, bool? active = null, string inactiveMessage = null, AzureDataExplorerDataConnectionProperties properties = null)
        {
            return new AzureDataExplorerDataConnection(
                "azureDataExplorer",
                id,
                name,
                displayName,
                content,
                createdDate,
                frequency,
                frequencyOffset,
                updatedDate,
                userUpdatedAt,
                active,
                inactiveMessage,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.LogAnalyticsDataConnectionPayload"/>. </summary>
        /// <param name="name"> The name of data connection. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. (1-7 for weekly, 1-31 for monthly). </param>
        /// <param name="properties"> properties. </param>
        /// <returns> A new <see cref="Easm.LogAnalyticsDataConnectionPayload"/> instance for mocking. </returns>
        public static LogAnalyticsDataConnectionPayload LogAnalyticsDataConnectionPayload(string name = null, DataConnectionContent? content = null, DataConnectionFrequency? frequency = null, int? frequencyOffset = null, LogAnalyticsDataConnectionProperties properties = null)
        {
            return new LogAnalyticsDataConnectionPayload(
                "logAnalytics",
                name,
                content,
                frequency,
                frequencyOffset,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AzureDataExplorerDataConnectionPayload"/>. </summary>
        /// <param name="name"> The name of data connection. </param>
        /// <param name="content"> The type of data the data connection will transfer. </param>
        /// <param name="frequency"> The rate at which the data connection will receive updates. </param>
        /// <param name="frequencyOffset"> The day to update the data connection on. (1-7 for weekly, 1-31 for monthly). </param>
        /// <param name="properties"> properties. </param>
        /// <returns> A new <see cref="Easm.AzureDataExplorerDataConnectionPayload"/> instance for mocking. </returns>
        public static AzureDataExplorerDataConnectionPayload AzureDataExplorerDataConnectionPayload(string name = null, DataConnectionContent? content = null, DataConnectionFrequency? frequency = null, int? frequencyOffset = null, AzureDataExplorerDataConnectionProperties properties = null)
        {
            return new AzureDataExplorerDataConnectionPayload(
                "azureDataExplorer",
                name,
                content,
                frequency,
                frequencyOffset,
                serializedAdditionalRawData: null,
                properties);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ValidateResult"/>. </summary>
        /// <param name="error"> This is the top-level error object whose code matches the x-ms-error-code response header. </param>
        /// <returns> A new <see cref="Easm.ValidateResult"/> instance for mocking. </returns>
        public static ValidateResult ValidateResult(ErrorDetail error = null)
        {
            return new ValidateResult(error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ErrorDetail"/>. </summary>
        /// <param name="code"> This is one of a server-defined set of error codes. </param>
        /// <param name="message"> This is a human-readable representation of the error. </param>
        /// <param name="target"> This is the error target. </param>
        /// <param name="details"> This is an array of details about specific errors that led to this reported error. </param>
        /// <param name="innererror"> This is an object containing more specific information than the current object about the error. </param>
        /// <returns> A new <see cref="Easm.ErrorDetail"/> instance for mocking. </returns>
        public static ErrorDetail ErrorDetail(string code = null, string message = null, string target = null, IEnumerable<ErrorDetail> details = null, InnerError innererror = null)
        {
            details ??= new List<ErrorDetail>();

            return new ErrorDetail(
                code,
                message,
                target,
                details?.ToList(),
                innererror,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.InnerError"/>. </summary>
        /// <param name="code"> This is a more specific error code than was provided by the containing error. </param>
        /// <param name="value"> This is an additional field representing the value that caused the error to help with debugging. </param>
        /// <returns> A new <see cref="Easm.InnerError"/> instance for mocking. </returns>
        public static InnerError InnerError(string code = null, BinaryData value = null)
        {
            return new InnerError(code, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DiscoveryGroup"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="description"> The description for a disco group. </param>
        /// <param name="tier"> The tier for the disco group which will affect the algorithm used for the disco runs in this group. </param>
        /// <param name="frequencyMilliseconds"> The frequency at which the disco group is supposed to be rerun in milliseconds. </param>
        /// <param name="seeds"> The list of seeds used for the disco group runs. </param>
        /// <param name="names"> The list of names used for the disco group runs. </param>
        /// <param name="excludes"> The list of excludes used for the disco group runs, aka assets to exclude from the discovery algorithm. </param>
        /// <param name="latestRun"> The latest run of this disco group with some limited information, null if the group has never been run. </param>
        /// <param name="createdDate"> The date for the disco group was created. </param>
        /// <param name="templateId"> The unique identifier for the disco template used for the disco group creation. </param>
        /// <returns> A new <see cref="Easm.DiscoveryGroup"/> instance for mocking. </returns>
        public static DiscoveryGroup DiscoveryGroup(string id = null, string name = null, string displayName = null, string description = null, string tier = null, long? frequencyMilliseconds = null, IEnumerable<DiscoverySource> seeds = null, IEnumerable<string> names = null, IEnumerable<DiscoverySource> excludes = null, DiscoveryRunResult latestRun = null, DateTimeOffset? createdDate = null, string templateId = null)
        {
            seeds ??= new List<DiscoverySource>();
            names ??= new List<string>();
            excludes ??= new List<DiscoverySource>();

            return new DiscoveryGroup(
                id,
                name,
                displayName,
                description,
                tier,
                frequencyMilliseconds,
                seeds?.ToList(),
                names?.ToList(),
                excludes?.ToList(),
                latestRun,
                createdDate,
                templateId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DiscoveryRunResult"/>. </summary>
        /// <param name="submittedDate"> The date for when the disco run was created in the system. </param>
        /// <param name="startedDate"> The date for when the disco run was actually started by the system. </param>
        /// <param name="completedDate"> The date for when the disco run was completed by the system. </param>
        /// <param name="tier"> The tier which will affect the algorithm used for the disco run. </param>
        /// <param name="state"> The State of the disco run. </param>
        /// <param name="totalAssetsFoundCount"> The total count of assets that were found this disco run. </param>
        /// <param name="seeds"> The list of seeds used for the disco run. </param>
        /// <param name="excludes"> The list of excludes used for the disco run, aka assets to exclude from the discovery algorithm. </param>
        /// <param name="names"> The list of names used for the disco run. </param>
        /// <returns> A new <see cref="Easm.DiscoveryRunResult"/> instance for mocking. </returns>
        public static DiscoveryRunResult DiscoveryRunResult(DateTimeOffset? submittedDate = null, DateTimeOffset? startedDate = null, DateTimeOffset? completedDate = null, string tier = null, DiscoRunState? state = null, long? totalAssetsFoundCount = null, IEnumerable<DiscoverySource> seeds = null, IEnumerable<DiscoverySource> excludes = null, IEnumerable<string> names = null)
        {
            seeds ??= new List<DiscoverySource>();
            excludes ??= new List<DiscoverySource>();
            names ??= new List<string>();

            return new DiscoveryRunResult(
                submittedDate,
                startedDate,
                completedDate,
                tier,
                state,
                totalAssetsFoundCount,
                seeds?.ToList(),
                excludes?.ToList(),
                names?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.DiscoveryTemplate"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="industry"> The name of the industry. </param>
        /// <param name="region"> The name of the region. </param>
        /// <param name="countryCode"> The country code. </param>
        /// <param name="stateCode"> The state code. </param>
        /// <param name="city"> The name of the city. </param>
        /// <param name="seeds"> The list of disco template seeds. </param>
        /// <param name="names"> The list of disco template names. </param>
        /// <returns> A new <see cref="Easm.DiscoveryTemplate"/> instance for mocking. </returns>
        public static DiscoveryTemplate DiscoveryTemplate(string id = null, string name = null, string displayName = null, string industry = null, string region = null, string countryCode = null, string stateCode = null, string city = null, IEnumerable<DiscoverySource> seeds = null, IEnumerable<string> names = null)
        {
            seeds ??= new List<DiscoverySource>();
            names ??= new List<string>();

            return new DiscoveryTemplate(
                id,
                name,
                displayName,
                industry,
                region,
                countryCode,
                stateCode,
                city,
                seeds?.ToList(),
                names?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReportBillableAssetSummaryResult"/>. </summary>
        /// <param name="assetSummaries"></param>
        /// <returns> A new <see cref="Easm.ReportBillableAssetSummaryResult"/> instance for mocking. </returns>
        public static ReportBillableAssetSummaryResult ReportBillableAssetSummaryResult(IEnumerable<ReportBillableAssetSnapshotResult> assetSummaries = null)
        {
            assetSummaries ??= new List<ReportBillableAssetSnapshotResult>();

            return new ReportBillableAssetSummaryResult(assetSummaries?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReportBillableAssetSnapshotResult"/>. </summary>
        /// <param name="date"> The date these assets were billed on. </param>
        /// <param name="total"> The total number of billable assets for this date. </param>
        /// <param name="assetBreakdown"> The breakdown of billable asset counts for each asset type. </param>
        /// <returns> A new <see cref="Easm.ReportBillableAssetSnapshotResult"/> instance for mocking. </returns>
        public static ReportBillableAssetSnapshotResult ReportBillableAssetSnapshotResult(DateTimeOffset? date = null, long? total = null, IEnumerable<ReportBillableAssetBreakdown> assetBreakdown = null)
        {
            assetBreakdown ??= new List<ReportBillableAssetBreakdown>();

            return new ReportBillableAssetSnapshotResult(date, total, assetBreakdown?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReportBillableAssetBreakdown"/>. </summary>
        /// <param name="kind"> The kind of billable asset. </param>
        /// <param name="count"> The number of assets of this type. </param>
        /// <returns> A new <see cref="Easm.ReportBillableAssetBreakdown"/> instance for mocking. </returns>
        public static ReportBillableAssetBreakdown ReportBillableAssetBreakdown(ReportBillableAssetBreakdownKind? kind = null, long? count = null)
        {
            return new ReportBillableAssetBreakdown(kind, count, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReportAssetSnapshotResult"/>. </summary>
        /// <param name="displayName"> The name of the metric. </param>
        /// <param name="metric"> The unique metric name. </param>
        /// <param name="labelName"> The customer label that was filtered on, if one was provided. </param>
        /// <param name="updatedAt"> The last time this asset data was updated on this metric. </param>
        /// <param name="description"> A description of what the metric represents. </param>
        /// <param name="assets"> The page of assets that match the provided metric. </param>
        /// <returns> A new <see cref="Easm.ReportAssetSnapshotResult"/> instance for mocking. </returns>
        public static ReportAssetSnapshotResult ReportAssetSnapshotResult(string displayName = null, string metric = null, string labelName = null, DateTimeOffset? updatedAt = null, string description = null, AssetPageResult assets = null)
        {
            return new ReportAssetSnapshotResult(
                displayName,
                metric,
                labelName,
                updatedAt,
                description,
                assets,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AssetPageResult"/>. </summary>
        /// <param name="totalElements"> The total number of items available in the full result set. </param>
        /// <param name="mark"> The cursor mark to be used on the next request.  Not set if using paging. </param>
        /// <param name="nextLink"> The link to access the next page of results.  Not set if at the end of the result set. </param>
        /// <param name="value">
        /// The items in the current page of results.
        /// Please note <see cref="Easm.AssetResource"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Easm.AsAssetResource"/>, <see cref="Easm.ContactAssetResource"/>, <see cref="Easm.DomainAssetResource"/>, <see cref="Easm.HostAssetResource"/>, <see cref="Easm.IpAddressAssetResource"/>, <see cref="Easm.IpBlockAssetResource"/>, <see cref="Easm.PageAssetResource"/> and <see cref="Easm.SslCertAssetResource"/>.
        /// </param>
        /// <returns> A new <see cref="Easm.AssetPageResult"/> instance for mocking. </returns>
        public static AssetPageResult AssetPageResult(long? totalElements = null, string mark = null, string nextLink = null, IEnumerable<AssetResource> value = null)
        {
            value ??= new List<AssetResource>();

            return new AssetPageResult(totalElements, mark, nextLink, value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.ReportAssetSummaryResult"/>. </summary>
        /// <param name="assetSummaries"> The collection of asset summaries. </param>
        /// <returns> A new <see cref="Easm.ReportAssetSummaryResult"/> instance for mocking. </returns>
        public static ReportAssetSummaryResult ReportAssetSummaryResult(IEnumerable<AssetSummaryResult> assetSummaries = null)
        {
            assetSummaries ??= new List<AssetSummaryResult>();

            return new ReportAssetSummaryResult(assetSummaries?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.AssetSummaryResult"/>. </summary>
        /// <param name="displayName"> The name of the summary response.  Depending on the request time this will either be the asset filter, risk category, or risk metric. </param>
        /// <param name="description"> The description of the summary response.  Filters don't have a description. </param>
        /// <param name="updatedAt"> The last time risk categories or risk metrics were captured. Set to the current time for asset filter requests, which always pull the live asset data. </param>
        /// <param name="metricCategory"> If the request is for a metric category, this will contain the requested unique category name. </param>
        /// <param name="metric"> If the request is for a metric, this will contain the requested unique metric name. </param>
        /// <param name="filter"> If the request is for an asset filter, this will contain the corresponding filter. </param>
        /// <param name="labelName"> An optional label used to filter requests results. </param>
        /// <param name="count"> The count of assets matching the request parameters. </param>
        /// <param name="link"> The link to the corresponding asset details. </param>
        /// <param name="children"> The corresponding child entities.  For metric categories this will contain metrics.  For filters with groupBy and segmentBy this will contain facets. </param>
        /// <returns> A new <see cref="Easm.AssetSummaryResult"/> instance for mocking. </returns>
        public static AssetSummaryResult AssetSummaryResult(string displayName = null, string description = null, DateTimeOffset? updatedAt = null, string metricCategory = null, string metric = null, string filter = null, string labelName = null, long? count = null, string link = null, IEnumerable<AssetSummaryResult> children = null)
        {
            children ??= new List<AssetSummaryResult>();

            return new AssetSummaryResult(
                displayName,
                description,
                updatedAt,
                metricCategory,
                metric,
                filter,
                labelName,
                count,
                link,
                children?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Easm.SavedFilter"/>. </summary>
        /// <param name="id"> The system generated unique id for the resource. </param>
        /// <param name="name"> The caller provided unique name for the resource. </param>
        /// <param name="displayName"> The name that can be used for display purposes. </param>
        /// <param name="filter"></param>
        /// <param name="description"></param>
        /// <returns> A new <see cref="Easm.SavedFilter"/> instance for mocking. </returns>
        public static SavedFilter SavedFilter(string id = null, string name = null, string displayName = null, string filter = null, string description = null)
        {
            return new SavedFilter(
                id,
                name,
                displayName,
                filter,
                description,
                serializedAdditionalRawData: null);
        }
    }
}
