// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Indicates whether metrics are being sent. </summary>
    public readonly partial struct MetricsSendingStatus : IEquatable<MetricsSendingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricsSendingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricsSendingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static MetricsSendingStatus Enabled { get; } = new MetricsSendingStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static MetricsSendingStatus Disabled { get; } = new MetricsSendingStatus(DisabledValue);
        /// <summary> Determines if two <see cref="MetricsSendingStatus"/> values are the same. </summary>
        public static bool operator ==(MetricsSendingStatus left, MetricsSendingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricsSendingStatus"/> values are not the same. </summary>
        public static bool operator !=(MetricsSendingStatus left, MetricsSendingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricsSendingStatus"/>. </summary>
        public static implicit operator MetricsSendingStatus(string value) => new MetricsSendingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricsSendingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricsSendingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
