// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Indicates whether logs are being sent. </summary>
    public readonly partial struct LogsSendingStatus : IEquatable<LogsSendingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogsSendingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogsSendingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static LogsSendingStatus Enabled { get; } = new LogsSendingStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static LogsSendingStatus Disabled { get; } = new LogsSendingStatus(DisabledValue);
        /// <summary> Determines if two <see cref="LogsSendingStatus"/> values are the same. </summary>
        public static bool operator ==(LogsSendingStatus left, LogsSendingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogsSendingStatus"/> values are not the same. </summary>
        public static bool operator !=(LogsSendingStatus left, LogsSendingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogsSendingStatus"/>. </summary>
        public static implicit operator LogsSendingStatus(string value) => new LogsSendingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogsSendingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogsSendingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
