// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Indicates whether SSO is enabled or not. </summary>
    public readonly partial struct DynatraceSsoStatus : IEquatable<DynatraceSsoStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceSsoStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceSsoStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DynatraceSsoStatus Enabled { get; } = new DynatraceSsoStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DynatraceSsoStatus Disabled { get; } = new DynatraceSsoStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DynatraceSsoStatus"/> values are the same. </summary>
        public static bool operator ==(DynatraceSsoStatus left, DynatraceSsoStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceSsoStatus"/> values are not the same. </summary>
        public static bool operator !=(DynatraceSsoStatus left, DynatraceSsoStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceSsoStatus"/>. </summary>
        public static implicit operator DynatraceSsoStatus(string value) => new DynatraceSsoStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceSsoStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceSsoStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
