// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> The current update status of OneAgent. </summary>
    public readonly partial struct DynatraceOneAgentUpdateStatus : IEquatable<DynatraceOneAgentUpdateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceOneAgentUpdateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceOneAgentUpdateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncompatibleValue = "INCOMPATIBLE";
        private const string OutdatedValue = "OUTDATED";
        private const string ScheduledValue = "SCHEDULED";
        private const string SuppressedValue = "SUPPRESSED";
        private const string UnknownValue = "UNKNOWN";
        private const string UpToDateValue = "UP2DATE";
        private const string UpdateInProgressValue = "UPDATE_IN_PROGRESS";
        private const string UpdatePendingValue = "UPDATE_PENDING";
        private const string UpdateProblemValue = "UPDATE_PROBLEM";

        /// <summary> INCOMPATIBLE. </summary>
        public static DynatraceOneAgentUpdateStatus Incompatible { get; } = new DynatraceOneAgentUpdateStatus(IncompatibleValue);
        /// <summary> OUTDATED. </summary>
        public static DynatraceOneAgentUpdateStatus Outdated { get; } = new DynatraceOneAgentUpdateStatus(OutdatedValue);
        /// <summary> SCHEDULED. </summary>
        public static DynatraceOneAgentUpdateStatus Scheduled { get; } = new DynatraceOneAgentUpdateStatus(ScheduledValue);
        /// <summary> SUPPRESSED. </summary>
        public static DynatraceOneAgentUpdateStatus Suppressed { get; } = new DynatraceOneAgentUpdateStatus(SuppressedValue);
        /// <summary> UNKNOWN. </summary>
        public static DynatraceOneAgentUpdateStatus Unknown { get; } = new DynatraceOneAgentUpdateStatus(UnknownValue);
        /// <summary> UP2DATE. </summary>
        public static DynatraceOneAgentUpdateStatus UpToDate { get; } = new DynatraceOneAgentUpdateStatus(UpToDateValue);
        /// <summary> UPDATE_IN_PROGRESS. </summary>
        public static DynatraceOneAgentUpdateStatus UpdateInProgress { get; } = new DynatraceOneAgentUpdateStatus(UpdateInProgressValue);
        /// <summary> UPDATE_PENDING. </summary>
        public static DynatraceOneAgentUpdateStatus UpdatePending { get; } = new DynatraceOneAgentUpdateStatus(UpdatePendingValue);
        /// <summary> UPDATE_PROBLEM. </summary>
        public static DynatraceOneAgentUpdateStatus UpdateProblem { get; } = new DynatraceOneAgentUpdateStatus(UpdateProblemValue);
        /// <summary> Determines if two <see cref="DynatraceOneAgentUpdateStatus"/> values are the same. </summary>
        public static bool operator ==(DynatraceOneAgentUpdateStatus left, DynatraceOneAgentUpdateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceOneAgentUpdateStatus"/> values are not the same. </summary>
        public static bool operator !=(DynatraceOneAgentUpdateStatus left, DynatraceOneAgentUpdateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceOneAgentUpdateStatus"/>. </summary>
        public static implicit operator DynatraceOneAgentUpdateStatus(string value) => new DynatraceOneAgentUpdateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceOneAgentUpdateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceOneAgentUpdateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
