// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Details of App Services having Dynatrace OneAgent installed. </summary>
    public partial class DynatraceOneAgentEnabledAppServiceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DynatraceOneAgentEnabledAppServiceInfo"/>. </summary>
        internal DynatraceOneAgentEnabledAppServiceInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DynatraceOneAgentEnabledAppServiceInfo"/>. </summary>
        /// <param name="resourceId"> App service resource ID. </param>
        /// <param name="version"> Version of the Dynatrace agent installed on the App Service. </param>
        /// <param name="monitoringType"> The monitoring mode of OneAgent. </param>
        /// <param name="autoUpdateSetting"> Update settings of OneAgent. </param>
        /// <param name="updateStatus"> The current update status of OneAgent. </param>
        /// <param name="availabilityState"> The availability state of OneAgent. </param>
        /// <param name="logModule"> Tells whether log modules are enabled or not. </param>
        /// <param name="hostGroup"> The name of the host group. </param>
        /// <param name="hostName"> The name of the host. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DynatraceOneAgentEnabledAppServiceInfo(ResourceIdentifier resourceId, string version, DynatraceOneAgentMonitoringType? monitoringType, DynatraceOneAgentAutoUpdateSetting? autoUpdateSetting, DynatraceOneAgentUpdateStatus? updateStatus, DynatraceOneAgentAvailabilityState? availabilityState, DynatraceLogModuleState? logModule, string hostGroup, string hostName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            Version = version;
            MonitoringType = monitoringType;
            AutoUpdateSetting = autoUpdateSetting;
            UpdateStatus = updateStatus;
            AvailabilityState = availabilityState;
            LogModule = logModule;
            HostGroup = hostGroup;
            HostName = hostName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> App service resource ID. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> Version of the Dynatrace agent installed on the App Service. </summary>
        public string Version { get; }
        /// <summary> The monitoring mode of OneAgent. </summary>
        public DynatraceOneAgentMonitoringType? MonitoringType { get; }
        /// <summary> Update settings of OneAgent. </summary>
        public DynatraceOneAgentAutoUpdateSetting? AutoUpdateSetting { get; }
        /// <summary> The current update status of OneAgent. </summary>
        public DynatraceOneAgentUpdateStatus? UpdateStatus { get; }
        /// <summary> The availability state of OneAgent. </summary>
        public DynatraceOneAgentAvailabilityState? AvailabilityState { get; }
        /// <summary> Tells whether log modules are enabled or not. </summary>
        public DynatraceLogModuleState? LogModule { get; }
        /// <summary> The name of the host group. </summary>
        public string HostGroup { get; }
        /// <summary> The name of the host. </summary>
        public string HostName { get; }
    }
}
