// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> The availability state of OneAgent. </summary>
    public readonly partial struct DynatraceOneAgentAvailabilityState : IEquatable<DynatraceOneAgentAvailabilityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceOneAgentAvailabilityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceOneAgentAvailabilityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CrashedValue = "CRASHED";
        private const string LostValue = "LOST";
        private const string MonitoredValue = "MONITORED";
        private const string PreMonitoredValue = "PRE_MONITORED";
        private const string ShutdownValue = "SHUTDOWN";
        private const string UnexpectedShutdownValue = "UNEXPECTED_SHUTDOWN";
        private const string UnknownValue = "UNKNOWN";
        private const string UnmonitoredValue = "UNMONITORED";

        /// <summary> CRASHED. </summary>
        public static DynatraceOneAgentAvailabilityState Crashed { get; } = new DynatraceOneAgentAvailabilityState(CrashedValue);
        /// <summary> LOST. </summary>
        public static DynatraceOneAgentAvailabilityState Lost { get; } = new DynatraceOneAgentAvailabilityState(LostValue);
        /// <summary> MONITORED. </summary>
        public static DynatraceOneAgentAvailabilityState Monitored { get; } = new DynatraceOneAgentAvailabilityState(MonitoredValue);
        /// <summary> PRE_MONITORED. </summary>
        public static DynatraceOneAgentAvailabilityState PreMonitored { get; } = new DynatraceOneAgentAvailabilityState(PreMonitoredValue);
        /// <summary> SHUTDOWN. </summary>
        public static DynatraceOneAgentAvailabilityState Shutdown { get; } = new DynatraceOneAgentAvailabilityState(ShutdownValue);
        /// <summary> UNEXPECTED_SHUTDOWN. </summary>
        public static DynatraceOneAgentAvailabilityState UnexpectedShutdown { get; } = new DynatraceOneAgentAvailabilityState(UnexpectedShutdownValue);
        /// <summary> UNKNOWN. </summary>
        public static DynatraceOneAgentAvailabilityState Unknown { get; } = new DynatraceOneAgentAvailabilityState(UnknownValue);
        /// <summary> UNMONITORED. </summary>
        public static DynatraceOneAgentAvailabilityState Unmonitored { get; } = new DynatraceOneAgentAvailabilityState(UnmonitoredValue);
        /// <summary> Determines if two <see cref="DynatraceOneAgentAvailabilityState"/> values are the same. </summary>
        public static bool operator ==(DynatraceOneAgentAvailabilityState left, DynatraceOneAgentAvailabilityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceOneAgentAvailabilityState"/> values are not the same. </summary>
        public static bool operator !=(DynatraceOneAgentAvailabilityState left, DynatraceOneAgentAvailabilityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceOneAgentAvailabilityState"/>. </summary>
        public static implicit operator DynatraceOneAgentAvailabilityState(string value) => new DynatraceOneAgentAvailabilityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceOneAgentAvailabilityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceOneAgentAvailabilityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
