// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Flag specifying if the resource monitoring is enabled or disabled. </summary>
    public readonly partial struct DynatraceMonitoringStatus : IEquatable<DynatraceMonitoringStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceMonitoringStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceMonitoringStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DynatraceMonitoringStatus Enabled { get; } = new DynatraceMonitoringStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DynatraceMonitoringStatus Disabled { get; } = new DynatraceMonitoringStatus(DisabledValue);
        /// <summary> Determines if two <see cref="DynatraceMonitoringStatus"/> values are the same. </summary>
        public static bool operator ==(DynatraceMonitoringStatus left, DynatraceMonitoringStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceMonitoringStatus"/> values are not the same. </summary>
        public static bool operator !=(DynatraceMonitoringStatus left, DynatraceMonitoringStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceMonitoringStatus"/>. </summary>
        public static implicit operator DynatraceMonitoringStatus(string value) => new DynatraceMonitoringStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceMonitoringStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceMonitoringStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
