// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Valid actions for a filtering tag. Exclusion takes priority over inclusion. </summary>
    public readonly partial struct DynatraceMonitorResourceTagAction : IEquatable<DynatraceMonitorResourceTagAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceMonitorResourceTagAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceMonitorResourceTagAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncludeValue = "Include";
        private const string ExcludeValue = "Exclude";

        /// <summary> Include. </summary>
        public static DynatraceMonitorResourceTagAction Include { get; } = new DynatraceMonitorResourceTagAction(IncludeValue);
        /// <summary> Exclude. </summary>
        public static DynatraceMonitorResourceTagAction Exclude { get; } = new DynatraceMonitorResourceTagAction(ExcludeValue);
        /// <summary> Determines if two <see cref="DynatraceMonitorResourceTagAction"/> values are the same. </summary>
        public static bool operator ==(DynatraceMonitorResourceTagAction left, DynatraceMonitorResourceTagAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceMonitorResourceTagAction"/> values are not the same. </summary>
        public static bool operator !=(DynatraceMonitorResourceTagAction left, DynatraceMonitorResourceTagAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceMonitorResourceTagAction"/>. </summary>
        public static implicit operator DynatraceMonitorResourceTagAction(string value) => new DynatraceMonitorResourceTagAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceMonitorResourceTagAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceMonitorResourceTagAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
